/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import java.util.Formatter;
import java.util.Locale;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.ILogLevelModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.tramoseats.base.core.tramo.internal.TramoUtility;
import lombok.Generated;

public class LogLevelModule
implements ILogLevelModule {
    private static final String LL = "log-level test";
    private static final String NEG = "negative values, levels are chosen";
    private static final String FAILED = "log/level failed";
    private static final String LOGS = "logs are chosen";
    private static final String LEVELS = "levels are chosen";
    private final double logpreference;
    private final double precision;
    private final boolean seasonal;
    private double level;
    private double log = 1.0;
    private double slog;
    private RegArimaEstimation<SarimaModel> e;
    private RegArimaEstimation<SarimaModel> el;

    public static Builder builder() {
        return new Builder();
    }

    private LogLevelModule(double logpreference, double precision, boolean seasonal) {
        this.logpreference = logpreference;
        this.precision = precision;
        this.seasonal = seasonal;
    }

    public void clear() {
        this.level = 0.0;
        this.log = 1.0;
        this.e = null;
        this.el = null;
    }

    public RegArimaEstimation<SarimaModel> getLevelEstimation() {
        return this.e;
    }

    public double getLevelLL() {
        return this.level;
    }

    public RegArimaEstimation<SarimaModel> getLogEstimation() {
        return this.el;
    }

    public double getLogLL() {
        return this.log;
    }

    public double getLogPreference() {
        return this.logpreference;
    }

    public boolean isChoosingLog() {
        return this.el == null ? false : this.log + this.logpreference < this.level;
    }

    public double getLogCorrection() {
        return this.slog;
    }

    public boolean process(DoubleSeq data, int frequency, FastMatrix variables, boolean seas, ProcessingLog log) {
        RegArimaModel regarima = RegArimaUtility.airlineModel((DoubleSeq)data, (boolean)true, (int)frequency, (boolean)seas);
        if (!variables.isEmpty()) {
            regarima = regarima.toBuilder().addX(variables).build();
        }
        return this.process((RegArimaModel<SarimaModel>)regarima, log);
    }

    public boolean process(RegArimaModel<SarimaModel> model, ProcessingLog logs) {
        IRegArimaComputer<SarimaModel> processor = TramoUtility.processor(true, this.precision);
        this.e = processor.process(model, null);
        if (this.e != null) {
            this.level = Math.log(this.e.getConcentratedLikelihood().ssq() * this.e.getConcentratedLikelihood().factor());
        }
        double[] lx = model.getY().toArray();
        this.slog = 0.0;
        for (int i = 0; i < lx.length; ++i) {
            if (lx[i] <= 0.0) {
                return false;
            }
            lx[i] = Math.log(lx[i]);
            this.slog += lx[i];
        }
        this.slog /= (double)lx.length;
        RegArimaModel logModel = model.toBuilder().y(DoubleSeq.of((double[])lx)).build();
        this.el = processor.process(logModel, null);
        if (this.el != null) {
            this.log = Math.log(this.el.getConcentratedLikelihood().ssq() * this.el.getConcentratedLikelihood().factor()) + 2.0 * this.slog;
        }
        return true;
    }

    public TransformationType getTransformation() {
        return this.isChoosingLog() ? TransformationType.Log : TransformationType.None;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult process(RegSarimaModelling context) {
        ProcessingLog logs = context.getLog();
        logs.push(LL);
        try {
            ModelDescription desc = context.getDescription();
            DoubleSeq data = desc.getTransformedSeries().getValues();
            if (data.anyMatch(x -> x <= 0.0)) {
                logs.remark(NEG);
                ProcessingResult processingResult = ProcessingResult.Unchanged;
                return processingResult;
            }
            FastMatrix variables = desc.regarima().variables();
            if (!this.process(data, desc.getAnnualFrequency(), variables, this.seasonal, logs)) {
                logs.warning(FAILED);
                ProcessingResult processingResult = ProcessingResult.Failed;
                return processingResult;
            }
            Info info = new Info(this.log, this.level, this.logpreference);
            if (this.isChoosingLog()) {
                desc.setLogTransformation(true);
                context.clearEstimation();
                logs.info(LOGS, (Object)info);
                ProcessingResult processingResult = ProcessingResult.Changed;
                return processingResult;
            }
            logs.info(LEVELS, (Object)info);
            ProcessingResult processingResult = ProcessingResult.Unchanged;
            return processingResult;
        }
        catch (RuntimeException err) {
            ProcessingResult processingResult = ProcessingResult.Failed;
            return processingResult;
        }
        finally {
            logs.pop();
        }
    }

    public static class Builder {
        private double precision = 1.0E-5;
        private double logpreference = 0.0;
        private boolean seasonal = true;

        public Builder logPreference(double lp) {
            this.logpreference = lp;
            return this;
        }

        public Builder estimationPrecision(double eps) {
            this.precision = eps;
            return this;
        }

        public Builder seasonal(boolean seasonal) {
            this.seasonal = seasonal;
            return this;
        }

        public LogLevelModule build() {
            return new LogLevelModule(this.logpreference, this.precision, this.seasonal);
        }
    }

    public static class Info {
        private final double logs;
        private final double levels;
        private final double logpreference;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("-LogLikelihood on logs=").append(new Formatter(Locale.ROOT).format("%6g", this.logs)).append("; ").append("-LogLikelihood on levels=").append(new Formatter(Locale.ROOT).format("%6g", this.levels)).append("; ").append("(log-preference)=").append(new Formatter(Locale.ROOT).format("%6g", this.logpreference)).append(')');
            return builder.toString();
        }

        @Generated
        public double getLogs() {
            return this.logs;
        }

        @Generated
        public double getLevels() {
            return this.levels;
        }

        @Generated
        public double getLogpreference() {
            return this.logpreference;
        }

        @Generated
        public Info(double logs, double levels, double logpreference) {
            this.logs = logs;
            this.levels = levels;
            this.logpreference = logpreference;
        }
    }
}

