/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5VLnative_H
#define H5VLnative_H

#include "H5Apublic.h"  
#include "H5VLpublic.h" 

#define H5VL_NATIVE (H5OPEN H5VL_NATIVE_g)

#define H5VL_NATIVE_NAME    "native"
#define H5VL_NATIVE_VALUE   H5_VOL_NATIVE 
#define H5VL_NATIVE_VERSION 0

#ifndef H5_NO_DEPRECATED_SYMBOLS
#define H5VL_NATIVE_ATTR_ITERATE_OLD 0 
#endif                                 

#ifndef H5_NO_DEPRECATED_SYMBOLS

typedef struct H5VL_native_attr_iterate_old_t {
    hid_t           loc_id;
    unsigned       *attr_num;
    H5A_operator1_t op;
    void           *op_data;
} H5VL_native_attr_iterate_old_t;

typedef union H5VL_native_attr_optional_args_t {
    
    H5VL_native_attr_iterate_old_t iterate_old;
} H5VL_native_attr_optional_args_t;
#endif 

#define H5VL_NATIVE_DATASET_FORMAT_CONVERT          0  
#define H5VL_NATIVE_DATASET_GET_CHUNK_INDEX_TYPE    1  
#define H5VL_NATIVE_DATASET_GET_CHUNK_STORAGE_SIZE  2  
#define H5VL_NATIVE_DATASET_GET_NUM_CHUNKS          3  
#define H5VL_NATIVE_DATASET_GET_CHUNK_INFO_BY_IDX   4  
#define H5VL_NATIVE_DATASET_GET_CHUNK_INFO_BY_COORD 5  
#define H5VL_NATIVE_DATASET_CHUNK_READ              6  
#define H5VL_NATIVE_DATASET_CHUNK_WRITE             7  
#define H5VL_NATIVE_DATASET_GET_VLEN_BUF_SIZE       8  
#define H5VL_NATIVE_DATASET_GET_OFFSET              9  
#define H5VL_NATIVE_DATASET_CHUNK_ITER              10 

typedef struct H5VL_native_dataset_chunk_read_t {
    const hsize_t *offset;
    uint32_t       filters;
    void          *buf;
    size_t        *buf_size;
} H5VL_native_dataset_chunk_read_t;

typedef struct H5VL_native_dataset_chunk_write_t {
    const hsize_t *offset;
    uint32_t       filters;
    size_t         size;
    const void    *buf;
} H5VL_native_dataset_chunk_write_t;

typedef struct H5VL_native_dataset_get_vlen_buf_size_t {
    hid_t    type_id;
    hid_t    space_id;
    hsize_t *size; 
} H5VL_native_dataset_get_vlen_buf_size_t;

typedef struct H5VL_native_dataset_get_chunk_storage_size_t {
    const hsize_t *offset; 
    hsize_t       *size;   
} H5VL_native_dataset_get_chunk_storage_size_t;

typedef struct H5VL_native_dataset_get_num_chunks_t {
    hid_t    space_id; 
    hsize_t *nchunks;  
} H5VL_native_dataset_get_num_chunks_t;

typedef struct H5VL_native_dataset_get_chunk_info_by_idx_t {
    hid_t     space_id;    
    hsize_t   chk_index;   
    hsize_t  *offset;      
    unsigned *filter_mask; 
    haddr_t  *addr;        
    hsize_t  *size;        
} H5VL_native_dataset_get_chunk_info_by_idx_t;

typedef struct H5VL_native_dataset_get_chunk_info_by_coord_t {
    const hsize_t *offset;      
    unsigned      *filter_mask; 
    haddr_t       *addr;        
    hsize_t       *size;        
} H5VL_native_dataset_get_chunk_info_by_coord_t;

typedef union H5VL_native_dataset_optional_args_t {
    
    

    
    struct {
        H5D_chunk_index_t *idx_type; 
    } get_chunk_idx_type;

    
    H5VL_native_dataset_get_chunk_storage_size_t get_chunk_storage_size;

    
    H5VL_native_dataset_get_num_chunks_t get_num_chunks;

    
    H5VL_native_dataset_get_chunk_info_by_idx_t get_chunk_info_by_idx;

    
    H5VL_native_dataset_get_chunk_info_by_coord_t get_chunk_info_by_coord;

    
    H5VL_native_dataset_chunk_read_t chunk_read;

    
    H5VL_native_dataset_chunk_write_t chunk_write;

    
    H5VL_native_dataset_get_vlen_buf_size_t get_vlen_buf_size;

    
    struct {
        haddr_t *offset; 
    } get_offset;

    
    struct {
        H5D_chunk_iter_op_t op;      
        void               *op_data; 
    } chunk_iter;

} H5VL_native_dataset_optional_args_t;

#define H5VL_NATIVE_FILE_CLEAR_ELINK_CACHE  0  
#define H5VL_NATIVE_FILE_GET_FILE_IMAGE     1  
#define H5VL_NATIVE_FILE_GET_FREE_SECTIONS  2  
#define H5VL_NATIVE_FILE_GET_FREE_SPACE     3  
#define H5VL_NATIVE_FILE_GET_INFO           4  
#define H5VL_NATIVE_FILE_GET_MDC_CONF       5  
#define H5VL_NATIVE_FILE_GET_MDC_HR         6  
#define H5VL_NATIVE_FILE_GET_MDC_SIZE       7  
#define H5VL_NATIVE_FILE_GET_SIZE           8  
#define H5VL_NATIVE_FILE_GET_VFD_HANDLE     9  
#define H5VL_NATIVE_FILE_RESET_MDC_HIT_RATE 10 
#define H5VL_NATIVE_FILE_SET_MDC_CONFIG     11 
#define H5VL_NATIVE_FILE_GET_METADATA_READ_RETRY_INFO                                                        \
    12                                             
#define H5VL_NATIVE_FILE_START_SWMR_WRITE       13 
#define H5VL_NATIVE_FILE_START_MDC_LOGGING      14 
#define H5VL_NATIVE_FILE_STOP_MDC_LOGGING       15 
#define H5VL_NATIVE_FILE_GET_MDC_LOGGING_STATUS 16 
#define H5VL_NATIVE_FILE_FORMAT_CONVERT         17 
#define H5VL_NATIVE_FILE_RESET_PAGE_BUFFERING_STATS                                                          \
    18 
#define H5VL_NATIVE_FILE_GET_PAGE_BUFFERING_STATS                                                            \
    19                                             
#define H5VL_NATIVE_FILE_GET_MDC_IMAGE_INFO     20 
#define H5VL_NATIVE_FILE_GET_EOA                21 
#define H5VL_NATIVE_FILE_INCR_FILESIZE          22 
#define H5VL_NATIVE_FILE_SET_LIBVER_BOUNDS      23 
#define H5VL_NATIVE_FILE_GET_MIN_DSET_OHDR_FLAG 24 
#define H5VL_NATIVE_FILE_SET_MIN_DSET_OHDR_FLAG 25 
#ifdef H5_HAVE_PARALLEL
#define H5VL_NATIVE_FILE_GET_MPI_ATOMICITY 26 
#define H5VL_NATIVE_FILE_SET_MPI_ATOMICITY 27 
#endif
#define H5VL_NATIVE_FILE_POST_OPEN 28 

typedef struct H5VL_native_file_get_file_image_t {
    size_t  buf_size;  
    void   *buf;       
    size_t *image_len; 
} H5VL_native_file_get_file_image_t;

typedef struct H5VL_native_file_get_free_sections_t {
    H5F_mem_t        type;       
    H5F_sect_info_t *sect_info;  
    size_t           nsects;     
    size_t          *sect_count; 
} H5VL_native_file_get_free_sections_t;

typedef struct H5VL_native_file_get_freespace_t {
    hsize_t *size; 
} H5VL_native_file_get_freespace_t;

typedef struct H5VL_native_file_get_info_t {
    H5I_type_t   type;  
    H5F_info2_t *finfo; 
} H5VL_native_file_get_info_t;

typedef struct H5VL_native_file_get_mdc_size_t {
    size_t   *max_size;        
    size_t   *min_clean_size;  
    size_t   *cur_size;        
    uint32_t *cur_num_entries; 
} H5VL_native_file_get_mdc_size_t;

typedef struct H5VL_native_file_get_vfd_handle_t {
    hid_t  fapl_id;
    void **file_handle; 
} H5VL_native_file_get_vfd_handle_t;

typedef struct H5VL_native_file_get_mdc_logging_status_t {
    bool *is_enabled;           
    bool *is_currently_logging; 
} H5VL_native_file_get_mdc_logging_status_t;

typedef struct H5VL_native_file_get_page_buffering_stats_t {
    unsigned *accesses;  
    unsigned *hits;      
    unsigned *misses;    
    unsigned *evictions; 
    unsigned *bypasses;  
} H5VL_native_file_get_page_buffering_stats_t;

typedef struct H5VL_native_file_get_mdc_image_info_t {
    haddr_t *addr; 
    hsize_t *len;  
} H5VL_native_file_get_mdc_image_info_t;

typedef struct H5VL_native_file_set_libver_bounds_t {
    H5F_libver_t low;  
    H5F_libver_t high; 
} H5VL_native_file_set_libver_bounds_t;

typedef union H5VL_native_file_optional_args_t {
    
    

    
    H5VL_native_file_get_file_image_t get_file_image;

    
    H5VL_native_file_get_free_sections_t get_free_sections;

    
    H5VL_native_file_get_freespace_t get_freespace;

    
    H5VL_native_file_get_info_t get_info;

    
    struct {
        H5AC_cache_config_t *config; 
    } get_mdc_config;

    
    struct {
        double *hit_rate; 
    } get_mdc_hit_rate;

    
    H5VL_native_file_get_mdc_size_t get_mdc_size;

    
    struct {
        hsize_t *size; 
    } get_size;

    
    H5VL_native_file_get_vfd_handle_t get_vfd_handle;

    
    

    
    struct {
        const H5AC_cache_config_t *config; 
    } set_mdc_config;

    
    struct {
        H5F_retry_info_t *info; 
    } get_metadata_read_retry_info;

    
    

    
    

    
    

    
    H5VL_native_file_get_mdc_logging_status_t get_mdc_logging_status;

    
    

    
    

    
    H5VL_native_file_get_page_buffering_stats_t get_page_buffering_stats;

    
    H5VL_native_file_get_mdc_image_info_t get_mdc_image_info;

    
    struct {
        haddr_t *eoa; 
    } get_eoa;

    
    struct {
        hsize_t increment; 
    } increment_filesize;

    
    H5VL_native_file_set_libver_bounds_t set_libver_bounds;

    
    struct {
        bool *minimize; 
    } get_min_dset_ohdr_flag;

    
    struct {
        bool minimize; 
    } set_min_dset_ohdr_flag;

#ifdef H5_HAVE_PARALLEL
    
    struct {
        bool *flag; 
    } get_mpi_atomicity;

    
    struct {
        bool flag; 
    } set_mpi_atomicity;
#endif 

    
    
} H5VL_native_file_optional_args_t;

#ifndef H5_NO_DEPRECATED_SYMBOLS
#define H5VL_NATIVE_GROUP_ITERATE_OLD 0 
#define H5VL_NATIVE_GROUP_GET_OBJINFO 1 
#endif                                  

#ifndef H5_NO_DEPRECATED_SYMBOLS

typedef struct H5VL_native_group_iterate_old_t {
    H5VL_loc_params_t loc_params; 
    hsize_t           idx;        
    hsize_t          *last_obj;   
    H5G_iterate_t     op;         
    void             *op_data;    
} H5VL_native_group_iterate_old_t;

typedef struct H5VL_native_group_get_objinfo_t {
    H5VL_loc_params_t loc_params;  
    bool              follow_link; 
    H5G_stat_t       *statbuf;     
} H5VL_native_group_get_objinfo_t;

typedef union H5VL_native_group_optional_args_t {
    
    H5VL_native_group_iterate_old_t iterate_old;

    
    H5VL_native_group_get_objinfo_t get_objinfo;
} H5VL_native_group_optional_args_t;
#endif 

#define H5VL_NATIVE_OBJECT_GET_COMMENT              0 
#define H5VL_NATIVE_OBJECT_SET_COMMENT              1 
#define H5VL_NATIVE_OBJECT_DISABLE_MDC_FLUSHES      2 
#define H5VL_NATIVE_OBJECT_ENABLE_MDC_FLUSHES       3 
#define H5VL_NATIVE_OBJECT_ARE_MDC_FLUSHES_DISABLED 4 
#define H5VL_NATIVE_OBJECT_GET_NATIVE_INFO          5 

typedef struct H5VL_native_object_get_comment_t {
    size_t  buf_size;    
    void   *buf;         
    size_t *comment_len; 
} H5VL_native_object_get_comment_t;

typedef struct H5VL_native_object_get_native_info_t {
    unsigned           fields; 
    H5O_native_info_t *ninfo;  
} H5VL_native_object_get_native_info_t;

typedef union H5VL_native_object_optional_args_t {
    
    H5VL_native_object_get_comment_t get_comment;

    
    struct {
        const char *comment; 
    } set_comment;

    
    

    
    

    
    struct {
        bool *flag; 
    } are_mdc_flushes_disabled;

    
    H5VL_native_object_get_native_info_t get_native_info;
} H5VL_native_object_optional_args_t;

#ifdef __cplusplus
extern "C" {
#endif

H5_DLLVAR hid_t H5VL_NATIVE_g;

H5_DLL herr_t H5VLnative_addr_to_token(hid_t loc_id, haddr_t addr, H5O_token_t *token);

H5_DLL herr_t H5VLnative_token_to_addr(hid_t loc_id, H5O_token_t token, haddr_t *addr);

#ifdef __cplusplus
}
#endif

#endif 
