/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.real;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.real.AbstractLargeRealSConstraint;
import choco.kernel.solver.constraints.real.RealExp;
import choco.kernel.solver.variables.real.RealInterval;
import choco.kernel.solver.variables.real.RealIntervalConstant;
import choco.kernel.solver.variables.real.RealMath;
import choco.kernel.solver.variables.real.RealVar;
import java.util.ArrayList;
import java.util.logging.Level;

public final class Equation
extends AbstractLargeRealSConstraint {
    private RealInterval cste;
    private RealExp exp;
    private RealExp[] subExps;
    private int nbBoxedVars = 0;
    private RealVar[] boxedVars;
    private RealExp[][] subExpsWX;
    private RealExp[][] subExpsWOX;
    private static final int boxConsistencyDepth = 6;
    private final Solver solver;

    public Equation(Solver solver, RealVar[] collectedVars, RealExp exp, RealInterval cste) {
        super(collectedVars);
        this.initEquation(exp, cste);
        this.solver = solver;
    }

    public Equation(Solver solver, RealVar[] collectedVars, RealExp exp) {
        this(solver, collectedVars, exp, new RealIntervalConstant(0.0, 0.0));
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("Equation ").append(this.exp.pretty()).append(" = ").append(this.cste.pretty());
        return sb.toString();
    }

    void initEquation(RealExp exp, RealInterval cste) {
        this.cste = cste;
        this.exp = exp;
        this.boxedVars = new RealVar[((RealVar[])this.vars).length];
        this.subExpsWX = new RealExp[((RealVar[])this.vars).length][];
        this.subExpsWOX = new RealExp[((RealVar[])this.vars).length][];
        ArrayList<RealExp> collectedSubExp = new ArrayList<RealExp>();
        exp.subExps(collectedSubExp);
        this.subExps = new RealExp[collectedSubExp.size()];
        this.subExps = collectedSubExp.toArray(this.subExps);
    }

    public void addBoxedVar(RealVar var) {
        if (this.nbBoxedVars == this.boxedVars.length) {
            LOGGER.log(Level.SEVERE, "Cannot box more variables than variables involved in the constraint !!");
            return;
        }
        ArrayList<RealExp> wx = new ArrayList<RealExp>();
        ArrayList<RealExp> wox = new ArrayList<RealExp>();
        this.exp.isolate(var, wx, wox);
        if (wx.isEmpty()) {
            LOGGER.log(Level.SEVERE, "Cannot box variables not involved in the constraint !!");
            return;
        }
        this.boxedVars[this.nbBoxedVars] = var;
        this.subExpsWX[this.nbBoxedVars] = wx.toArray(new RealExp[wx.size()]);
        this.subExpsWOX[this.nbBoxedVars] = wox.toArray(new RealExp[wox.size()]);
        ++this.nbBoxedVars;
    }

    public void boxAllVars() {
        for (RealVar var : (RealVar[])this.vars) {
            this.addBoxedVar(var);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.tighten(this.subExps);
        this.proj();
        for (int i = 0; i < this.nbBoxedVars; ++i) {
            this.bc(this.boxedVars[i], this.subExpsWX[i], this.subExpsWOX[i]);
        }
    }

    private boolean not_inconsistent(RealExp[] wx) {
        boolean contradiction = false;
        try {
            this.tighten(wx);
        }
        catch (ContradictionException e) {
            contradiction = true;
        }
        return !contradiction && this.exp.getInf() <= this.cste.getSup() && this.exp.getSup() >= this.cste.getInf();
    }

    void bc(RealVar var, RealExp[] wx, RealExp[] wox) throws ContradictionException {
        RealInterval[] unexplored = new RealInterval[6 * 2];
        int[] depths = new int[6 * 2];
        int depth = 0;
        int idx = 0;
        boolean fin = false;
        double leftB = 0.0;
        double rightB = 0.0;
        RealIntervalConstant oldValue = new RealIntervalConstant(var);
        this.tighten(wox);
        while (!fin) {
            if (this.not_inconsistent(wx)) {
                if (6 <= depth) {
                    leftB = var.getInf();
                    rightB = var.getSup();
                    fin = true;
                    continue;
                }
                RealInterval left = RealMath.firstHalf(var);
                RealInterval right = RealMath.secondHalf(var);
                var.silentlyAssign(left);
                unexplored[idx] = right;
                depths[idx] = ++depth;
                ++idx;
                continue;
            }
            if (idx != 0) {
                var.silentlyAssign(unexplored[--idx]);
                depth = depths[idx];
                continue;
            }
            this.propagationEngine.raiseContradiction(this);
        }
        RealInterval[] tmp1 = new RealInterval[6 * 2];
        int[] tmp2 = new int[6 * 2];
        for (int i = 0; i < idx; ++i) {
            int j = idx - i - 1;
            tmp1[i] = unexplored[j];
            tmp2[i] = depths[j];
        }
        unexplored = tmp1;
        depths = tmp2;
        if (idx != 0) {
            var.silentlyAssign(unexplored[--idx]);
            depth = depths[idx];
            fin = false;
            while (!fin) {
                if (this.not_inconsistent(wx)) {
                    if (6 <= depth) {
                        rightB = var.getSup();
                        fin = true;
                        continue;
                    }
                    RealInterval left = RealMath.firstHalf(var);
                    RealInterval right = RealMath.secondHalf(var);
                    var.silentlyAssign(right);
                    unexplored[idx] = left;
                    depths[idx] = ++depth;
                    ++idx;
                    continue;
                }
                if (idx != 0) {
                    var.silentlyAssign(unexplored[--idx]);
                    depth = depths[idx];
                    continue;
                }
                fin = true;
            }
        }
        var.silentlyAssign(oldValue);
        var.intersect(new RealIntervalConstant(leftB, rightB));
    }

    @Override
    public boolean isSatisfied() {
        boolean ok1 = true;
        this.solver.worldPushDuringPropagation();
        try {
            this.solver.propagate();
        }
        catch (ContradictionException e) {
            ok1 = false;
        }
        this.solver.worldPopDuringPropagation();
        return ok1;
    }

    @Override
    public boolean isConsistent() {
        return false;
    }

    void tighten(RealExp[] exps) throws ContradictionException {
        for (int i = 0; i < exps.length; ++i) {
            RealExp exp = exps[i];
            exp.tighten();
            if (!(exp.getInf() > exp.getSup())) continue;
            this.fail();
        }
    }

    void proj() throws ContradictionException {
        this.subExps[this.subExps.length - 1].intersect(this.cste);
        for (int i = this.subExps.length - 1; i > 0; --i) {
            this.subExps[i].project();
        }
    }
}

