## -----------------------------------------------------------------------------
# Create a minimal Word document with toy references
library(dplyr)

toy_doc <- officer::read_docx() %>%
  officer::body_add_par("Smith J. An example study. 2020.", style = "Normal") %>%
  officer::body_add_par("Doe A. Another example paper. 2019.", style = "Normal")

# Save to a temporary file
input_file <- tempfile(fileext = ".docx")
print(toy_doc, target = input_file)

# Output file path
output_file <- tempfile(fileext = ".docx")

# Run add_doi (internet required)
if (interactive()) {
  add_doi(
    input_path = input_file,
    output_path = output_file,
    reference_lines = 2
  )

  # Read and inspect results
  output_doc <- officer::read_docx(output_file)
}

