/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5UCprivate_H
#define H5UCprivate_H

#include "H5private.h"

typedef herr_t (*H5UC_free_func_t)(void *o);

typedef struct H5UC_t {
    void            *o;         
    size_t           n;         
    H5UC_free_func_t free_func; 
} H5UC_t;

#define H5UC_INC(rc)     ((rc)->n++)
#define H5UC_DEC(rc)     (H5UC_decr(rc))
#define H5UC_GET_OBJ(rc) ((rc)->o)

H5_DLL H5UC_t *H5UC_create(void *s, H5UC_free_func_t free_func);
H5_DLL herr_t  H5UC_decr(H5UC_t *rc);

#endif 
