/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials;

import internal.toolkit.base.core.math.polynomials.Coefficients;
import java.util.Arrays;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.math.Arithmetics;
import jdplus.toolkit.base.core.math.ComplexUtility;
import jdplus.toolkit.base.core.math.Simplifying;
import jdplus.toolkit.base.core.math.polynomials.IVector;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;

public class UnitRoots
implements Cloneable {
    public static final Polynomial D1 = Polynomial.valueOf(1.0, -1.0);
    private IVector m_n;
    private IVector m_d;
    private int[] m_dp;
    private static final double g_epsilon = 1.0E-8;

    public static Polynomial forFrequency(double f) {
        return Polynomial.valueOf(1.0, -2.0 * Math.cos(f), 1.0);
    }

    public static Polynomial D(int n) {
        double[] p = Coefficients.fromDegree(n);
        p[n] = -1.0;
        p[0] = 1.0;
        return Polynomial.ofInternal(p);
    }

    public static Polynomial D(int lag, int d) {
        Polynomial P;
        if (d == 0) {
            return Polynomial.ONE;
        }
        Polynomial D = P = UnitRoots.D(lag);
        for (int i = 1; i < d; ++i) {
            D = D.times(P);
        }
        int nroots = lag * d;
        Complex[] roots = new Complex[nroots];
        Complex[] ur = ComplexUtility.unitRoots(lag);
        int k = 0;
        for (int i = 0; i < d; ++i) {
            int j = 0;
            while (j < lag) {
                roots[k] = ur[j];
                ++j;
                ++k;
            }
        }
        D.setRoots(roots);
        return D;
    }

    private static int div(double[] c, int nc, int d) {
        int i;
        for (i = d; i < nc; ++i) {
            int n = i;
            c[n] = c[n] + c[i - d];
        }
        for (i = nc - d; i < nc; ++i) {
            if (!(Math.abs(c[i]) > 1.0E-8)) continue;
            return -1;
        }
        return nc - d;
    }

    private static int div(int[] c, int nc, int d) {
        int i;
        for (i = nc - 1; i >= d; --i) {
            int n = i - d;
            c[n] = c[n] + c[i];
            c[i] = -c[i];
        }
        for (i = 0; i < d; ++i) {
            if (c[i] == 0) continue;
            return -1;
        }
        for (i = d; i < nc; ++i) {
            c[i - d] = c[i];
        }
        return nc - d;
    }

    public static Polynomial divide(Polynomial p, UnitRoots ur) {
        int i;
        if (p.degree() < ur.getRootsCount()) {
            return null;
        }
        double[] tmp = new double[p.degree() + 1 + ur.getDenomDegree()];
        p.copyTo(tmp, 0);
        int nc = p.degree() + 1;
        int imax = ur.m_d == null ? 0 : ur.m_d.getSize();
        for (i = 0; i < imax; ++i) {
            nc = UnitRoots.mul(tmp, nc, ur.m_d.get(i));
        }
        imax = ur.m_n == null ? 0 : ur.m_n.getSize();
        for (i = 0; i < imax; ++i) {
            if ((nc = UnitRoots.div(tmp, nc, ur.m_n.get(i))) >= 0) continue;
            return null;
        }
        return Polynomial.ofInternal(Arrays.copyOf(tmp, nc));
    }

    private static int mul(double[] c, int nc, int d) {
        for (int i = nc - 1; i >= 0; --i) {
            int n = i + d;
            c[n] = c[n] - c[i];
        }
        return nc + d;
    }

    private static int mul(int[] c, int nc, int d) {
        for (int i = nc - 1; i >= 0; --i) {
            int n = i + d;
            c[n] = c[n] - c[i];
        }
        return nc + d;
    }

    public static Polynomial multiply(Polynomial p, UnitRoots ur) {
        int i;
        double[] tmp = new double[p.degree() + 1 + ur.getNumDegree()];
        int nc = p.degree() + 1;
        for (int i2 = 0; i2 < nc; ++i2) {
            tmp[i2] = p.get(i2);
        }
        int imax = ur.m_n == null ? 0 : ur.m_n.getSize();
        for (i = 0; i < imax; ++i) {
            nc = UnitRoots.mul(tmp, nc, ur.m_n.get(i));
        }
        imax = ur.m_d == null ? 0 : ur.m_d.getSize();
        for (i = 0; i < imax; ++i) {
            nc = UnitRoots.div(tmp, nc, ur.m_d.get(i));
        }
        return Polynomial.ofInternal(Arrays.copyOf(tmp, nc));
    }

    public static Polynomial multiply(UnitRoots ur, Polynomial p) {
        return UnitRoots.multiply(p, ur);
    }

    private static int nextdiv(int x, int d, int p) {
        for (int nd = d - 1; nd > 1; --nd) {
            if (x % nd != 0 || Arithmetics.gcd(nd, p) != 1) continue;
            return nd;
        }
        return 0;
    }

    public static Polynomial S(int freq, int d) {
        double[] p = Coefficients.fromDegree((freq - 1) * d);
        int i = 0;
        int j = 0;
        while (i < freq) {
            p[j] = 1.0;
            ++i;
            j += d;
        }
        Polynomial P = Polynomial.ofInternal(p);
        if (d == 1) {
            Complex[] roots = ComplexUtility.unitRoots(freq);
            Complex[] nroots = new Complex[roots.length - 1];
            System.arraycopy(roots, 1, nroots, 0, nroots.length);
            P.setRoots(nroots);
        }
        return P;
    }

    public static Polynomial S(int freq, int d, int p) {
        Polynomial s;
        if (p == 0) {
            return Polynomial.ONE;
        }
        Polynomial q = s = UnitRoots.S(freq, d);
        for (int i = 1; i < p; ++i) {
            q = q.times(s);
        }
        return q;
    }

    public UnitRoots() {
        this.m_n = new IVector();
        this.m_d = new IVector();
    }

    private UnitRoots(IVector n, IVector d) {
        this.m_n = n;
        this.m_d = d;
    }

    public void add(int ur) {
        this.m_n.add(ur);
        this.internalclear();
    }

    public void add(UnitRoots ur) {
        this.m_n.add(ur.m_n);
        this.m_d.add(ur.m_d);
        this.internalclear();
    }

    private void addonly(int[] divs, int cur) {
        int d = divs[cur];
        this.m_n.add(d);
        for (int j = cur - 1; j >= 0; --j) {
            if (d % divs[j] != 0) continue;
            this.removeonly(divs, j);
        }
    }

    public void addOnly(int num, int div) {
        int i;
        int n = 2;
        while (n * n < num) {
            ++n;
        }
        int[] divs = new int[n + 1];
        int ndivs = Arithmetics.divisors(num, divs);
        for (i = 0; divs[i] != div && i < ndivs; ++i) {
        }
        if (i != ndivs) {
            this.addonly(divs, i);
        }
        this.internalclear();
    }

    public void addOnly(int[] divs, int cur) {
        this.addonly(divs, cur);
        this.internalclear();
    }

    public void backFilter(double[] data, int i0, int i1) {
        int j;
        int i;
        for (i = 0; i < this.m_n.getSize(); ++i) {
            int d = this.m_n.get(i);
            for (j = i1 - 1; j >= i0 + d; --j) {
                int n = j;
                data[n] = data[n] - data[j - d];
            }
        }
        for (i = 0; i < this.m_d.getSize(); ++i) {
            int s = this.m_d.get(i);
            for (j = i0 + s; j < i1; ++j) {
                int n = j;
                data[n] = data[n] + data[j - s];
            }
        }
    }

    private boolean calcmaps() {
        int i;
        int nn = this.m_n.getSize();
        int nd = this.m_d.getSize();
        if (nn == 0 || this.m_dp != null) {
            return true;
        }
        int[] nmax = new int[nn];
        for (i = 0; i < nn; ++i) {
            nmax[i] = this.m_n.get(i);
        }
        this.m_dp = new int[nd];
        for (i = 0; i < nd; ++i) {
            this.m_dp[i] = -1;
        }
        boolean ok = true;
        for (int i2 = 0; i2 < nd && this.m_d.get(i2) != 1; ++i2) {
            int j;
            for (j = 0; j < nn; ++j) {
                if (nmax[j] == 0 || nmax[j] % this.m_d.get(i2) != 0) continue;
                this.m_dp[i2] = j;
                nmax[j] = UnitRoots.nextdiv(this.m_n.get(j), nmax[j], this.m_d.get(i2));
                break;
            }
            if (j != nn) continue;
            ok = false;
        }
        return ok;
    }

    private boolean check() {
        if (this.m_dp != null) {
            return true;
        }
        this.simplify();
        if (this.m_d.getSize() > this.m_n.getSize()) {
            return false;
        }
        if (this.calcmaps()) {
            return true;
        }
        this.internalclear();
        return false;
    }

    public void clear() {
        this.m_n.clear();
        this.m_d.clear();
        this.internalclear();
    }

    public UnitRoots clone() {
        try {
            UnitRoots ur = (UnitRoots)super.clone();
            ur.m_d = this.m_d.clone();
            ur.m_n = this.m_n.clone();
            if (this.m_dp != null) {
                ur.m_dp = (int[])this.m_dp.clone();
            }
            return ur;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public double[] coefficients() {
        int i;
        int[] tmp = new int[1 + this.getNumDegree()];
        int nc = 1;
        tmp[0] = 1;
        for (i = 0; i < this.m_n.getSize(); ++i) {
            nc = UnitRoots.mul(tmp, nc, this.m_n.get(i));
        }
        for (i = 0; i < this.m_d.getSize(); ++i) {
            nc = UnitRoots.div(tmp, nc, this.m_d.get(i));
        }
        double[] mc = new double[nc];
        for (int i2 = 0; i2 < nc; ++i2) {
            mc[i2] = tmp[i2];
        }
        return mc;
    }

    public int[] denominator() {
        this.check();
        return this.m_d.RPowers();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof UnitRoots && this.equals((UnitRoots)obj);
    }

    private boolean equals(UnitRoots other) {
        return this.m_n.equals((Object)other.m_n) && this.m_d.equals((Object)other.m_d);
    }

    public double[] filter(boolean back, double[] data) {
        if (data == null) {
            return null;
        }
        double[] tmp = (double[])data.clone();
        int i0 = 0;
        int i1 = data.length;
        if (back) {
            this.backFilter(tmp, i0, i1);
        } else {
            this.filter(tmp, i0, i1);
        }
        i0 = this.getNumDegree();
        double[] rslt = new double[(i1 -= this.getDenomDegree()) - i0];
        for (int i = 0; i < rslt.length; ++i) {
            rslt[i] = tmp[i0 + i];
        }
        return rslt;
    }

    public void filter(double[] data, int i0, int i1) {
        int j;
        int i;
        for (i = 0; i < this.m_n.getSize(); ++i) {
            int d = this.m_n.get(i);
            for (j = i0; j < i1 - d; ++j) {
                int n = j;
                data[n] = data[n] - data[j + d];
            }
        }
        for (i = 0; i < this.m_d.getSize(); ++i) {
            int s = this.m_d.get(i);
            for (j = i1 - s - 1; j >= i0; --j) {
                int n = j;
                data[n] = data[n] + data[j + s];
            }
        }
    }

    public int getD(int idx) {
        return this.m_d.get(idx);
    }

    public int getDenomCount() {
        return this.m_d.getSize();
    }

    public int getDenomDegree() {
        int d = 0;
        for (int i = 0; i < this.m_d.getSize(); ++i) {
            d += this.m_d.get(i);
        }
        return d;
    }

    public int getN(int idx) {
        return this.m_n.get(idx);
    }

    public int getNumCount() {
        return this.m_n.getSize();
    }

    public int getNumDegree() {
        int d = 0;
        for (int i = 0; i < this.m_n.getSize(); ++i) {
            d += this.m_n.get(i);
        }
        return d;
    }

    public int getRootsCount() {
        int i;
        int d = 0;
        for (i = 0; i < this.m_n.getSize(); ++i) {
            d += this.m_n.get(i);
        }
        for (i = 0; i < this.m_d.getSize(); ++i) {
            d -= this.m_d.get(i);
        }
        return d;
    }

    public int hashCode() {
        return this.m_n.hashCode() + this.m_d.hashCode();
    }

    private void internalclear() {
        this.m_dp = null;
    }

    public boolean isIdentity() {
        this.check();
        return this.m_n.getSize() == 0 && this.m_d.getSize() == 0;
    }

    public boolean isValid() {
        return this.check();
    }

    public int[] numerator() {
        this.check();
        return this.m_n.RPowers();
    }

    public void remove(int ur) {
        this.m_d.add(ur);
        this.internalclear();
    }

    public void remove(UnitRoots ur) {
        this.m_n.add(ur.m_d);
        this.m_d.add(ur.m_n);
        this.internalclear();
    }

    private void removeonly(int[] divs, int cur) {
        int d = divs[cur];
        this.m_d.add(d);
        for (int j = cur - 1; j >= 0; --j) {
            if (d % divs[j] != 0) continue;
            this.addonly(divs, j);
        }
    }

    public void removeOnly(int num, int div) {
        int i;
        int n = 2;
        while (n * n < num) {
            ++n;
        }
        int[] divs = new int[2 * n];
        int ndivs = Arithmetics.divisors(num, divs);
        for (i = 0; divs[i] != div && i < ndivs; ++i) {
        }
        if (i != ndivs) {
            this.removeonly(divs, i);
        }
        this.internalclear();
    }

    public void removeOnly(int[] divs, int cur) {
        this.removeonly(divs, cur);
        this.internalclear();
    }

    public Complex[] roots() {
        int nroots = this.getRootsCount();
        if (nroots == 0) {
            return null;
        }
        Complex[] roots = new Complex[nroots];
        int ppcm = this.m_n.get(0);
        for (int i = 1; i < this.m_n.getSize(); ++i) {
            ppcm = Arithmetics.lcm(ppcm, this.m_n.get(i));
        }
        double m = Math.PI * 2 / (double)ppcm;
        int imax = ppcm / 2;
        int k = 0;
        for (int i = 0; i <= imax; ++i) {
            int j;
            int j2;
            int nr = 0;
            for (j2 = 0; j2 < this.m_n.getSize(); ++j2) {
                if (i % (ppcm / this.m_n.get(j2)) != 0) continue;
                ++nr;
            }
            for (j2 = 0; j2 < this.m_d.getSize(); ++j2) {
                if (i % (ppcm / this.m_d.get(j2)) != 0) continue;
                --nr;
            }
            if (nr <= 0) continue;
            Complex root = i == 0 ? Complex.ONE : (ppcm == 2 * i ? Complex.NEG_ONE : Complex.cart((double)Math.cos(m * (double)i), (double)Math.sin(m * (double)i)));
            if (root.getIm() == 0.0) {
                for (j = 0; j < nr; ++j) {
                    roots[k++] = root;
                }
                continue;
            }
            for (j = 0; j < nr; ++j) {
                roots[k++] = root;
                roots[k++] = root.conj();
            }
        }
        return roots;
    }

    private void simplify() {
        if (IVector.simplify(this.m_n, this.m_d) != 0) {
            this.internalclear();
        }
    }

    public UnitRoots sqrt() {
        this.simplify();
        IVector n = this.m_n.sqrt();
        if (n == null) {
            return null;
        }
        IVector d = this.m_d.sqrt();
        if (d == null) {
            return null;
        }
        UnitRoots ur = new UnitRoots(n, d);
        return ur;
    }

    public UnitRoots squared() {
        this.simplify();
        return new UnitRoots(this.m_n.squared(), this.m_d.squared());
    }

    public UnitRoots times(UnitRoots r) {
        UnitRoots rslt = this.clone();
        rslt.add(r);
        rslt.simplify();
        return rslt;
    }

    public Polynomial asPolynomial() {
        return Polynomial.ofInternal(this.coefficients());
    }

    static {
        D1.setRoots(new Complex[]{Complex.ONE});
    }

    public static class SimplifyingTool
    extends Simplifying<UnitRoots> {
        @Override
        public boolean simplify(UnitRoots left, UnitRoots right) {
            this.simplifiedLeft = left;
            this.simplifiedRight = right;
            this.common = new UnitRoots();
            if (left == null || right == null) {
                return false;
            }
            if (!left.isValid() || !right.isValid()) {
                return false;
            }
            if (left.isIdentity() || right.isIdentity()) {
                return false;
            }
            this.simplifiedLeft = left.clone();
            this.simplifiedRight = right.clone();
            int ldiff = ((UnitRoots)this.simplifiedLeft).m_n.getSize() - ((UnitRoots)this.simplifiedLeft).m_d.getSize();
            int rdiff = ((UnitRoots)this.simplifiedRight).m_n.getSize() - ((UnitRoots)this.simplifiedRight).m_d.getSize();
            ((UnitRoots)this.simplifiedLeft).calcmaps();
            ((UnitRoots)this.simplifiedRight).calcmaps();
            this.step1();
            this.step2(ldiff, rdiff);
            return !((UnitRoots)this.common).isIdentity();
        }

        private void step1() {
            int lu = 0;
            int ru = 0;
            while (true) {
                int i;
                int dcur;
                int i2;
                int kl = 0;
                int kr = 0;
                int pgcd = 0;
                while (kl < ((UnitRoots)this.simplifiedLeft).m_n.getSize() && kr < ((UnitRoots)this.simplifiedRight).m_n.getSize() && (pgcd = Arithmetics.gcd(lu = ((UnitRoots)this.simplifiedLeft).m_n.get(kl), ru = ((UnitRoots)this.simplifiedRight).m_n.get(kr))) <= 1 && lu != 1 && ru != 1) {
                    if (lu > ru) {
                        ++kl;
                        continue;
                    }
                    ++kr;
                }
                if (pgcd <= true) break;
                IntList d = new IntList();
                for (i2 = 0; i2 < ((UnitRoots)this.simplifiedLeft).m_dp.length; ++i2) {
                    dcur = Arithmetics.gcd(((UnitRoots)this.simplifiedLeft).m_d.get(i2), lu);
                    if (((UnitRoots)this.simplifiedLeft).m_dp[i2] != kl || d.contains(dcur)) continue;
                    d.add(dcur);
                }
                for (i2 = 0; i2 < ((UnitRoots)this.simplifiedRight).m_dp.length; ++i2) {
                    dcur = Arithmetics.gcd(((UnitRoots)this.simplifiedRight).m_d.get(i2), ru);
                    if (((UnitRoots)this.simplifiedRight).m_dp[i2] != kr || d.contains(dcur)) continue;
                    d.add(dcur);
                }
                int prod = 1;
                for (i = 0; i < d.size(); ++i) {
                    prod *= d.get(i);
                }
                if (pgcd % prod != 0) break;
                ((UnitRoots)this.common).add(pgcd);
                ((UnitRoots)this.simplifiedRight).remove(pgcd);
                ((UnitRoots)this.simplifiedLeft).remove(pgcd);
                for (i = 0; i < d.size(); ++i) {
                    int id = d.get(i);
                    ((UnitRoots)this.simplifiedLeft).add(id);
                    ((UnitRoots)this.simplifiedRight).add(id);
                    ((UnitRoots)this.common).remove(id);
                }
                ((UnitRoots)this.simplifiedLeft).simplify();
                ((UnitRoots)this.simplifiedLeft).calcmaps();
                ((UnitRoots)this.simplifiedRight).simplify();
                ((UnitRoots)this.simplifiedRight).calcmaps();
                ((UnitRoots)this.common).simplify();
            }
        }

        private void step2(int ldiff, int rdiff) {
            block3: {
                int curdiff;
                int cdiff;
                block2: {
                    cdiff = ldiff < rdiff ? ldiff : rdiff;
                    curdiff = ((UnitRoots)this.common).m_n.getSize() - ((UnitRoots)this.common).m_d.getSize();
                    if (curdiff >= cdiff) break block2;
                    for (int i = curdiff; i < cdiff; ++i) {
                        ((UnitRoots)this.common).add(1);
                        ((UnitRoots)this.simplifiedLeft).remove(1);
                        ((UnitRoots)this.simplifiedRight).remove(1);
                    }
                    break block3;
                }
                if (curdiff <= cdiff) break block3;
                for (int i = cdiff; i < curdiff; ++i) {
                    ((UnitRoots)this.common).remove(1);
                    ((UnitRoots)this.simplifiedLeft).add(1);
                    ((UnitRoots)this.simplifiedRight).add(1);
                }
            }
        }
    }
}

