/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.ami;

import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.regarima.RegArimaModel;

public interface GenericOutliersDetection<T extends IArimaModel> {
    public void prepare(int var1);

    public void setBounds(int var1, int var2);

    public void exclude(int var1, int var2);

    public boolean process(RegArimaModel<T> var1, IArimaMapping<T> var2);

    public int[][] getOutliers();

    public static double criticalValue(int nobs, double alpha) {
        double pmod = 2.0 - Math.sqrt(1.0 + alpha);
        double acv = Math.sqrt(2.0 * Math.log(nobs));
        double bcv = acv - (Math.log(Math.log(nobs)) + Math.log(Math.PI * 4)) / (2.0 * acv);
        double xcv = -Math.log(-0.5 * Math.log(pmod));
        return xcv / acv + bcv;
    }
}

