/*
 * Copyright (c) 2019, Alliance for Open Media. All rights reserved.
 *
 * This source code is subject to the terms of the BSD 2 Clause License and
 * the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
 * was not distributed with this source code in the LICENSE file, you can
 * obtain it at www.aomedia.org/license/software. If the Alliance for Open
 * Media Patent License 1.0 was not distributed with this source code in the
 * PATENTS file, you can obtain it at www.aomedia.org/license/patent.
 */

#ifndef AOM_AV1_ENCODER_PARTITION_CNN_WEIGHTS_H_
#define AOM_AV1_ENCODER_PARTITION_CNN_WEIGHTS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "av1/encoder/cnn.h"
#include "av1/encoder/ml.h"

#define NUM_DNN_BRANCHES 4
#define NUM_CNN_LAYERS 5
#define BRANCH_0_NUM_DNN_LAYERS 2
#define BRANCH_1_NUM_DNN_LAYERS 2
#define BRANCH_2_NUM_DNN_LAYERS 2
#define BRANCH_3_NUM_DNN_LAYERS 2
#define CNN_LAYER_0_HEIGHT 5
#define CNN_LAYER_0_WIDTH 5
#define CNN_LAYER_0_IN_CH 1
#define CNN_LAYER_0_OUT_CH 20
#define CNN_LAYER_0_HORZ_STRIDE 4
#define CNN_LAYER_0_VERT_STRIDE 4
#define CNN_LAYER_1_HEIGHT 2
#define CNN_LAYER_1_WIDTH 2
#define CNN_LAYER_1_IN_CH 20
#define CNN_LAYER_1_OUT_CH 20
#define CNN_LAYER_1_HORZ_STRIDE 2
#define CNN_LAYER_1_VERT_STRIDE 2
#define CNN_LAYER_2_HEIGHT 2
#define CNN_LAYER_2_WIDTH 2
#define CNN_LAYER_2_IN_CH 20
#define CNN_LAYER_2_OUT_CH 20
#define CNN_LAYER_2_HORZ_STRIDE 2
#define CNN_LAYER_2_VERT_STRIDE 2
#define CNN_LAYER_3_HEIGHT 2
#define CNN_LAYER_3_WIDTH 2
#define CNN_LAYER_3_IN_CH 20
#define CNN_LAYER_3_OUT_CH 4
#define CNN_LAYER_3_HORZ_STRIDE 2
#define CNN_LAYER_3_VERT_STRIDE 2
#define CNN_LAYER_4_HEIGHT 2
#define CNN_LAYER_4_WIDTH 2
#define CNN_LAYER_4_IN_CH 4
#define CNN_LAYER_4_OUT_CH 20
#define CNN_LAYER_4_HORZ_STRIDE 2
#define CNN_LAYER_4_VERT_STRIDE 2
#define BRANCH_0_NUM_DNN_FEATURES 37
#define BRANCH_0_NUM_DNN_LAYER_0_UNITS 16
#define BRANCH_0_NUM_DNN_LAYER_1_UNITS 24
#define BRANCH_0_NUM_LOGITS 1
#define BRANCH_1_NUM_DNN_FEATURES 25
#define BRANCH_1_NUM_DNN_LAYER_0_UNITS 16
#define BRANCH_1_NUM_DNN_LAYER_1_UNITS 24
#define BRANCH_1_NUM_LOGITS 1
#define BRANCH_2_NUM_DNN_FEATURES 25
#define BRANCH_2_NUM_DNN_LAYER_0_UNITS 16
#define BRANCH_2_NUM_DNN_LAYER_1_UNITS 24
#define BRANCH_2_NUM_LOGITS 1
#define BRANCH_3_NUM_DNN_FEATURES 41
#define BRANCH_3_NUM_DNN_LAYER_0_UNITS 16
#define BRANCH_3_NUM_DNN_LAYER_1_UNITS 24
#define BRANCH_3_NUM_LOGITS 1

static const float av1_intra_mode_cnn_partition_cnn_layer_0_kernel[] = {
  0.131894f,    -0.593536f,  -0.212935f,  -0.00220011f, -0.396949f,
  0.287753f,    -0.91875f,   -0.0095057f, 0.804197f,    -0.395239f,
  0.516604f,    1.16439f,    0.445784f,   -0.163349f,   0.746488f,
  -0.33891f,    -0.562652f,  0.481403f,   0.755378f,    -0.200753f,
  0.0784307f,   0.105657f,   0.0205673f,  -0.524089f,   -0.476146f,
  -0.161206f,   -0.65079f,   0.137474f,   0.28584f,     0.508768f,
  -0.643386f,   0.227068f,   -0.899507f,  -0.413382f,   0.631466f,
  0.398203f,    -0.544392f,  0.825155f,   0.671847f,    -0.249779f,
  0.323121f,    0.125357f,   -0.719564f,  -0.0714854f,  -0.168472f,
  -0.213246f,   -0.674525f,  0.330148f,   -0.138414f,   0.20462f,
  -0.518571f,   -0.15091f,   -0.605116f,  -0.448732f,   -0.475599f,
  0.738f,       -0.328526f,  0.755035f,   0.969414f,    -0.321039f,
  -0.23068f,    0.408567f,   -0.377813f,  -0.273974f,   1.0684f,
  0.373968f,    -0.450305f,  0.439258f,   -0.381846f,   -0.267331f,
  0.30613f,     -0.39369f,   0.622438f,   -0.52877f,    -0.334991f,
  0.263193f,    -0.402121f,  0.64142f,    0.793048f,    -0.0231174f,
  -0.68474f,    -0.293338f,  -0.737511f,  -0.462654f,   0.474629f,
  0.141397f,    -0.152529f,  0.345879f,   -0.499991f,   0.00174024f,
  0.337387f,    -0.131151f,  0.427385f,   -0.457449f,   -0.879614f,
  -0.425908f,   -0.263172f,  0.0344974f,  1.07861f,     -0.00416662f,
  0.0208952f,   0.233905f,   0.765965f,   0.0423685f,   -0.117554f,
  -0.248237f,   0.49848f,    -0.845131f,  0.223648f,    -0.838709f,
  0.5834f,      0.309956f,   -0.0625093f, -0.619619f,   0.918957f,
  0.358271f,    -0.668459f,  0.518783f,   -0.418963f,   -0.206788f,
  0.364983f,    -0.0396087f, 0.624309f,   -0.138679f,   -0.142453f,
  0.28309f,     0.895092f,   -0.215713f,  0.439025f,    0.659333f,
  -0.366025f,   -0.413518f,  0.66657f,    -0.265919f,   0.473471f,
  -1.0729f,     -0.526702f,  0.2838f,     0.367648f,    -0.61242f,
  0.121656f,    0.547727f,   -0.0636793f, -0.33006f,    -0.306604f,
  -0.00897731f, 0.688242f,   0.0944626f,  0.321508f,    0.0437392f,
  -0.560035f,   -0.768334f,  0.0571051f,  -0.0427601f,  -0.0437806f,
  -0.816209f,   -0.395829f,  0.293733f,   0.217645f,    -0.646428f,
  0.132448f,    -0.435806f,  -0.0556814f, 0.0218857f,   0.348525f,
  -0.17296f,    0.669057f,   0.638604f,   -0.0995596f,  -0.024099f,
  -0.262332f,   -0.548975f,  0.357894f,   0.43873f,     -0.688234f,
  -0.425519f,   0.190986f,   -0.074778f,  0.294232f,    -0.548969f,
  -0.731198f,   0.03616f,    -0.475969f,  -0.306075f,   -0.111929f,
  -0.234146f,   0.612669f,   0.882254f,   -0.622893f,   0.262431f,
  0.465242f,    0.245384f,   -0.811016f,  0.501798f,    -0.925875f,
  0.264373f,    0.307766f,   -0.26872f,   0.113027f,    -0.158875f,
  0.0711483f,   0.220275f,   -0.0699022f, -0.0111303f,  -0.435384f,
  -0.720014f,   0.593484f,   -0.964082f,  0.750925f,    0.252433f,
  0.964332f,    -0.256904f,  -0.421715f,  -0.403851f,   -0.188081f,
  0.694014f,    -1.00183f,   0.798921f,   0.0603123f,   0.213814f,
  0.739642f,    -0.0203375f, 0.72569f,    -0.260224f,   0.0199516f,
  -0.322451f,   0.318204f,   -0.38392f,   0.740994f,    -0.265215f,
  -0.54541f,    -0.51479f,   -0.458397f,  0.519564f,    0.0509182f,
  0.0363331f,   -0.293051f,  0.317714f,   -0.327488f,   -0.0840401f,
  0.318437f,    -0.619403f,  0.641094f,   -0.288435f,   -0.260185f,
  0.181083f,    -0.169294f,  0.292645f,   0.140405f,    0.0572885f,
  -0.637428f,   -0.102616f,  0.288955f,   0.817314f,    0.116855f,
  0.635532f,    0.283334f,   -0.236391f,  -0.305035f,   -0.217365f,
  -0.033021f,   -0.455858f,  0.439922f,   -0.104039f,   0.373376f,
  0.310659f,    0.388789f,   0.266341f,   0.0746306f,   -0.428192f,
  -0.202695f,   -0.347625f,  0.00585741f, 0.366203f,    0.221413f,
  0.518856f,    0.57245f,    -0.375071f,  -0.2436f,     -0.511895f,
  -1.03708f,    0.681455f,   -0.111544f,  -0.183563f,   0.109729f,
  -0.422646f,   -0.529777f,  0.747473f,   -0.270223f,   -0.11435f,
  0.378931f,    0.420456f,   0.236331f,   0.49261f,     -0.0666801f,
  0.0475846f,   0.906095f,   -0.4146f,    -0.020588f,   -0.653285f,
  0.135335f,    0.543846f,   -0.309061f,  0.11899f,     -0.639168f,
  -0.719994f,   -0.219706f,  -0.645631f,  -0.829049f,   -0.0114746f,
  0.834604f,    0.0378035f,  0.107957f,   0.546929f,    -0.674395f,
  -0.854817f,   -1.1443f,    0.223413f,   -0.326324f,   0.440971f,
  0.383582f,    -0.495084f,  0.280091f,   -0.53116f,    0.0333923f,
  -0.354339f,   -0.0449156f, -0.538896f,  -0.753355f,   0.463995f,
  0.000969967f, -0.2832f,    0.587276f,   0.853094f,    -0.481985f,
  -0.138202f,   0.180989f,   -0.349044f,  -0.417534f,   0.455591f,
  0.287332f,    0.251496f,   0.381416f,   0.339632f,    -0.0825727f,
  0.352739f,    0.161697f,   -0.319764f,  -0.258015f,   0.668833f,
  -0.553303f,   -0.578815f,  -0.3758f,    0.289f,       0.247368f,
  0.00681103f,  0.421092f,   -0.191033f,  -0.425868f,   -0.1239f,
  0.0540422f,   -0.0856856f, 0.481168f,   -0.0283741f,  -0.196018f,
  0.230923f,    -0.145288f,  0.52188f,    0.00628462f,  -0.604556f,
  -0.562879f,   0.319282f,   0.323799f,   0.453941f,    0.271129f,
  -0.0520196f,  0.684571f,   -0.391779f,  -0.404614f,   0.134097f,
  -0.825482f,   0.0913949f,  0.483543f,   0.159084f,    0.301637f,
  0.427013f,    0.196153f,   0.460091f,   -0.730573f,   -0.12278f,
  0.221665f,    0.674622f,   -0.623363f,  -0.0761517f,  0.637979f,
  -0.468498f,   0.527276f,   -0.596894f,  -0.34675f,    -0.251241f,
  0.418533f,    -0.476696f,  -0.901267f,  -0.0088241f,  -0.12421f,
  -0.660316f,   -0.0222117f, -0.470898f,  -1.10739f,    -0.441645f,
  0.39516f,     -0.0117906f, 0.254122f,   0.00722599f,  -1.00697f,
  0.48908f,     -0.122287f,  -0.378608f,  -0.339145f,   0.682463f,
  0.305606f,    0.453628f,   -0.49923f,   -0.791388f,   -0.202515f,
  0.23214f,     -0.434209f,  -0.778283f,  -0.538015f,   0.145769f,
  0.446281f,    -0.339329f,  -0.198478f,  -0.183717f,   -0.855441f,
  -0.105778f,   0.575067f,   -0.18592f,   -0.348094f,   0.740614f,
  0.041549f,    -0.109663f,  0.0434492f,  0.245242f,    -1.22192f,
  0.685896f,    -0.208115f,  -0.0616216f, -1.00552f,    0.31045f,
  -0.184394f,   0.466705f,   -0.0984364f, -0.506252f,   0.144874f,
  0.357038f,    0.675221f,   -0.822171f,  -0.52729f,    0.991212f,
  0.432422f,    0.383493f,   -0.372395f,  0.35651f,     -0.25369f,
  0.660208f,    -0.117745f,  -0.142433f,  -0.724115f,   -1.0035f,
  -0.59178f,    0.563444f,   -0.282531f,  -0.599989f,   0.507424f,
  -0.782875f,   0.755029f,   -0.754962f,  -0.617825f,   0.565984f,
  -0.826878f,   -0.456563f,  0.0212161f,  0.469867f,    -0.144864f,
  0.225748f,    -0.279029f,  0.21052f,    -0.440183f,   0.936069f,
  0.170595f,    0.40966f,    0.452453f,   -0.576006f,   1.50696f,
  0.649049f,    0.094957f,   -0.167706f,  -0.258342f,   0.59269f
};

static const float av1_intra_mode_cnn_partition_cnn_layer_0_bias[] = {
  0.00475215f,  -0.00362332f, -0.00317542f, 0.190083f,    0.0488147f,
  -0.0268093f,  -0.00432231f, 0.0112229f,   0.0626653f,   -0.0025698f,
  0.0018675f,   -0.00368139f, -0.00159125f, -0.00034354f, 0.311437f,
  0.000136436f, 0.0667295f,   0.0251274f,   0.00226553f,  -0.000638344f
};

static const float av1_intra_mode_cnn_partition_cnn_layer_1_kernel[] = {
  0.228403f,    0.241933f,     0.181079f,    0.101728f,    0.278455f,
  -0.222078f,   0.387578f,     0.0847356f,   -0.0737012f,  0.26518f,
  -1.0817f,     0.0404161f,    -0.805199f,   0.336576f,    -0.541494f,
  0.246264f,    0.116597f,     -0.756804f,   -0.914136f,   0.410265f,
  0.413294f,    0.07873f,      0.450017f,    -0.264346f,   0.549095f,
  1.03755f,     -0.203542f,    1.61018f,     0.374131f,    0.402515f,
  -2.36115f,    0.116427f,     -0.172157f,   -0.231482f,   -0.905736f,
  -0.0183059f,  -0.575746f,    0.110348f,    -0.268018f,   0.140399f,
  0.427196f,    0.0718528f,    0.247936f,    -0.326661f,   0.150404f,
  -0.659979f,   -0.157148f,    0.00826241f,  -0.679275f,   -0.131564f,
  -1.04822f,    1.06039f,      -0.207898f,   0.510167f,    0.484233f,
  0.138972f,    -0.0801639f,   -0.184416f,   0.0741107f,   -0.0299281f,
  0.112263f,    0.380071f,     -0.0185269f,  -0.0821188f,  0.918796f,
  -0.576106f,   0.593007f,     0.479446f,    0.0440703f,   0.322379f,
  0.176783f,    -0.147111f,    0.0953247f,   -0.636377f,   0.0702104f,
  0.130979f,    0.293892f,     -0.0112124f,  -0.040347f,   -0.16034f,
  0.3252f,      -0.586802f,    0.601786f,    -0.487148f,   -0.458777f,
  0.463835f,    0.144942f,     0.00339965f,  -0.779966f,   0.0585298f,
  -1.20758f,    -0.275614f,    0.292346f,    -0.132781f,   0.337892f,
  -0.357677f,   1.48511f,      0.172907f,    -0.148668f,   0.243184f,
  -0.503392f,   -0.0791543f,   0.0265389f,   -0.102267f,   0.213294f,
  0.0657801f,   0.156996f,     0.0891168f,   0.120805f,    0.261285f,
  -0.343025f,   -0.0792235f,   -0.106415f,   0.133878f,    -0.112981f,
  -0.00151126f, -0.0643829f,   0.0458938f,   -0.0452731f,  -0.00147422f,
  0.1871f,      -0.0208793f,   0.0752037f,   0.0794674f,   0.167666f,
  0.198028f,    -0.361015f,    -0.0661721f,  -0.10672f,    -0.0773641f,
  -1.15856f,    -0.516443f,    -0.322702f,   0.15668f,     0.0075841f,
  -0.157731f,   0.270926f,     -0.241551f,   0.0169097f,   -0.0263953f,
  -0.303556f,   -0.239237f,    0.117792f,    -0.137871f,   0.122054f,
  -0.587381f,   0.112938f,     0.0867262f,   -0.27909f,    -0.203622f,
  -0.622195f,   0.42623f,      0.670704f,    0.190826f,    -0.304979f,
  -0.570075f,   -0.240699f,    0.43744f,     0.632896f,    -0.563846f,
  -0.0160434f,  -0.0709745f,   0.816662f,    0.269999f,    -0.358734f,
  0.193644f,    1.19339f,      -0.118223f,   -0.363291f,   -0.723616f,
  -1.58825f,    0.0222856f,    0.769852f,    0.322713f,    0.0857619f,
  -0.669756f,   -1.08414f,     1.18593f,     0.486166f,    -0.520646f,
  0.0861854f,   -0.134197f,    0.258337f,    0.223345f,    0.697639f,
  -0.57261f,    0.54031f,      0.892644f,    0.497572f,    -0.287076f,
  -1.95928f,    -0.0568128f,   -0.253335f,   0.00233392f,  -0.192787f,
  -0.115203f,   -0.0975649f,   0.277954f,    0.000704534f, -0.315884f,
  0.309583f,    0.357458f,     0.0939298f,   -0.072701f,   0.433045f,
  -0.536938f,   0.534523f,     0.184585f,    -0.0415175f,  -0.120909f,
  -1.2622f,     0.412449f,     -0.114741f,   0.290453f,    -0.441671f,
  -0.0242497f,  -0.20746f,     0.139019f,    -0.422668f,   -0.146732f,
  -0.688828f,   -0.00339426f,  0.04166f,     0.41755f,     0.405675f,
  0.562564f,    0.0216812f,    0.0271391f,   0.215227f,    0.328183f,
  -1.6442f,     -0.827838f,    0.115491f,    0.0951442f,   -0.133779f,
  -0.0482928f,  0.203177f,     0.322953f,    -0.513259f,   0.0676788f,
  -0.0877928f,  0.224448f,     0.451957f,    0.314243f,    0.307403f,
  0.35653f,     0.0286278f,    2.27554f,     0.569313f,    -0.0488753f,
  -2.48809f,    0.274555f,     -0.248375f,   -0.635634f,   -0.187663f,
  0.1827f,      -0.409634f,    -0.0280568f,  -0.207119f,   -0.208192f,
  -0.410268f,   -0.017669f,    0.134856f,    0.434551f,    0.165201f,
  0.584608f,    -0.389997f,    -0.088713f,   0.118087f,    0.00210905f,
  -1.07698f,    -0.520967f,    -0.198742f,   0.190255f,    -0.162639f,
  0.0122759f,   0.460774f,     -0.684633f,   -0.149512f,   0.167556f,
  -0.295034f,   -0.0650964f,   0.0868653f,   -0.691352f,   0.089795f,
  0.0620608f,   0.0531289f,    0.0124286f,   0.151921f,    1.51067f,
  -0.10586f,    -0.0311871f,   0.114706f,    0.0565205f,   -0.159634f,
  -0.423987f,   -0.226896f,    0.0605352f,   -0.36324f,    -0.142205f,
  -0.252249f,   0.0666312f,    0.316655f,    0.00687196f,  0.131079f,
  -0.128281f,   -0.293468f,    1.3327f,      0.542277f,    -0.060088f,
  -1.73475f,    0.0542297f,    -0.227522f,   -0.376004f,   -0.147028f,
  0.0228252f,   0.0569538f,    -0.0796497f,  0.0937596f,   -0.0660153f,
  -0.979219f,   -0.377322f,    0.0523787f,   0.467299f,    0.0824278f,
  0.437147f,    0.263637f,     0.0325681f,   0.303581f,    0.353479f,
  -0.142369f,   -0.394797f,    0.597185f,    0.116482f,    -0.0782593f,
  0.364539f,    -0.30396f,     0.119016f,    -0.0022429f,  -0.044292f,
  -0.0110531f,  0.233571f,     0.000975879f, 0.447332f,    -0.0320396f,
  0.541609f,    0.14232f,      0.163905f,    0.848609f,    0.19954f,
  -0.186591f,   -0.44465f,     -0.431672f,   0.159037f,    -0.129977f,
  -0.141778f,   0.246818f,     -0.197539f,   -0.70115f,    0.185449f,
  0.400274f,    -0.0350744f,   0.239727f,    -0.290504f,   0.0698443f,
  -0.180374f,   -0.759591f,    -0.0569088f,  -0.50246f,    -0.0986616f,
  -0.892114f,   0.306737f,     -0.133937f,   0.285625f,    0.495471f,
  -0.686222f,   -0.168647f,    -0.0926158f,  0.351772f,    -0.0215394f,
  0.361223f,    0.0657142f,    0.268229f,    -0.616299f,   0.0564718f,
  -0.294013f,   -0.588019f,    0.0234195f,   -0.426863f,   -0.511253f,
  -0.72177f,    0.420903f,     0.0987506f,   0.309368f,    0.523532f,
  1.06073f,     -0.33028f,     0.0818142f,   0.0130354f,   0.0180882f,
  0.0316898f,   -0.416614f,    -0.566344f,   -0.163083f,   0.285085f,
  -0.0534352f,  0.385496f,     0.151068f,    -0.208295f,   -0.175648f,
  0.0476705f,   0.190428f,     -0.643391f,   0.484004f,    -0.421836f,
  -0.19829f,    -0.227574f,    -0.0869152f,  1.09881f,     0.345129f,
  -0.236732f,   -0.381935f,    -1.46271f,    0.465914f,    0.610375f,
  0.689968f,    -0.688546f,    1.95033f,     0.420946f,    0.0282428f,
  0.147823f,    0.669393f,     0.429085f,    -0.328385f,   -0.150439f,
  -0.419097f,   -0.828102f,    0.248743f,    0.24644f,     0.0186131f,
  -0.384319f,   -0.126294f,    -0.417067f,   0.271483f,    -0.0128456f,
  -0.881351f,   0.152581f,     0.185584f,    -0.745827f,   0.0551359f,
  0.127083f,    0.936983f,     -0.0225341f,  0.575861f,    0.767417f,
  -0.140867f,   -0.762518f,    0.422446f,    -0.0611973f,  0.0515641f,
  -0.144168f,   -0.298882f,    0.308461f,    0.0208704f,   0.213872f,
  -0.258708f,   1.13186f,      0.314083f,    -0.347536f,   -0.137768f,
  0.653953f,    -0.217883f,    -0.56112f,    -0.864661f,   0.488836f,
  0.268133f,    -0.548664f,    -0.765226f,   0.117082f,    0.326798f,
  -0.678246f,   0.477785f,     -1.27584f,    0.198912f,    -0.710395f,
  1.39096f,     -0.411577f,    -0.55119f,    0.51092f,     -0.295023f,
  0.245983f,    -0.0957192f,   -0.312001f,   0.0175991f,   0.524423f,
  -0.126379f,   0.124687f,     -1.53945f,    -0.342856f,   0.514072f,
  0.400884f,    -0.00581101f,  -0.219327f,   0.0977873f,   0.337551f,
  -0.058603f,   0.20034f,      0.0429945f,   0.676803f,    -0.273585f,
  -0.173435f,   -0.581596f,    0.226263f,    -0.0946223f,  -0.060088f,
  -0.0100809f,  -0.022242f,    -0.22218f,    -0.030463f,   -0.141389f,
  -0.190757f,   -0.00526518f,  -0.77519f,    -0.0825695f,  0.308403f,
  0.262792f,    -0.601842f,    0.0783697f,   0.197527f,    0.0714048f,
  0.0392629f,   -0.388628f,    0.172541f,    -0.0222009f,  0.252096f,
  0.0728652f,   0.173632f,     0.192914f,    -0.00969965f, 0.0530136f,
  -0.00765759f, 0.440234f,     -0.0943323f,  0.112319f,    0.0878737f,
  -0.739021f,   0.385305f,     0.133334f,    -0.396697f,   0.177818f,
  -0.0712558f,  0.516923f,     0.102174f,    0.17158f,     -0.211068f,
  0.295795f,    -0.36198f,     0.179087f,    -0.845744f,   -0.242514f,
  -1.49073f,    0.272702f,     0.59011f,     -0.408184f,   -0.0731313f,
  0.234643f,    0.589642f,     -0.100778f,   0.516921f,    -0.700154f,
  0.316432f,    0.36117f,      0.0380282f,   0.480101f,    -0.0975487f,
  0.941452f,    0.231705f,     -0.151182f,   -1.20305f,    0.28255f,
  -0.0427662f,  -0.00717175f,  -0.842085f,   -0.357376f,   0.545581f,
  -0.290714f,   0.741498f,     1.00377f,     0.483864f,    0.150405f,
  0.0834512f,   -0.10031f,     0.424054f,    -0.0223491f,  -0.0696701f,
  -0.134479f,   -0.747227f,    0.422208f,    0.123858f,    -0.392624f,
  -0.0299847f,  -0.0376142f,   -0.392536f,   -0.0343114f,  0.298224f,
  -0.375899f,   0.693119f,     0.27909f,     -0.53463f,    0.105459f,
  -0.0267383f,  0.5094f,       -0.411557f,   0.451749f,    -0.348479f,
  -0.0497316f,  -0.353913f,    -0.14858f,    0.241838f,    0.331039f,
  0.756607f,    -0.0701661f,   -0.827264f,   -0.367772f,   0.447201f,
  0.834616f,    -0.00497265f,  -0.0557285f,  0.055088f,    -0.300115f,
  -0.143833f,   -1.07838f,     -0.106896f,   0.16945f,     0.0170324f,
  0.108754f,    0.335893f,     -0.0923708f,  0.450209f,    -0.0713308f,
  -0.0233037f,  -0.0129902f,   -1.40664f,    -0.0996218f,  0.711236f,
  0.400716f,    0.227871f,     2.01499f,     0.572926f,    0.135673f,
  -0.0340458f,  -0.316736f,    0.24257f,     -0.700768f,   -0.194985f,
  0.312011f,    -0.179599f,    0.128114f,    0.0725977f,   -0.193816f,
  0.352143f,    0.070641f,     -0.467808f,   -0.399047f,   0.10136f,
  0.671574f,    -0.553965f,    0.105729f,    0.210383f,    0.065048f,
  0.248198f,    -0.731674f,    0.588725f,    -0.308237f,   0.24511f,
  0.00608906f,  0.170906f,     0.246175f,    0.149521f,    0.106071f,
  0.160246f,    0.118487f,     -0.104102f,   0.872823f,    0.227478f,
  0.0182631f,   -0.115083f,    0.0142445f,   0.307947f,    -0.884925f,
  0.0767105f,   0.0414042f,    -0.448021f,   -0.0400193f,  -0.0765448f,
  -0.411931f,   -0.199624f,    0.333371f,    0.17267f,     -0.0431816f,
  0.190826f,    -0.0758961f,   -1.02831f,    -0.0414525f,  0.605374f,
  -0.0188181f,  -0.2207f,      1.30004f,     -0.207005f,   -0.0333617f,
  0.227145f,    0.105059f,     -0.0473393f,  -0.448752f,   -0.0342152f,
  -0.0244812f,  0.220329f,     0.0313591f,   -0.0902074f,  -0.0731945f,
  0.88488f,     0.306306f,     -0.275613f,   -0.476372f,   0.00678104f,
  0.442029f,    0.122049f,     0.118042f,    0.270527f,    -0.462538f,
  0.0665021f,   -0.260255f,    0.209182f,    0.162321f,    0.0629934f,
  -0.244896f,   -0.078863f,    0.655585f,    -0.0506617f,  -0.487128f,
  0.118765f,    -0.34408f,     0.0930615f,   -0.365632f,   -0.0670776f,
  0.44428f,     0.286734f,     0.146608f,    0.686757f,    -0.0738428f,
  -0.10034f,    -0.928438f,    -0.172601f,   -0.0959575f,  -0.010532f,
  0.277549f,    0.28773f,      -0.318883f,   0.71254f,     0.273593f,
  -0.382845f,   -0.0104587f,   -0.647769f,   0.25541f,     0.194625f,
  0.265197f,    -0.750938f,    -0.0650515f,  -0.567092f,   0.070613f,
  0.209531f,    0.429699f,     0.130676f,    0.514914f,    0.615778f,
  0.594535f,    -0.0878778f,   0.40593f,     -0.303383f,   0.0907863f,
  -0.320068f,   0.0137162f,    -0.303424f,   0.594207f,    -0.236524f,
  -0.692627f,   -0.990063f,    -0.0262934f,  0.222375f,    0.503412f,
  0.220224f,    0.676871f,     -0.150996f,   0.379777f,    0.841339f,
  -1.05981f,    0.259943f,     -0.781745f,   0.0346478f,   0.115791f,
  -0.25171f,    -0.00872158f,  0.395561f,    -0.0849893f,  -1.20134f,
  -0.313938f,   0.789542f,     0.159606f,    -0.782095f,   -0.229754f,
  0.266687f,    -0.0354282f,   -0.3041f,     0.0338618f,   -0.390001f,
  -0.28362f,    -0.436144f,    0.777351f,    0.855321f,    0.653338f,
  -0.0382912f,  -0.204577f,    1.13828f,     0.220395f,    -4.60853f,
  0.575694f,    0.0453189f,    1.76567f,     0.466151f,    -0.366109f,
  0.594717f,    0.278891f,     -0.750676f,   -0.332739f,   -0.942304f,
  0.280363f,    0.284561f,     0.209326f,    0.238347f,    -0.0124311f,
  -0.439463f,   -0.036186f,    0.165997f,    0.374717f,    -0.481148f,
  -0.626417f,   0.0223598f,    0.039337f,    -0.379918f,   0.211046f,
  0.0795812f,   0.863355f,     -0.341448f,   0.421494f,    0.410477f,
  -0.117025f,   -0.511108f,    0.565193f,    -0.063582f,   -0.031349f,
  -0.0750174f,  0.387941f,     0.541266f,    0.0919753f,   1.05041f,
  0.263004f,    0.289006f,     0.0439694f,   -1.22439f,    -0.247832f,
  0.260967f,    0.355794f,     0.599694f,    -0.69418f,    0.372805f,
  -0.161731f,   0.0720574f,    0.0394657f,   0.122772f,    -0.458067f,
  -0.370826f,   -1.34495e-05f, -0.373404f,   0.0245539f,   -2.3472f,
  -2.61448f,    0.264794f,     0.0601582f,   -0.968597f,   -0.196022f,
  -0.727067f,   0.167346f,     0.517478f,    0.0035377f,   0.777219f,
  0.553128f,    0.727211f,     0.606202f,    -0.495604f,   2.41445f,
  0.465214f,    -0.0443004f,   0.142972f,    0.141459f,    -0.17771f,
  0.0156117f,   0.169264f,     0.0428022f,   -0.164827f,   -0.240632f,
  0.215289f,    -0.213134f,    -0.184163f,   0.0161321f,   -0.20025f,
  -0.0311616f,  0.00292108f,   -0.0131921f,  0.0437664f,   -0.104817f,
  -0.131906f,   0.0822771f,    0.237307f,    -0.347567f,   -1.2485f,
  0.253616f,    -0.442217f,    0.0514077f,   0.337561f,    -0.0147658f,
  -0.132888f,   -0.643821f,    0.445573f,    -0.0146213f,  0.235511f,
  0.53583f,     -0.640644f,    0.0280044f,   0.00628834f,  0.143885f,
  0.380077f,    -0.542342f,    0.363101f,    0.0647334f,   -0.476556f,
  -0.822676f,   0.482454f,     -0.0467326f,  -0.253083f,   0.116726f,
  0.317333f,    0.548131f,     -0.234667f,   0.579923f,    -0.420683f,
  0.595613f,    -0.279864f,    -0.753204f,   -0.516844f,   -0.436574f,
  -0.120682f,   -0.278939f,    0.752202f,    -0.183443f,   -0.14632f,
  -0.0344068f,  0.127638f,     -0.225245f,   0.489391f,    0.145082f,
  -0.73672f,    0.980065f,     -0.0367412f,  0.40632f,     -0.802509f,
  0.356897f,    0.366172f,     1.23858f,     -0.978381f,   -0.684924f,
  -0.0870693f,  -0.353628f,    0.695788f,    -0.244593f,   -1.8897f,
  -0.257803f,   0.686937f,     0.405155f,    -0.125696f,   0.258075f,
  0.570584f,    -0.439481f,    -0.59798f,    0.0745711f,   -0.235162f,
  0.133048f,    -0.243033f,    0.0415527f,   -0.00118735f, 0.00980514f,
  -0.297429f,   -0.144983f,    0.463093f,    0.0965441f,   -0.338508f,
  -0.651077f,   0.817577f,     -0.0364773f,  -0.388465f,   0.113288f,
  0.231198f,    0.316208f,     -0.592201f,   0.530376f,    -0.431434f,
  0.0200985f,   0.104303f,     -0.130705f,   0.4374f,      0.362342f,
  0.70641f,     0.20037f,      0.309128f,    -0.484535f,   -1.18469f,
  0.513893f,    0.201236f,     -0.022396f,   0.179638f,    -0.361289f,
  -0.0794946f,  -1.04704f,     -0.0281103f,  0.0494822f,   0.00196415f,
  0.0625478f,   -0.229033f,    0.12018f,     0.542629f,    -0.222423f,
  -0.0123321f,  -0.0988525f,   0.773192f,    -0.192218f,   -3.19156f,
  0.300606f,    0.462751f,     2.2968f,      0.137182f,    0.132539f,
  0.165884f,    0.128818f,     -0.155856f,   -0.558538f,   -0.231742f,
  -0.244377f,   -0.442397f,    0.250947f,    0.0850658f,   -0.00820139f,
  0.391284f,    0.17453f,      0.306003f,    -0.531499f,   -0.624451f,
  0.564584f,    -0.343953f,    -0.0278713f,  0.212664f,    -0.135969f,
  -0.0179867f,  -0.687887f,    0.371065f,    -0.0537029f,  0.0499509f,
  0.0980684f,   -0.0438569f,   0.186731f,    0.182105f,    0.172254f,
  -0.149446f,   -0.0247637f,   0.148098f,    1.20772f,     -0.136664f,
  0.00983112f,  0.0181381f,    -0.0147549f,  -0.0846561f,  -0.827022f,
  0.00207177f,  0.0478215f,    0.0652549f,   0.0898219f,   -0.0224959f,
  -0.0274246f,  0.0166498f,    -0.0211715f,  -0.502932f,   0.0961452f,
  0.251206f,    -0.0623632f,   0.741566f,    0.0078449f,   -2.99162f,
  -0.187244f,   0.0743479f,    1.46425f,     0.0737923f,   0.0133544f,
  0.20922f,     -0.178671f,    -0.0528492f,  -0.526717f,   0.0282125f,
  -0.0363201f,  0.37406f,      -0.303658f,   -0.066803f,   0.132237f,
  0.962057f,    -0.399733f,    0.191765f,    -0.452606f,   -0.348732f,
  0.444939f,    0.153025f,     0.0796317f,   0.265985f,    -0.319638f,
  0.0278161f,   -0.333734f,    0.226108f,    0.147895f,    -0.124066f,
  -0.37306f,    0.19541f,      0.200175f,    -0.0593244f,  0.0333887f,
  -0.0284278f,  0.462491f,     0.0686487f,   -0.332435f,   -0.437166f,
  0.302795f,    0.100542f,     0.0265019f,   0.767212f,    -0.140621f,
  0.11558f,     -0.70584f,     -0.00017415f, 0.00793092f,  -0.0490901f,
  0.0598338f,   0.484876f,     -0.13025f,    0.660349f,    0.147503f,
  -0.462766f,   0.0843824f,    0.218493f,    0.310921f,    -0.162284f,
  0.210404f,    -0.788799f,    0.0698512f,   -0.484799f,   0.0311505f,
  -0.308243f,   0.417298f,     0.0593723f,   0.208908f,    0.451437f,
  0.354546f,    -0.0700888f,   -0.281678f,   -0.311177f,   0.00914652f,
  -0.372084f,   0.135036f,     0.185393f,    0.461347f,    -0.114241f,
  -0.402347f,   -0.692327f,    0.0376155f,   -0.200267f,   0.565963f,
  -0.0627442f,  0.429677f,     0.170514f,    0.350565f,    0.699528f,
  -0.948126f,   -0.364205f,    0.348878f,    -0.137832f,   -0.0791649f,
  -0.0462295f,  -0.255078f,    -0.398509f,   0.136783f,    -0.0164628f,
  -0.555472f,   0.690396f,     0.147715f,    0.000523095f, 0.14874f,
  0.524804f,    0.162974f,     0.797599f,    0.277473f,    -0.500696f,
  0.189917f,    -0.333309f,    0.00613646f,  -1.07817f,    0.0470502f,
  0.210766f,    0.159768f,     -0.447774f,   -0.252968f,   -1.72739f,
  0.0658259f,   -0.448747f,    2.26511f,     0.349651f,    0.157232f,
  0.956842f,    0.856676f,     0.149227f,    -0.626957f,   -0.566771f,
  -0.0980846f,  0.351668f,     -0.362741f,   -0.0272282f,  -0.113632f,
  0.366015f,    -0.00790003f,  -0.458632f,   -0.31157f,    -0.182257f,
  -0.953975f,   0.0583582f,    0.164721f,    -0.900107f,   -0.115542f,
  0.0654192f,   0.99056f,      -0.247976f,   0.48254f,     0.670196f,
  0.098585f,    -0.212855f,    0.310072f,    0.0894616f,   0.151944f,
  0.119629f,    -0.26735f,     0.162257f,    -0.0305818f,  0.681526f,
  -0.229847f,   1.01556f,      0.29132f,     0.740113f,    0.0703937f,
  0.537892f,    -0.18653f,     -0.0252359f,  -0.420014f,   0.197631f,
  -0.176629f,   0.00674754f,   0.301288f,    -0.162816f,   0.636235f,
  -0.341362f,   0.197296f,     -0.589747f,   -0.749363f,   -0.277197f,
  -1.27291f,    -0.0857908f,   -0.147591f,   -0.0956297f,  -0.109097f,
  0.0717554f,   0.359078f,     0.301457f,    0.486934f,    -0.260955f,
  -0.126821f,   1.55756f,      0.477469f,    -1.45363f,    1.42198f,
  -0.360847f,   -0.0211924f,   -0.0184957f,  -0.110706f,   -0.152136f,
  0.104703f,    0.267615f,     0.127392f,    0.172996f,    0.258326f,
  0.268578f,    -0.431123f,    -0.114419f,   0.0101172f,   -0.195671f,
  0.0792025f,   -0.151505f,    -0.064077f,   0.0479777f,   -0.141882f,
  0.121492f,    -0.139132f,    -0.348252f,   0.341043f,    -0.565367f,
  -0.0791259f,  -0.781086f,    0.0140045f,   0.571094f,    -0.00875077f,
  0.217132f,    -0.202345f,    0.157213f,    0.228445f,    0.366612f,
  -0.529989f,   0.42241f,      -0.540538f,   -0.0425556f,  -0.207774f,
  -0.0663941f,  0.37836f,      -0.0650245f,  -0.0828694f,  -0.0835478f,
  -0.795512f,   0.470268f,     0.1551f,      -0.69017f,    -0.116735f,
  0.157614f,    0.555973f,     -0.293311f,   0.245428f,    -0.0853701f,
  -0.449278f,   -0.0551647f,   -0.00137429f, 0.709439f,    -0.456796f,
  0.132062f,    -0.0449484f,   -0.308599f,   0.180608f,    -2.24196f,
  0.421478f,    -0.640946f,    -0.460397f,   -0.920628f,   -0.184949f,
  -0.0416982f,  0.6484f,       -0.22806f,    0.412229f,    -0.468079f,
  -0.72372f,    -0.347698f,    -1.3899f,     0.631876f,    0.0611046f,
  0.0294258f,   -0.128091f,    -0.205615f,   0.355348f,    -0.267725f,
  -0.644835f,   0.435879f,     0.517477f,    -0.338123f,   -0.157764f,
  0.32762f,     -0.166454f,    0.221007f,    -0.0438278f,  -0.0777725f,
  0.10986f,     0.941545f,     -0.542284f,   -0.172312f,   -0.256597f,
  -0.0181391f,  0.220623f,     -0.432456f,   0.0164074f,   0.250226f,
  -0.522576f,   0.783109f,     0.198703f,    -0.784554f,   -0.0929628f,
  0.326861f,    0.470293f,     0.442684f,    0.271879f,    -0.108256f,
  0.0483558f,   -0.403151f,    0.36183f,     -0.268186f,   0.270851f,
  -0.696826f,   -0.166037f,    -0.354658f,   0.405977f,    -0.473447f,
  0.649689f,    -0.0863114f,   -0.147319f,   0.0869966f,   0.319792f,
  0.493026f,    -1.07456f,     0.354751f,    0.114605f,    -0.120647f,
  -0.238315f,   0.0290955f,    -0.355299f,   -0.45381f,    0.0812865f,
  -0.0180434f,  0.00861318f,   -0.892943f,   -0.0127801f,  -1.66398f,
  0.290505f,    0.126832f,     2.08173f,     -0.0454847f,  -0.162481f,
  1.07426f,     0.228566f,     0.280528f,    -0.537625f,   -0.175288f,
  -0.118012f,   0.649114f,     -0.349926f,   -0.0189864f,  -0.30934f,
  -0.363178f,   -0.119822f,    -0.22656f,    0.484513f,    -0.173269f,
  0.41987f,     -0.448517f,    -0.0950466f,  0.482443f,    0.061558f,
  0.4219f,      -0.536388f,    0.0781972f,   0.212489f,    0.104229f,
  -0.0792804f,  0.402066f,     -0.676313f,   -0.2272f,     -0.16379f,
  0.260145f,    -0.0504658f,   -0.0826579f,  -1.37749f,    0.00790747f,
  0.0841031f,   -0.0671308f,   -0.00301736f, -0.386206f,   0.190311f,
  0.0702639f,   0.0643968f,    0.133741f,    -0.0141555f,  -0.0365324f,
  0.87028f,     0.207894f,     -0.421266f,   0.689256f,    0.145037f,
  -0.270796f,   0.212604f,     -0.345326f,   0.0074631f,   -1.72379f,
  0.0672097f,   -0.273153f,    1.30503f,     -1.01324f,    0.00284696f,
  0.851459f,    0.176847f,     0.30948f,     -0.57144f,    -0.0596695f,
  -0.111189f,   0.130361f,     -0.298286f,   0.0567591f,   -0.0885215f,
  -0.847601f,   0.238624f,     -0.162391f,   0.452357f,    -0.0192713f,
  0.226661f,    0.0762922f,    -0.0894055f,  0.332702f,    0.424484f,
  0.0443207f,   -0.162345f,    -0.601036f,   0.280527f,    -0.137362f,
  0.266345f,    0.729438f,     -0.887182f,   0.152943f,    -0.573548f,
  -0.0201383f,  -0.56521f,     0.033582f,    0.300284f,    -0.144472f,
  0.633026f,    0.30866f,      0.0653073f,   0.316901f,    0.0721326f,
  0.192252f,    -0.833162f,    0.194292f,    -0.08663f,    -0.189401f,
  -0.178242f,   0.111488f,     0.522487f,    -0.65497f,    0.457049f,
  0.390654f,    0.0522936f,    -0.39712f,    -0.293717f,   -0.374656f,
  -0.118916f,   -0.853076f,    -0.0829578f,  -0.17335f,    -0.0218694f,
  0.367968f,    0.478469f,     0.0913813f,   0.519251f,    0.803526f,
  -0.272516f,   -0.341329f,    0.0897285f,   0.247653f,    0.000898686f,
  0.313196f,    0.000587979f,  -0.314189f,   -0.449439f,   -0.0291611f,
  -0.356287f,   -0.722904f,    -0.0480958f,  -0.523758f,   -0.576146f,
  0.133754f,    0.616921f,     -0.085494f,   0.487487f,    0.745129f,
  0.993267f,    0.256555f,     0.0822743f,   0.0411971f,   0.139388f
};

static const float av1_intra_mode_cnn_partition_cnn_layer_1_bias[] = {
  0.00447951f,  0.0202534f,  0.00970833f, -0.00460874f,  0.0942288f,
  -0.0534704f,  0.00829869f, -0.0255174f, -0.0809143f,   0.00169117f,
  0.0177427f,   0.0259387f,  0.0291077f,  -0.0267599f,   0.100275f,
  -0.00389366f, 0.0315499f,  0.0265846f,  -0.000206604f, 0.0302221f
};

static const float av1_intra_mode_cnn_partition_cnn_layer_2_kernel[] = {
  0.153048f,    0.0725422f,   0.068901f,     -0.475608f,   0.0736706f,
  -0.134076f,   0.229289f,    0.0217921f,    0.0449205f,   -1.00002f,
  0.149133f,    0.0497258f,   0.118988f,     0.0741764f,   0.0385486f,
  0.225181f,    0.012966f,    0.155593f,     -3.07175f,    -0.0641051f,
  0.09161f,     0.0259005f,   -0.209998f,    -0.420298f,   0.0587126f,
  0.00352744f,  0.0451313f,   -0.049384f,    0.11516f,     0.083135f,
  0.103675f,    -0.0185604f,  0.0623248f,    -0.0993726f,  0.0448522f,
  0.0134017f,   -0.294776f,   -0.251924f,    0.0712635f,   -0.0764298f,
  -0.463766f,   -0.0295011f,  -0.579168f,    0.573853f,    -0.00596607f,
  0.0237762f,   -0.0500104f,  -0.0969275f,   0.155573f,    0.0515382f,
  -0.178454f,   -0.154008f,   -0.278299f,    -0.166421f,   0.0149533f,
  -0.0700236f,  0.239287f,    -1.19545f,     -0.0744625f,  0.143037f,
  0.141874f,    0.086302f,    0.0838633f,    -0.454179f,   0.120308f,
  -0.0896718f,  0.254909f,    0.0714462f,    0.00471098f,  -0.869494f,
  0.209407f,    0.138285f,    0.0816641f,    0.0666266f,   0.0848555f,
  0.173313f,    0.0695633f,   0.285667f,     -3.15384f,    0.00140275f,
  -0.969824f,   -0.0318689f,  -0.00487396f,  0.412541f,    0.0263593f,
  -0.249824f,   0.0897776f,   0.0208836f,    -0.0982745f,  -0.16049f,
  -0.12719f,    -0.186166f,   0.102338f,     0.273931f,    -0.0886306f,
  -0.19513f,    -0.0135712f,  -0.194127f,    -0.0834291f,  0.426623f,
  -0.0705446f,  0.0327476f,   0.0800862f,    0.478757f,    -0.00849111f,
  -0.554911f,   -0.0489312f,  -0.184029f,    -0.227428f,   0.159989f,
  -0.0677731f,  -0.0901436f,  0.00308696f,   -0.352243f,   0.278715f,
  0.306374f,    -0.0772054f,  -0.0122733f,   -0.0693457f,  0.074365f,
  -0.267458f,   -0.123612f,   -0.495954f,    0.552604f,    -0.103951f,
  -0.121771f,   0.179966f,    -0.377947f,    -1.35472f,    0.153294f,
  -0.445284f,   -0.089813f,   -0.00529807f,  0.254047f,    -0.0378426f,
  0.114597f,    -0.143052f,   0.0815258f,    -0.10528f,    0.00833533f,
  -0.117508f,   0.129052f,    0.0706719f,    -1.39506f,    0.0124731f,
  0.109831f,    -0.0744156f,  0.181612f,     0.0787894f,   0.0293352f,
  0.494929f,    0.00997207f,  -0.585882f,    -0.0844138f,  -0.00864134f,
  -0.109943f,   0.0713114f,   0.14883f,      0.0610554f,   0.204145f,
  -0.00390313f, 0.0184763f,   -0.111387f,    0.175442f,    -0.0840215f,
  -0.178785f,   -0.0693612f,  -0.254507f,    -0.191549f,   0.501561f,
  -0.0858995f,  -0.164921f,   0.0250706f,    -0.0916282f,  0.247085f,
  0.13877f,     -0.419487f,   -0.295065f,    -0.213812f,   -0.10362f,
  0.138243f,    0.086985f,    0.113633f,     -0.459273f,   0.12388f,
  -0.139296f,   0.253792f,    0.0421624f,    0.0665065f,   -0.977282f,
  0.199927f,    0.115194f,    0.099045f,     0.0534806f,   0.089283f,
  0.0815367f,   0.150901f,    0.253458f,     -3.24825f,    -0.0118163f,
  -0.544565f,   0.0201825f,   -0.0682201f,   0.759028f,    0.00479696f,
  -0.00625607f, 0.058007f,    -0.0811189f,   -0.114617f,   -0.0998578f,
  0.133312f,    0.0246256f,   -0.0167416f,   0.196118f,    0.109823f,
  0.109489f,    0.474682f,    -0.763475f,    0.0818745f,   0.0798777f,
  -0.0994905f,  -0.00138143f, -0.108563f,    0.697289f,    -0.103702f,
  -0.306085f,   -0.0996705f,  -0.142618f,    -0.130989f,   0.0813303f,
  -0.0909275f,  -0.10786f,    -0.0280431f,   0.206877f,    -1.70798f,
  0.525568f,    0.559891f,    -0.166132f,    -0.227574f,   -0.150955f,
  0.0849226f,   0.00497342f,  -0.168667f,    -0.282575f,   0.00537805f,
  -0.0185572f,  0.0607167f,   -0.0534948f,   -0.0215776f,  -0.14825f,
  -0.0164577f,  -0.0611978f,  0.0347562f,    0.286917f,    0.226598f,
  0.149497f,    -0.478101f,   -0.246006f,    0.0663239f,   -0.121728f,
  0.267087f,    0.0802681f,   -0.184741f,    -0.558267f,   0.0437066f,
  0.13816f,     -0.0710939f,  0.0725697f,    0.339857f,    0.161069f,
  0.304871f,    0.108138f,    0.193396f,     0.0891607f,   -0.0701939f,
  -0.182038f,   -0.451873f,   -0.233883f,    0.0444747f,   0.0436545f,
  -0.245894f,   -0.0721136f,  0.309013f,     0.278996f,    0.0259377f,
  0.0278116f,   0.0686773f,   -0.271237f,    0.235082f,    -0.0778285f,
  -0.456541f,   -0.109303f,   -0.074565f,    -0.407301f,   -0.162191f,
  -0.801819f,   0.372435f,    -0.559083f,    -0.039189f,   0.0477762f,
  0.0875363f,   0.0699926f,   0.116552f,     -0.308217f,   0.0341607f,
  -0.14202f,    0.135517f,    0.0316971f,    0.153297f,    -0.759722f,
  0.12849f,     0.114229f,    0.0814893f,    0.275402f,    0.0403976f,
  0.0357503f,   0.212295f,    0.0673998f,    -2.59822f,    -0.0475021f,
  -0.0594725f,  0.0659163f,   0.0469717f,    -0.0370461f,  -0.12863f,
  -0.381743f,   -0.0445055f,  -0.106843f,    -0.0880648f,  0.00591106f,
  0.235514f,    -0.165162f,   -0.0696645f,   0.115374f,    0.245558f,
  0.192049f,    -0.388628f,   -0.48291f,     0.154313f,    -0.160207f,
  0.125928f,    0.122039f,    0.0713794f,    -0.161244f,   0.128082f,
  -0.234659f,   0.0680219f,   0.0597933f,    0.208421f,    -0.163623f,
  0.196873f,    0.156603f,    0.184179f,     -0.278331f,   -0.0481286f,
  0.0828152f,   0.247004f,    0.0915582f,    -0.0906229f,  -0.20376f,
  0.136593f,    0.0740336f,   -0.0134935f,   -0.355048f,   0.0898485f,
  -0.0962068f,  0.185804f,    -0.0145596f,   0.0966589f,   -0.515784f,
  0.121602f,    0.0320428f,   0.11093f,      -0.0559421f,  0.0355484f,
  0.192128f,    0.0500888f,   0.133641f,     -1.73282f,    -0.0624599f,
  0.122524f,    0.0757292f,   -0.0974648f,   -0.193649f,   0.0561096f,
  0.0159959f,   0.0334472f,   -0.0168832f,   -0.12386f,    -0.112419f,
  0.19552f,     0.0308502f,   0.0537643f,    -0.0181012f,  0.0392183f,
  0.0461833f,   -0.52623f,    -0.238252f,    0.0821762f,   -0.212384f,
  0.112901f,    0.096063f,    0.0540225f,    0.0773583f,   0.143045f,
  -0.101551f,   0.282418f,    0.0176749f,    -0.00244542f, -0.780154f,
  -0.254428f,   -5.82215f,    0.106638f,     0.11746f,     0.0486823f,
  0.164562f,    0.0303006f,   0.229614f,     -2.41845f,    -0.117122f,
  0.0451654f,   0.0237383f,   -0.208731f,    0.0721137f,   0.0761163f,
  -0.0569416f,  -0.00830511f, -0.045256f,    0.14535f,     -0.0189222f,
  -0.283363f,   -3.15502f,    0.0971161f,    -0.035913f,   0.00813281f,
  0.0187974f,   -0.361573f,   -0.302067f,    0.118014f,    -0.0956148f,
  -0.596567f,   0.0105443f,   -0.49019f,     -0.0801959f,  0.0322344f,
  -0.0280032f,  0.0555038f,   -0.111495f,    -0.0994456f,  0.0178021f,
  0.0358362f,   1.07063f,     -0.0833138f,   0.0621246f,   0.0637157f,
  0.0999207f,   0.191975f,    -1.2811f,      0.0341681f,   0.14818f,
  0.0957259f,   0.109909f,    0.0566115f,    0.0585633f,   0.179939f,
  -0.104372f,   0.309091f,    0.0172941f,    0.0243182f,   -0.935252f,
  -0.296257f,   -5.83634f,    0.0899249f,    0.455347f,    0.129505f,
  0.220212f,    0.0214801f,   0.284802f,     -2.94585f,    -0.0805413f,
  -1.01819f,    0.00534034f,  -0.057203f,    0.0869331f,   0.0207575f,
  -0.124479f,   -0.0465806f,  0.0894252f,    0.32203f,     0.0858497f,
  0.25178f,     0.0932205f,   0.0888455f,    0.233153f,    -0.446398f,
  -0.00791233f, 0.0909603f,   -0.0904397f,   0.131835f,    0.475597f,
  -0.1236f,     0.0231622f,   0.138602f,     -0.097731f,   -0.0282484f,
  -0.549095f,   -0.0457428f,  -0.0895407f,   -0.293965f,   0.166872f,
  0.46719f,     0.236254f,    0.0615991f,    0.499236f,    0.540366f,
  0.402035f,    0.0606324f,   -0.0499928f,   -0.0155198f,  0.0994403f,
  -0.14773f,    -0.183433f,   -0.612093f,    -0.334201f,   -0.110877f,
  -0.143441f,   0.05815f,     -0.318586f,    -0.344235f,   0.199593f,
  0.51109f,     -0.252281f,   -0.028834f,    0.0615421f,   0.0623699f,
  0.210745f,    -0.236448f,   0.166279f,     0.127516f,    -0.0971157f,
  -0.204389f,   0.208112f,    0.0377023f,    0.271837f,    -0.00859528f,
  0.0797081f,   -0.00582115f, 0.140018f,     -0.384865f,   -0.0853243f,
  -0.586727f,   -0.0664489f,  -0.631436f,    -0.245828f,   -0.0647894f,
  -0.171912f,   -0.0801706f,  0.0731614f,    -0.11725f,    0.281478f,
  -0.03047f,    0.0363488f,   -0.0481651f,   -0.326329f,   -0.0155898f,
  -0.428316f,   -0.0989367f,  -0.271902f,    -0.00263837f, 0.366168f,
  0.325989f,    0.165463f,    0.0668512f,    -0.142202f,   0.419992f,
  0.164971f,    -0.515479f,   -0.187585f,    -0.151783f,   -0.0682468f,
  0.0910191f,   0.117086f,    0.106579f,     0.0961825f,   0.162148f,
  -0.129645f,   0.301039f,    0.000320343f,  -0.0558097f,  -0.844295f,
  -0.218919f,   -5.7571f,     0.0982612f,    0.238955f,    0.0703565f,
  0.0969388f,   0.107202f,    0.321585f,     -3.00594f,    -0.058755f,
  -0.620004f,   0.052114f,    0.128423f,     -0.177673f,   -0.00341509f,
  -0.146756f,   -0.0414309f,  -0.0893262f,   -0.0584779f,  -0.129552f,
  0.127629f,    0.13275f,     -0.0973342f,   -0.215617f,   0.0724309f,
  0.0102229f,   0.178137f,    -0.943374f,    -0.171465f,   0.304949f,
  -0.0963836f,  -0.0346437f,  -0.138667f,    -0.234184f,   0.0344159f,
  -0.319592f,   -0.0990766f,  -0.16065f,     0.369432f,    0.194911f,
  0.363348f,    -0.356009f,   -0.00736217f,  0.241788f,    -2.21311f,
  0.704816f,    0.697019f,    0.129186f,     -0.132799f,   -0.11861f,
  0.0383451f,   0.0247782f,   -0.12687f,     0.0256552f,   0.048413f,
  0.00660549f,  0.0457962f,   -0.012819f,    0.115991f,    -0.1117f,
  -0.291045f,   -0.646138f,   0.0813613f,    0.112063f,    0.191675f,
  0.120835f,    -0.444267f,   -0.340385f,    0.0391936f,   -0.151132f,
  0.184419f,    0.124998f,    -0.14089f,     0.214087f,    0.00108535f,
  0.119611f,    0.0236965f,   0.0715074f,    -0.225997f,   -0.0126552f,
  -0.459214f,   -0.490444f,   0.173716f,     0.355811f,    -0.13607f,
  -0.191091f,   -0.530085f,   -0.400666f,    0.011221f,    0.10527f,
  -0.11498f,    -0.011864f,   0.364376f,     0.0319587f,   -0.0528563f,
  0.0353899f,   0.0393453f,   -0.289211f,    -0.347785f,   -0.0417157f,
  0.545848f,    0.741785f,    -0.0732565f,   -1.29687f,    -0.0433128f,
  -1.44162f,    0.318894f,    -0.377784f,    0.123751f,    -0.00444347f,
  0.0957118f,   0.0893616f,   0.0911595f,    0.092917f,    0.127681f,
  -0.159929f,   0.190417f,    -0.0297948f,   -0.00132599f, -0.742756f,
  -0.0364169f,  -4.00108f,    0.0784767f,    0.223048f,    0.0430138f,
  0.0180493f,   0.212842f,    0.122987f,     -2.83267f,    -0.0641464f,
  -0.173247f,   0.100946f,    0.0804885f,    0.0172631f,   0.0877408f,
  -0.353222f,   0.0108262f,   -0.0452121f,   -0.116127f,   0.268154f,
  -0.132587f,   -0.27481f,    -0.0316914f,   0.0610525f,   0.439691f,
  0.00966415f,  -0.78962f,    -0.424823f,    -0.0214365f,  -0.113846f,
  0.100793f,    0.126482f,    0.0415354f,    0.0427995f,   0.14273f,
  -0.315674f,   0.110095f,    0.0061568f,    0.0320474f,   -0.3596f,
  -0.12533f,    -1.28837f,    0.174673f,     -0.235912f,   0.00495439f,
  0.0695473f,   0.266489f,    0.049248f,     0.0868526f,   -0.0685969f,
  0.102984f,    0.0924639f,   -0.027535f,    0.0709277f,   0.155776f,
  -0.190944f,   0.188273f,    -0.00897471f,  0.0964232f,   -0.475822f,
  -0.209374f,   -5.00252f,    0.103495f,     0.110698f,    0.00682092f,
  0.208586f,    0.0489575f,   0.0966254f,    -1.42973f,    -0.0645128f,
  0.0515961f,   0.0571281f,   -0.0992321f,   0.00791648f,  0.0087609f,
  0.0607367f,   0.0315705f,   0.0183317f,    0.0756087f,   -0.0292847f,
  -0.212932f,   -0.782259f,   0.0899944f,    0.102677f,    0.0681135f,
  0.0447764f,   -0.481969f,   -0.221459f,    0.0794475f,   -0.229157f,
  0.136781f,    0.0832359f,   0.0297807f,    -0.00287225f, -5.97897f,
  -0.0960581f,  0.250945f,    -0.00133314f,  -0.112396f,   -0.856922f,
  0.115776f,    0.124536f,    0.0914194f,    -0.160775f,   0.128684f,
  0.106718f,    0.100665f,    0.139579f,     -0.86141f,    -0.190323f,
  0.0884896f,   0.0363845f,   -0.19831f,     0.121601f,    0.0264453f,
  -0.00557822f, 0.0720238f,   -0.0140132f,   -0.166814f,   -0.266214f,
  0.00500545f,  0.0146905f,   0.126035f,     0.0812372f,   0.0615973f,
  0.0766063f,   -0.420156f,   -0.126157f,    -0.0284299f,  -0.112513f,
  -0.567008f,   -0.0100263f,  -0.607567f,    0.193053f,    0.0067527f,
  -0.0753897f,  0.00134269f,  -0.0512249f,   -0.161661f,   0.0667741f,
  -0.113702f,   -0.071606f,   -0.300563f,    0.276479f,    -0.155318f,
  -0.0512306f,  0.0896443f,   -0.987911f,    0.0440889f,   0.430958f,
  0.175427f,    0.101385f,    0.0303662f,    0.0672653f,   -6.62463f,
  -0.10475f,    0.228249f,    -0.00482173f,  -0.0608713f,  -0.895836f,
  0.187976f,    0.162173f,    0.0747544f,    0.219953f,    0.0682489f,
  0.142665f,    0.100287f,    0.301887f,     -1.97736f,    -0.295001f,
  -1.0733f,     -0.0562668f,  -0.0604295f,   0.0304073f,   0.194274f,
  -0.243593f,   0.0727137f,   0.0610967f,    -0.0692415f,  -0.02967f,
  0.055633f,    0.0192402f,   0.105841f,     0.102236f,    -0.0757102f,
  -0.0067639f,  0.0102317f,   -0.257959f,    -0.0638652f,  0.45521f,
  -0.114967f,   0.0921177f,   0.223796f,     0.277072f,    -0.0613282f,
  -0.564693f,   -0.151333f,   -0.158035f,    0.228491f,    0.12997f,
  -0.192625f,   -0.125344f,   0.0983258f,    -0.931206f,   0.618715f,
  0.273759f,    -0.145527f,   -0.099431f,    -0.119551f,   0.0663484f,
  -0.161419f,   -0.202377f,   -0.545393f,    0.0917645f,   0.042263f,
  -0.17117f,    -0.178622f,   -0.336977f,    0.866715f,    0.0376922f,
  -0.319728f,   -0.127406f,   0.0599384f,    0.268804f,    -0.0331844f,
  0.355326f,    -0.103902f,   0.0425935f,    0.00525512f,  -0.133687f,
  -0.122695f,   0.145582f,    0.139013f,     -0.0053352f,  0.0313566f,
  0.327295f,    -0.0117993f,  0.233524f,     0.162388f,    -0.0793262f,
  0.454543f,    0.0442224f,   -0.742673f,    -0.144882f,   0.0874983f,
  -0.0707259f,  0.0219869f,   0.201728f,     0.0204537f,   0.0788857f,
  -0.0374329f,  0.0724169f,   0.0743593f,    -0.0193526f,  -0.313546f,
  -0.418882f,   -0.0815754f,  -0.197144f,    0.305053f,    0.330196f,
  -0.131006f,   -0.00113249f, 0.0750458f,    -0.541764f,   0.299935f,
  0.308516f,    -0.20547f,    -0.333066f,    0.0285833f,   0.191147f,
  0.160372f,    0.0724649f,   0.0426326f,    0.153046f,    -6.59656f,
  -0.081237f,   0.219163f,    0.0147081f,    -0.0109837f,  -1.01487f,
  0.170055f,    0.163386f,    0.106413f,     0.150188f,    0.0688875f,
  0.0541359f,   0.156307f,    0.178844f,     -1.51054f,    -0.149477f,
  -0.504503f,   0.017878f,    -0.181821f,    -0.0999659f,  0.0484548f,
  -0.32211f,    0.0406744f,   0.0017627f,    0.0220593f,   0.0900512f,
  -0.561625f,   0.107279f,    -0.0861521f,   -0.0862376f,  0.0816765f,
  0.168072f,    0.150063f,    -0.816825f,    -0.13569f,    0.557555f,
  -0.155265f,   0.025135f,    -0.109304f,    -0.0487062f,  -0.00347487f,
  -0.454803f,   -0.0394371f,  -0.214597f,    -0.248898f,   0.286501f,
  -0.249246f,   -0.138935f,   0.00391409f,   -0.122544f,   -2.14993f,
  0.588942f,    0.541231f,    0.0154047f,    -0.359742f,   0.0520729f,
  0.0667058f,   0.0418163f,   -0.132533f,    -0.184759f,   0.0546118f,
  -0.131198f,   0.109664f,    -0.0714679f,   -0.114163f,   -0.243081f,
  -0.0405089f,  0.0342795f,   0.0801825f,    -0.268408f,   0.192207f,
  0.0800494f,   -0.586539f,   -0.118155f,    -0.0508569f,  -0.193987f,
  0.261478f,    0.105719f,    -0.125361f,    -0.0956201f,  0.0233802f,
  0.271098f,    0.0113352f,   0.0910447f,    0.00628244f,  -0.071722f,
  0.21439f,     0.0747191f,   0.207765f,     -0.0782454f,  -0.0151716f,
  -0.196505f,   -0.44798f,    -0.228597f,    0.0549039f,   -0.120715f,
  -0.19388f,    -0.0768461f,  0.361102f,     0.122936f,    -0.0334211f,
  -0.202503f,   -0.0450776f,  -0.272345f,    0.662321f,    0.109247f,
  -0.218026f,   -0.0669386f,  -0.0864701f,   -0.633421f,   -0.158007f,
  -1.10778f,    0.351211f,    -0.541458f,    -0.0171707f,  0.149606f,
  0.106105f,    0.0880349f,   0.0968455f,    0.113269f,    -5.01949f,
  -0.106404f,   0.175578f,    -0.030045f,    -0.0267249f,  -0.563713f,
  0.173885f,    0.130772f,    0.0334519f,    0.0770157f,   0.0394389f,
  -0.0290326f,  0.220003f,    0.180901f,     -1.62203f,    -0.151858f,
  -0.202386f,   -0.0067836f,  0.0287665f,    -0.194183f,   -0.239834f,
  -0.484159f,   0.00671722f,  -0.122459f,    0.0808959f,   -0.263769f,
  -0.015066f,   -0.0429868f,  -0.111255f,    -0.231872f,   0.219659f,
  -0.0437412f,  -0.536618f,   -0.477831f,    0.0421895f,   -0.0815851f,
  0.119638f,    0.0786293f,   -0.000668378f, 0.0305567f,   -0.0868189f,
  -0.178327f,   0.0799657f,   0.0280923f,    -0.211395f,   -0.464577f,
  0.216912f,    0.0761976f,   0.160288f,     -0.416372f,   -0.10286f,
  -0.0733786f,  0.261033f,    0.0493698f,    0.143137f,    -0.179979f,
  0.15655f,     0.0897976f,   -0.0258041f,   -0.152852f,   -6.15512f,
  -0.118917f,   0.227283f,    -0.0514043f,   -0.0786432f,  -0.523485f,
  0.1644f,      0.0869001f,   0.0984082f,    -0.428288f,   0.0791992f,
  0.141904f,    0.0652073f,   0.104429f,     -0.775125f,   -0.121479f,
  0.0841637f,   0.0135705f,   -0.208863f,    -0.0629523f,  0.0455794f,
  0.0513898f,   -0.0147657f,  0.0401145f,    0.0660079f,   0.0210609f,
  -0.0151801f,  0.0562111f,   0.140308f,     -0.0196394f,  0.0230753f,
  -0.0336115f,  -0.422411f,   -0.196974f,    -0.0405748f,  -0.283428f,
  0.15458f,     0.0876296f,   0.0314038f,    0.16389f,     -7.01385f,
  -0.117146f,   0.197273f,    -0.0400688f,   0.0143951f,   -0.964007f,
  -0.0618919f,  0.0406891f,   0.07992f,      -0.144132f,   0.116416f,
  0.0326838f,   0.103641f,    0.171805f,     -1.05158f,    -0.182589f,
  0.116991f,    0.0530774f,   -0.212454f,    -0.016727f,   -0.0565992f,
  0.0712873f,   0.0445466f,   -0.000107032f, -0.121449f,   -0.15148f,
  0.0220338f,   0.0762024f,   0.12253f,      0.0622466f,   0.0835822f,
  0.0465119f,   -0.388743f,   -0.34665f,     -0.0720734f,  -0.101581f,
  -0.630565f,   -0.0512685f,  -0.520541f,    0.0530119f,   -0.0245276f,
  -0.19116f,    -0.0144446f,  -0.0604486f,   0.187251f,    -0.021341f,
  -0.217823f,   0.0510256f,   -0.197946f,    0.060955f,    -0.0617316f,
  0.0741673f,   0.117591f,    -1.47844f,     -0.0911093f,  0.359225f,
  0.145027f,    0.127513f,    0.0617905f,    0.141154f,    -7.63868f,
  -0.0808127f,  0.274843f,    0.00693195f,   -0.0283113f,  -0.853871f,
  -0.15737f,    0.0858904f,   0.0746279f,    0.109912f,    0.193775f,
  0.0698094f,   0.174159f,    0.259556f,     -1.49885f,    -0.156706f,
  -1.04113f,    -0.0329546f,  -0.0491449f,   -0.0304125f,  0.0514892f,
  -0.244284f,   0.126814f,    -0.0387081f,   -0.153173f,   -0.0566748f,
  0.294111f,    -0.0170534f,  0.102381f,     0.447606f,    -0.0613267f,
  -0.0636869f,  -0.0347599f,  -0.259572f,    -0.0657846f,  0.454352f,
  -0.169453f,   -0.00177987f, 0.133279f,     -0.0863932f,  -0.134423f,
  -0.475107f,   -0.00448962f, -0.214607f,    0.111413f,    0.194377f,
  -0.0710837f,  0.0562353f,   0.0401193f,    0.248595f,    0.538374f,
  0.449469f,    -0.39111f,    0.0125057f,    0.0448811f,   -0.00707751f,
  -0.164894f,   -0.317516f,   -0.56231f,     -0.270262f,   0.127016f,
  -0.12092f,    -0.0881587f,  -0.323908f,    0.872344f,    0.103391f,
  0.267971f,    -0.155088f,   -0.0136683f,   0.309517f,    0.119901f,
  0.271307f,    -0.188463f,   0.185121f,     -0.142777f,   -0.110535f,
  -0.163107f,   0.175502f,    0.0801924f,    0.240499f,    0.0874759f,
  0.308907f,    -0.00222504f, 0.193366f,     0.109018f,    -0.0772158f,
  -0.520675f,   0.0259432f,   -0.736666f,    -0.296579f,   0.043486f,
  -0.128932f,   0.0417669f,   0.125747f,     0.157879f,    0.112857f,
  -0.0595681f,  0.0611936f,   -0.042125f,    -0.270338f,   0.120072f,
  -0.36675f,    -0.0347962f,  -0.119539f,    0.0873369f,   0.296432f,
  -0.069501f,   -0.0383859f,  0.0913597f,    -0.40747f,    0.234276f,
  0.332536f,    -0.732132f,   -0.312291f,    0.137759f,    0.227593f,
  0.14165f,     0.129068f,    0.102734f,     0.135818f,    -7.35883f,
  -0.101533f,   0.256027f,    -0.0142278f,   -0.0561601f,  -1.09899f,
  -0.106538f,   0.0612256f,   0.099487f,     -0.0605983f,  0.134311f,
  0.052226f,    0.143672f,    0.219944f,     -1.47539f,    -0.101828f,
  -0.429979f,   0.010478f,    -0.0132605f,   0.103363f,    0.0267373f,
  -0.338865f,   0.0090188f,   0.0810085f,    -0.124368f,   -0.0133776f,
  0.595666f,    -0.00162201f, -0.212444f,    -0.26342f,    0.0913656f,
  -0.106279f,   0.414515f,    -0.709901f,    -0.00198859f, 0.305288f,
  -0.188536f,   -0.0377482f,  -0.131909f,    -0.116099f,   -0.236827f,
  -0.36356f,    0.0179455f,   -0.202143f,    -0.00395508f, 0.177363f,
  0.0630679f,   -0.145173f,   -0.0558639f,   -0.44879f,    -1.55687f,
  0.473398f,    0.50531f,     -0.0656231f,   -0.137197f,   0.064707f,
  0.122083f,    0.0321111f,   -0.167096f,    0.0406581f,   -0.0793592f,
  -0.0777081f,  0.0321379f,   -0.0108834f,   -0.0652323f,  -0.102918f,
  0.0178664f,   0.0781873f,   0.0613189f,    -0.04177f,    0.159566f,
  0.15134f,     -0.445996f,   -0.384905f,    0.0951659f,   -0.175046f,
  0.255746f,    0.177047f,    -0.150632f,    0.200522f,    0.00778549f,
  0.232168f,    -0.0304652f,  0.083155f,     -0.125395f,   -0.0203289f,
  -0.23874f,    0.0349836f,   0.231701f,     -0.14849f,    -0.204272f,
  -0.198309f,   -0.364955f,   -0.228428f,    0.0614142f,   -0.040976f,
  -0.227785f,   -0.0898404f,  0.271566f,     -0.209196f,   0.0226431f,
  -0.0911715f,  0.0840369f,   -0.299411f,    -0.529182f,   0.0622292f,
  0.202475f,    0.0155583f,   -0.083114f,    0.124253f,    -0.22721f,
  -1.02565f,    0.193961f,    -0.54287f,     -0.00849364f, 0.11124f,
  0.0993531f,   0.120621f,    0.0959537f,    0.136274f,    -5.23358f,
  -0.107433f,   0.155286f,    -0.0136043f,   -0.0246768f,  -0.631187f,
  -0.0493852f,  0.0446751f,   0.0588353f,    0.160766f,    -0.0354385f,
  -0.0672548f,  0.243743f,    0.186004f,     -1.20199f,    -0.151872f,
  -0.0760096f,  -0.00775123f, -0.0122227f,   0.0891327f,   -0.377876f,
  -0.469926f,   -0.134715f,   -0.0969362f,   0.212542f,    0.0871489f,
  0.164638f,    -0.0485785f,  -0.167754f,    -0.515052f,   0.13821f,
  0.0515572f,   -0.430691f,   -0.394719f,    0.143947f,    -0.00670816f,
  0.129623f,    0.140299f,    0.0336978f,    0.153545f,    -0.350927f,
  -0.213485f,   0.0344809f,   0.0405889f,    0.0749967f,   -0.369352f,
  -0.109398f,   0.0350649f,   0.190893f,     -0.284106f,   -0.185376f,
  0.0105842f,   0.263692f,    0.160429f,     0.0998209f,   -0.127779f,
  0.140558f,    0.108968f,    -0.0122672f,   0.102875f,    -5.72172f,
  -0.161288f,   0.135935f,    -0.0143087f,   0.106556f,    -0.649813f,
  -0.123049f,   -0.0108861f,  0.102918f,     -0.298137f,   0.0329013f,
  0.100763f,    0.12018f,     0.100782f,     -0.648036f,   -0.111122f,
  0.12363f,     0.0211952f,   -0.225201f,    0.0506021f,   0.0167621f,
  0.0608759f,   -0.0245646f,  0.0503477f,    -0.0972749f,  -0.0415155f,
  -0.00578366f, -0.0977591f,  0.124867f,     0.0134788f,   -0.0375816f,
  -0.00581233f, -0.272292f,   -0.250393f,    0.024511f,    -0.184891f
};

static const float av1_intra_mode_cnn_partition_cnn_layer_2_bias[] = {
  0.182474f,  0.0223202f,  0.204111f, 0.0573683f,  0.111143f,
  0.0800926f, -0.0364215f, 0.192371f, 0.00498262f, 0.302543f,
  0.0133081f, 0.119719f,   0.237522f, -0.266705f,  0.129427f,
  0.0695857f, 0.22068f,    0.231667f, 0.405829f,   -0.0972567f
};

static const float av1_intra_mode_cnn_partition_cnn_layer_3_kernel[] = {
  -0.0393876f,  -0.269924f,   -0.0703231f,   -0.0236484f,  0.170478f,
  0.245566f,    0.175963f,    0.104194f,     -0.0490501f,  -0.157605f,
  -0.0275165f,  -0.0169499f,  -0.250725f,    0.215203f,    -0.00733655f,
  0.0111298f,   0.205606f,    0.928046f,     0.15139f,     0.0955483f,
  -0.015115f,   -0.126643f,   0.0957605f,    -0.140178f,   -0.0246866f,
  0.097097f,    0.116287f,    0.177746f,     0.0570021f,   -0.0518686f,
  -0.0446482f,  -0.0125318f,  0.0116092f,    0.102431f,    0.0898519f,
  0.0870372f,   -0.843274f,   0.383311f,     -0.102761f,   -0.0246494f,
  0.0312555f,   0.19472f,     0.111573f,     0.0920392f,   -0.0555618f,
  0.326461f,    0.219357f,    -0.133727f,    -0.118399f,   -0.0611432f,
  -0.169931f,   0.123733f,    -0.204607f,    0.082592f,    0.0323181f,
  0.201618f,    -0.00388867f, -0.053583f,    0.0266333f,   -0.0951787f,
  -0.0358283f,  -0.0649549f,  0.0119263f,    -0.11812f,    0.209851f,
  -0.036616f,   -0.014911f,   -0.138096f,    -0.139664f,   -0.207395f,
  0.0128848f,   -0.201816f,   0.0899419f,    0.343308f,    -0.0096243f,
  -0.212605f,   -0.0905284f,  -0.0597114f,   -0.055261f,   -0.0653405f,
  0.0330484f,   -0.27681f,    -0.0994095f,   -0.0468272f,  0.145713f,
  0.267216f,    0.185335f,    0.1798f,       -0.0437882f,  -0.200401f,
  -0.0398117f,  -0.0736501f,  -0.166349f,    0.203316f,    0.0710647f,
  0.061825f,    0.281131f,    0.733323f,     0.215488f,    0.00145659f,
  -0.138995f,   -0.0833713f,  0.107809f,     -0.105343f,   -0.0672139f,
  0.101852f,    0.135455f,    0.132903f,     0.0312017f,   -0.0643586f,
  -0.0274546f,  -0.0687466f,  -0.020233f,    0.109444f,    0.0774587f,
  0.139497f,    -0.800587f,   0.325783f,     -0.0546695f,  -0.092003f,
  -0.0773301f,  0.189672f,    0.0604666f,    0.0939425f,   0.679495f,
  0.114789f,    -0.161153f,   0.12843f,      -0.0345385f,  -0.134641f,
  -0.153995f,   0.0823055f,   -0.0349296f,   0.0299183f,   -0.0606872f,
  0.137588f,    0.0449805f,   -0.0555399f,   -0.00553351f, -0.120719f,
  -0.204701f,   -0.0739813f,  0.0584115f,    -0.104833f,   -0.110989f,
  0.00845446f,  0.0630702f,   -0.147861f,    0.0268545f,   -0.216419f,
  0.00531986f,  -0.206641f,   0.253082f,     0.413215f,    -0.05909f,
  -0.0939983f,  -0.116818f,   -0.0450892f,   -0.0551134f,  -0.00696931f,
  -0.113003f,   -0.289192f,   -0.00884866f,  -0.0365724f,  0.0401887f,
  0.238622f,    0.149151f,    0.175751f,     -0.157425f,   -0.138924f,
  -0.0277598f,  -0.0285915f,  0.10165f,      0.209532f,    0.0862249f,
  0.0256428f,   0.623204f,    -0.0941196f,   0.20345f,     -0.132869f,
  0.00947298f,  -0.14753f,    0.103918f,     -0.161799f,   0.125566f,
  0.10916f,     0.115446f,    0.135627f,     -0.0181667f,  -0.0734694f,
  -0.0154729f,  -0.085849f,   -0.000427605f, 0.113614f,    0.0776308f,
  0.111899f,    -0.214917f,   0.393234f,     -0.132223f,   0.020783f,
  -0.074902f,   0.217477f,    0.107883f,     0.109466f,    0.146609f,
  0.317061f,    0.074379f,    -0.0505457f,   -0.0503772f,  -0.0678954f,
  -0.220003f,   0.114878f,    0.176014f,     -0.00657996f, -0.0875497f,
  0.065582f,    0.00238612f,  -0.063395f,    0.0295323f,   -0.127126f,
  0.099813f,    -0.115452f,   0.0106309f,    -0.179632f,   -0.0436553f,
  0.0120295f,   0.0652713f,   -0.131512f,    -0.081714f,   -0.205363f,
  -0.0374944f,  -0.196707f,   0.680568f,     -0.00991824f, -0.0212223f,
  -0.186258f,   -0.432361f,   -0.0291303f,   -0.0475983f,  -0.071383f,
  -0.0116416f,  -0.28257f,    -0.0635272f,   -0.0576546f,  -0.280129f,
  0.286528f,    0.199997f,    0.192851f,     0.323829f,    -0.185006f,
  -0.04791f,    -0.0882187f,  -0.0496895f,   0.293135f,    0.125539f,
  0.0341828f,   0.993452f,    0.0369177f,    0.0453796f,   0.0329807f,
  0.157673f,    -0.153195f,   0.122383f,     -0.161983f,   -0.317619f,
  0.105129f,    0.155673f,    0.152489f,     0.0685417f,   -0.0595907f,
  -0.026657f,   -0.0954336f,  -0.0359557f,   0.105617f,    0.0825066f,
  0.100189f,    -0.22125f,    0.382508f,     -0.0247677f,  -0.115807f,
  -0.0639787f,  0.177786f,    0.0566206f,    0.0496389f,   1.31533f,
  0.0482907f,   -0.118743f,   0.190632f,     0.172867f,    -0.108446f,
  -0.200186f,   0.122572f,    0.0897468f,    0.0155328f,   -0.0380217f,
  0.125161f,    -0.141723f,   -0.023157f,    0.0270805f,   -0.101961f,
  0.12358f,     -0.0866255f,  0.00306761f,   -0.131764f,   -0.461118f,
  -0.00803936f, 0.0895496f,   -0.153905f,    0.207623f,    -0.249099f,
  -0.0198487f,  -0.160013f,   0.81136f,      -0.109978f,   -0.0880332f,
  -0.0761368f,  -0.0755881f,  -0.0384827f,   -0.0554777f,  -0.0750048f
};

static const float av1_intra_mode_cnn_partition_cnn_layer_3_bias[] = {
  0.0106809f, 0.136699f, 0.285316f, 0.395746f
};

static const float av1_intra_mode_cnn_partition_cnn_layer_4_kernel[] = {
  -0.0161019f,  -0.088871f,  0.0463358f,   -0.198037f,   0.038122f,
  0.0135483f,   -0.196641f,  -0.433531f,   0.527972f,    -0.143716f,
  0.558627f,    0.459889f,   0.322864f,    -0.491514f,   -0.190915f,
  -0.0765601f,  0.210329f,   0.689389f,    -0.100415f,   -1.8788f,
  0.2228f,      0.292781f,   -0.954838f,   -0.0788763f,  -0.131402f,
  -0.17154f,    0.049934f,   -0.0541183f,  -0.530529f,   -0.666165f,
  0.195492f,    0.218548f,   -0.314895f,   0.0749444f,   -0.191344f,
  0.349469f,    0.00811248f, -0.760157f,   0.0707434f,   -0.0719285f,
  -0.264495f,   -0.432009f,  -0.432686f,   0.155738f,    -0.020197f,
  0.19278f,     -0.658335f,  -0.273143f,   -0.286079f,   0.243402f,
  0.497701f,    0.0121003f,  -0.666308f,   0.028172f,    -0.547901f,
  -0.11755f,    0.322028f,   0.0878274f,   -0.0328334f,  0.311816f,
  0.0951026f,   -1.11429f,   -0.0417486f,  0.123467f,    -0.0910681f,
  -0.0154255f,  0.311201f,   -0.0156158f,  -0.600437f,   0.0274156f,
  -0.174907f,   -1.29313f,   -0.178656f,   0.596556f,    -0.421725f,
  -0.289137f,   0.529297f,   0.114833f,    -0.0155887f,  -0.308232f,
  -0.0228361f,  0.184017f,   0.138232f,    0.146347f,    -0.117867f,
  0.248351f,    -0.282846f,  -0.18058f,    0.348355f,    -0.415754f,
  0.0657168f,   0.431728f,   -0.231043f,   -0.186745f,   0.137401f,
  -0.282329f,   -0.159678f,  0.754262f,    0.037824f,    -1.68521f,
  -0.290175f,   0.289588f,   -0.18683f,    -0.300385f,   0.285449f,
  -0.00386456f, 0.0563485f,  -0.376541f,   0.159899f,    -0.697312f,
  0.0284389f,   0.437307f,   0.3968f,      -0.372082f,   -0.232535f,
  0.394629f,    0.00315248f, -0.38374f,    0.0311291f,   -0.624353f,
  0.498083f,    -0.342663f,  -0.125978f,   0.186797f,    0.187723f,
  0.149335f,    -0.82727f,   -0.0740974f,  -0.659039f,   0.42671f,
  -0.448835f,   0.150677f,   0.830742f,    -0.233148f,   -0.65308f,
  -0.0878935f,  -0.407797f,  -0.511826f,   -0.0739023f,  0.506305f,
  -0.187451f,   0.0284968f,  -0.822238f,   0.362523f,    -0.270865f,
  0.032335f,    0.560413f,   -0.00388247f, -0.446333f,   0.163147f,
  -0.409633f,   -0.372575f,  0.306993f,    0.55953f,     -0.24362f,
  -0.0929369f,  -0.520298f,  -0.444022f,   0.186077f,    -0.0942208f,
  0.624049f,    -0.429625f,  -0.869528f,   0.405257f,    -0.120445f,
  0.537685f,    -0.3911f,    0.142142f,    0.0913808f,   -0.00375967f,
  0.382781f,    0.60505f,    -0.271608f,   -0.0630436f,  -0.150625f,
  -0.0124598f,  0.0132878f,  0.138475f,    -0.106264f,   -0.416581f,
  -0.518415f,   0.185127f,   -0.464622f,   -0.0102925f,  0.0389567f,
  0.406439f,    -0.0414264f, -0.366185f,   -0.511867f,   -0.650255f,
  0.278252f,    0.0270234f,  0.262788f,    -0.0294793f,  0.12651f,
  0.421537f,    0.0300837f,  0.0742187f,   0.281954f,    -0.122069f,
  -0.450145f,   -0.312206f,  -0.402633f,   -0.0868137f,  0.190433f,
  -0.149602f,   -0.175029f,  0.00900023f,  -0.266596f,   0.21721f,
  -0.245079f,   -1.09798f,   0.319409f,    -0.337938f,   0.358514f,
  0.0771549f,   0.447087f,   -0.305507f,   -0.285492f,   0.383896f,
  0.145933f,    -0.264944f,  -0.118486f,   0.068805f,    -0.194231f,
  -1.79133f,    0.363408f,   -0.17434f,    -0.229629f,   0.132188f,
  0.207548f,    -0.876264f,  0.265634f,    0.139332f,    0.236206f,
  -0.0145184f,  0.562865f,   0.526612f,    -0.0333508f,  -0.421885f,
  0.273485f,    -0.110882f,  0.425557f,    0.513303f,    -0.422322f,
  0.0563155f,   -0.0409693f, 0.194768f,    -0.419828f,   -0.107195f,
  -1.19224f,    0.48552f,    0.132782f,    -0.00932096f, -0.225484f,
  -0.428484f,   -0.0392684f, 0.750697f,    0.337615f,    0.158476f,
  0.413484f,    0.326017f,   -0.757107f,   -0.183962f,   0.00884361f,
  0.126507f,    -0.0751588f, -0.308782f,   -0.104237f,   -0.703877f,
  -0.491806f,   -0.204251f,  -0.317212f,   0.0815479f,   0.296323f,
  0.219632f,    -0.039859f,  0.556257f,    0.176144f,    -0.0750654f,
  -0.106419f,   0.00400385f, -0.172266f,   0.000178763f, 0.146532f,
  0.255202f,    -0.427235f,  -0.182198f,   -0.256557f,   0.260255f,
  -0.0143364f,  0.0868664f,  -0.564373f,   -0.0876947f,  0.726289f,
  0.0160001f,   -0.381562f,  -0.638214f,   -0.803803f,   0.25945f,
  -0.371542f,   -0.419611f,  0.238617f,    0.371834f,    -0.226777f,
  -0.894602f,   0.37458f,    -0.354866f,   0.0249312f,   0.142374f,
  0.433813f,    -0.0218183f, -0.33248f,    0.107223f,    0.390823f,
  -0.0271108f,  -0.616878f,  -0.604984f,   0.517269f,    -0.293573f
};

static const float av1_intra_mode_cnn_partition_cnn_layer_4_bias[] = {
  -0.290371f, -0.0560272f,  -0.118144f,  -0.270583f,  0.401388f,
  -0.308677f, 0.150729f,    -0.0324442f, -0.135937f,  0.0875581f,
  0.0206493f, -0.212682f,   -0.0266535f, -0.326656f,  0.0185105f,
  -1.01429f,  -0.00315052f, -0.0273938f, -0.0263379f, -0.171702f
};

static const CNN_CONFIG av1_intra_mode_cnn_partition_cnn_config = {
  NUM_CNN_LAYERS,  // num_layers
  0,               // is_residue
  0,               // ext_width
  0,               // ext_height
  0,               // strict_bounds
  {
      {
          CNN_LAYER_0_IN_CH,                                // in_channels
          CNN_LAYER_0_WIDTH,                                // filter_width
          CNN_LAYER_0_WIDTH,                                // filter_height
          CNN_LAYER_0_OUT_CH,                               // out_channels
          CNN_LAYER_0_HORZ_STRIDE,                          // skip_width
          CNN_LAYER_0_VERT_STRIDE,                          // skip_height
          0,                                                // maxpool
          av1_intra_mode_cnn_partition_cnn_layer_0_kernel,  // weights
          av1_intra_mode_cnn_partition_cnn_layer_0_bias,    // bias
          PADDING_VALID,                                    // pad
          RELU,                                             // activation
          0,                                                // deconvolve
          0,                                                // branch
          BRANCH_NO_COPY,                                   // branch_copy_type
          BRANCH_NOC,        // branch_combine_type
          NO_BRANCH_CONFIG,  // branch_config
          NO_BN_PARAMS,      // bn_params
          -1,                // output_num
      },
      {
          CNN_LAYER_1_IN_CH,                                // in_channels
          CNN_LAYER_1_WIDTH,                                // filter_width
          CNN_LAYER_1_WIDTH,                                // filter_height
          CNN_LAYER_1_OUT_CH,                               // out_channels
          CNN_LAYER_1_HORZ_STRIDE,                          // skip_width
          CNN_LAYER_1_VERT_STRIDE,                          // skip_height
          0,                                                // maxpool
          av1_intra_mode_cnn_partition_cnn_layer_1_kernel,  // weights
          av1_intra_mode_cnn_partition_cnn_layer_1_bias,    // bias
          PADDING_VALID,                                    // pad
          RELU,                                             // activation
          0,                                                // deconvolve
          0,                                                // branch
          BRANCH_NO_COPY,                                   // branch_copy_type
          BRANCH_NOC,        // branch_combine_type
          NO_BRANCH_CONFIG,  // branch_config
          NO_BN_PARAMS,      // bn_params
          3,                 // output_num
      },
      {
          CNN_LAYER_2_IN_CH,                                // in_channels
          CNN_LAYER_2_WIDTH,                                // filter_width
          CNN_LAYER_2_WIDTH,                                // filter_height
          CNN_LAYER_2_OUT_CH,                               // out_channels
          CNN_LAYER_2_HORZ_STRIDE,                          // skip_width
          CNN_LAYER_2_VERT_STRIDE,                          // skip_height
          0,                                                // maxpool
          av1_intra_mode_cnn_partition_cnn_layer_2_kernel,  // weights
          av1_intra_mode_cnn_partition_cnn_layer_2_bias,    // bias
          PADDING_VALID,                                    // pad
          RELU,                                             // activation
          0,                                                // deconvolve
          0,                                                // branch
          BRANCH_NO_COPY,                                   // branch_copy_type
          BRANCH_NOC,        // branch_combine_type
          NO_BRANCH_CONFIG,  // branch_config
          NO_BN_PARAMS,      // bn_params
          2,                 // output_num
      },
      {
          CNN_LAYER_3_IN_CH,                                // in_channels
          CNN_LAYER_3_WIDTH,                                // filter_width
          CNN_LAYER_3_WIDTH,                                // filter_height
          CNN_LAYER_3_OUT_CH,                               // out_channels
          CNN_LAYER_3_HORZ_STRIDE,                          // skip_width
          CNN_LAYER_3_VERT_STRIDE,                          // skip_height
          0,                                                // maxpool
          av1_intra_mode_cnn_partition_cnn_layer_3_kernel,  // weights
          av1_intra_mode_cnn_partition_cnn_layer_3_bias,    // bias
          PADDING_VALID,                                    // pad
          RELU,                                             // activation
          0,                                                // deconvolve
          0,                                                // branch
          BRANCH_NO_COPY,                                   // branch_copy_type
          BRANCH_NOC,        // branch_combine_type
          NO_BRANCH_CONFIG,  // branch_config
          NO_BN_PARAMS,      // bn_params
          1,                 // output_num
      },
      {
          CNN_LAYER_4_IN_CH,                                // in_channels
          CNN_LAYER_4_WIDTH,                                // filter_width
          CNN_LAYER_4_WIDTH,                                // filter_height
          CNN_LAYER_4_OUT_CH,                               // out_channels
          CNN_LAYER_4_HORZ_STRIDE,                          // skip_width
          CNN_LAYER_4_VERT_STRIDE,                          // skip_height
          0,                                                // maxpool
          av1_intra_mode_cnn_partition_cnn_layer_4_kernel,  // weights
          av1_intra_mode_cnn_partition_cnn_layer_4_bias,    // bias
          PADDING_VALID,                                    // pad
          RELU,                                             // activation
          0,                                                // deconvolve
          0,                                                // branch
          BRANCH_NO_COPY,                                   // branch_copy_type
          BRANCH_NOC,        // branch_combine_type
          NO_BRANCH_CONFIG,  // branch_config
          NO_BN_PARAMS,      // bn_params
          0,                 // output_num
      },
  },
};

static const float
    av1_intra_mode_cnn_partition_branch_0_dnn_layer_0_kernel[] = {
      0.604356f,    -0.236007f,   0.342172f,   0.531397f,     -0.635698f,
      -0.591573f,   0.833872f,    0.492814f,   -0.100308f,    0.186385f,
      0.202779f,    0.263578f,    0.330001f,   -0.15531f,     0.879584f,
      -0.0048796f,  0.490796f,    0.242254f,   -0.292211f,    -0.696912f,
      0.746664f,    0.129371f,    -0.0122443f, 0.196234f,     -0.251605f,
      -0.385617f,   0.157707f,    0.699963f,   0.0432536f,    -0.11141f,
      -0.0353473f,  -0.0364045f,  -0.113556f,  -0.520842f,    0.231248f,
      0.230638f,    -0.323852f,   -1.08633f,   -0.0469168f,   -0.481821f,
      0.366838f,    0.189627f,    -0.0637262f, -0.484917f,    -0.109874f,
      0.292237f,    0.368702f,    -0.183896f,  -0.109038f,    -1.22613f,
      -0.880355f,   -1.63768f,    0.337426f,   -0.940994f,    0.413097f,
      -0.37879f,    -0.480525f,   -0.594819f,  -0.0172653f,   -0.499436f,
      -0.298395f,   -0.840181f,   -0.0758645f, -0.772089f,    -0.232727f,
      -0.815968f,   0.160785f,    -0.0767165f, 0.0064244f,    -0.540491f,
      0.417776f,    -0.384337f,   -0.497377f,  0.68414f,      0.00797514f,
      0.262626f,    0.203732f,    0.702047f,   0.0617544f,    0.0878249f,
      -0.315032f,   -0.0169776f,  0.403986f,   0.815872f,     0.135388f,
      0.0858594f,   0.169172f,    -0.638227f,  -1.65268f,     -0.0476042f,
      -0.982685f,   0.45707f,     -0.0577537f, 0.367329f,     0.176513f,
      -0.356454f,   0.0979095f,   -0.277476f,  0.257271f,     -0.333451f,
      0.0241497f,   0.0671127f,   0.221216f,   0.106065f,     0.537151f,
      0.0257329f,   0.265559f,    -0.348353f,  0.285569f,     -0.0610511f,
      -1.59334f,    -1.63826f,    -0.164898f,  -0.36605f,     -0.489304f,
      0.729241f,    0.0197627f,   0.200291f,   -0.231506f,    -0.255715f,
      -0.0932264f,  -0.728793f,   0.468297f,   -1.09592f,     -0.079791f,
      -1.76531f,    -0.182904f,   -2.05897f,   -0.371894f,    0.207124f,
      0.255029f,    0.186501f,    -0.005805f,  0.00160733f,   -0.178206f,
      -0.352757f,   -0.164741f,   -0.557583f,  -0.559692f,    -0.00731467f,
      0.149326f,    0.409735f,    0.22083f,    -0.332572f,    -0.1741f,
      -0.0519008f,  -0.266402f,   0.294031f,   -2.4453f,      0.339851f,
      -0.573747f,   -5.97783f,    -0.084142f,  0.20286f,      -0.576038f,
      -0.111081f,   0.101238f,    -5.83427f,   -1.98537f,     0.322796f,
      -0.60171f,    0.212412f,    0.247176f,   0.603694f,     -0.54357f,
      -0.693439f,   0.250725f,    -4.31988f,   0.0935924f,    0.43669f,
      -0.139706f,   -0.158391f,   0.244309f,   0.619213f,     -0.309154f,
      -0.135341f,   0.475815f,    -0.290804f,  -0.109038f,    -0.0937104f,
      0.0385907f,   -0.29105f,    -0.0597651f, -0.451187f,    -1.51821f,
      0.141772f,    0.822204f,    -0.729661f,  -0.109908f,    0.178217f,
      -0.750278f,   0.113762f,    -0.0959985f, 0.066579f,     -0.104209f,
      -0.951378f,   1.4087f,      -1.13175f,   -1.09103f,     -1.50416f,
      -0.182273f,   -1.80129f,    -0.152135f,  0.356931f,     0.205591f,
      0.183148f,    -0.498671f,   -0.183034f,  -0.176428f,    0.395706f,
      -0.589908f,   -0.318276f,   -0.421162f,  0.658766f,     -0.186752f,
      0.0656253f,   0.248002f,    0.289618f,   -0.458111f,    -0.130789f,
      -0.542988f,   0.405804f,    -0.35364f,   -0.311927f,    0.218339f,
      0.309215f,    -0.130347f,   -0.0257543f, 0.0413234f,    -0.190205f,
      -0.242382f,   0.819886f,    -0.255157f,  -0.181219f,    -0.290903f,
      -0.301995f,   -0.0469988f,  0.702936f,   0.209122f,     0.0234243f,
      0.598637f,    0.0305196f,   0.0423457f,  -0.618799f,    0.0190867f,
      0.420584f,    -0.224752f,   -0.410077f,  0.127854f,     0.395261f,
      -0.393685f,   -0.282822f,   0.0289504f,  0.0406515f,    -0.511531f,
      -0.497611f,   0.0252715f,   0.0812549f,  0.80205f,      1.29084f,
      0.764972f,    0.561258f,    -0.23499f,   0.217594f,     -0.690935f,
      -0.26607f,    0.357955f,    0.391608f,   0.448352f,     0.458586f,
      -0.790071f,   0.719959f,    -0.468052f,  1.24579f,      0.220705f,
      0.284044f,    0.141346f,    0.246687f,   0.147826f,     -0.403557f,
      -0.00648195f, 0.398034f,    -0.100464f,  -0.77107f,     -0.188274f,
      -0.219245f,   -0.0330375f,  0.367585f,   -0.220391f,    0.308736f,
      0.221399f,    0.340292f,    0.037597f,   0.606083f,     0.665634f,
      -0.755529f,   -0.95989f,    -0.243673f,  0.233709f,     -0.454628f,
      -0.110952f,   0.776062f,    0.731136f,   -0.140422f,    0.19261f,
      0.355086f,    0.975026f,    0.190936f,   0.776205f,     0.982781f,
      0.555569f,    0.42382f,     -0.409721f,  0.25053f,      -0.271328f,
      0.859941f,    -0.0210901f,  0.0176916f,  -0.562895f,    -0.0787431f,
      -0.861032f,   -0.34022f,    -0.571995f,  0.205436f,     0.346968f,
      0.377033f,    -1.08484f,    0.297007f,   -1.01693f,     0.189463f,
      -0.483242f,   0.147058f,    0.0159503f,  0.0908779f,    -0.46962f,
      0.174024f,    -0.490704f,   -0.383501f,  -0.0507626f,   0.00902188f,
      -0.202495f,   0.205047f,    0.0562261f,  -0.143371f,    0.219524f,
      -0.317294f,   -0.0575756f,  -0.0595825f, -0.000625279f, -0.278864f,
      -0.0516874f,  -0.225259f,   0.429046f,   -0.0952421f,   0.0799135f,
      -0.122883f,   -0.262308f,   -0.481006f,  -0.0466122f,   -0.402822f,
      0.150595f,    -0.0919558f,  -0.356765f,  -0.199222f,    0.219389f,
      -0.214452f,   -0.196361f,   -0.095758f,  -0.115891f,    -0.143777f,
      0.549843f,    -0.113036f,   0.764895f,   -0.0114812f,   -0.0684054f,
      -0.98045f,    -0.0170634f,  0.247719f,   -0.18718f,     -0.381566f,
      0.150758f,    -0.526257f,   1.00851f,    0.776634f,     1.69728f,
      -0.303058f,   0.228967f,    -0.414134f,  0.0858226f,    -0.285472f,
      0.431459f,    0.315318f,    0.587835f,   0.335737f,     -0.0222039f,
      0.18945f,     0.274008f,    0.609263f,   0.320232f,     -0.214137f,
      -0.0297668f,  0.0439046f,   -0.52821f,   -0.0127375f,   0.431885f,
      0.508846f,    -0.329189f,   -0.166778f,  -0.94338f,     -0.358807f,
      0.208641f,    -0.517986f,   -0.128278f,  0.693464f,     -0.24408f,
      -0.0669412f,  -0.410287f,   0.0444145f,  -0.264179f,    0.143884f,
      0.276842f,    0.498934f,    -0.682557f,  -0.217198f,    -0.8249f,
      -0.40446f,    -0.115376f,   0.417934f,   0.65605f,      -0.00570035f,
      -0.365742f,   -0.367625f,   0.526824f,   -0.0164913f,   -0.255998f,
      0.247292f,    0.0846536f,   0.109302f,   -0.302996f,    0.160564f,
      0.0228132f,   0.035211f,    -0.236951f,  0.493801f,     1.37315f,
      -0.182348f,   0.234437f,    -0.256906f,  0.12523f,      0.667113f,
      -0.437981f,   -0.0721831f,  0.303976f,   -0.041336f,    -0.145894f,
      -0.733741f,   0.436056f,    0.368542f,   -0.149072f,    -0.290281f,
      0.0946743f,   -0.0579292f,  0.264539f,   0.170048f,     0.262411f,
      0.049679f,    0.371369f,    0.760675f,   0.482157f,     -0.0196783f,
      0.260888f,    0.948856f,    0.170228f,   -0.134432f,    -0.942235f,
      -1.23226f,    -0.373963f,   -0.0381773f, -0.17947f,     0.00947998f,
      0.01086f,     0.389578f,    -0.380389f,  -0.0865851f,   -0.220328f,
      -0.171901f,   -0.384325f,   -0.0787615f, 0.392678f,     0.123392f,
      -0.0895824f,  0.00480886f,  -0.162918f,  0.214336f,     -0.00147339f,
      0.203899f,    -0.00292344f, -0.148594f,  0.0425697f,    -0.306896f,
      -0.342225f,   -0.45088f,    -0.184454f,  -0.00923638f,  -0.521993f,
      -0.334464f,   0.156497f,    -0.0856832f, -0.277661f,    -0.0721105f,
      -0.488781f,   -0.509543f,   -0.012664f,  0.0940558f,    -0.29869f,
      0.0434843f,   -0.0178945f,  -0.0525666f, -0.303178f,    0.713507f,
      -0.137413f,   -0.170289f,   -0.142942f,  -0.316002f,    0.229125f,
      -0.277585f,   0.0125026f,   0.508316f,   -1.20614f,     -0.915129f,
      -1.63389f,    -0.454604f,   -0.893951f,  -0.447403f,    -0.751423f,
      1.3886f,      0.617818f,    0.611458f,   -0.884173f,    -0.7779f,
      -0.608639f,   -0.164759f,   -0.631846f,  -0.176894f,    -0.459361f,
      -0.187119f,   0.173283f,    -0.477191f,  -0.156736f,    0.182675f,
      0.598854f,    -0.489941f,   -0.420493f,  -0.162002f,    0.344418f,
      0.33832f,     -0.187463f,   -0.388721f,  -0.0733151f,   -0.138835f,
      0.313699f,    0.0625967f,   -0.291488f,  0.114088f,     -0.356843f,
      0.197506f,    0.0320749f,   1.16745f,    -0.36081f,     1.63416f,
      0.198392f,    1.13928f,     -0.317971f,  0.531019f,     0.526518f,
      0.185814f,    0.0923607f,   0.192858f,   -0.234378f,    0.18091f,
      -0.228837f,   0.397216f,    0.581501f,   0.284376f,     -0.130434f,
      0.20076f,     0.242662f,    -0.0480872f, 0.131746f,     0.362712f,
      0.0146821f,   0.475679f
    };

static const float av1_intra_mode_cnn_partition_branch_0_dnn_layer_0_bias[] = {
  0.477356f,   0.385222f,  0.389122f, 0.539506f,   -0.0272558f, 0.581605f,
  -0.800961f,  0.142229f,  0.117549f, -0.0724944f, 0.102095f,   -0.71319f,
  -0.0162434f, -0.132858f, 0.543411f, -0.626599f
};

static const float
    av1_intra_mode_cnn_partition_branch_0_dnn_layer_1_kernel[] = {
      0.195436f,   -0.623354f,  1.27907f,    0.270071f,   -0.677612f,
      0.0266141f,  0.272991f,   -0.425446f,  0.891889f,   -0.299836f,
      -0.611825f,  -0.0322273f, 0.185276f,   0.238639f,   -0.150954f,
      0.083495f,   -0.472106f,  0.573506f,   1.16465f,    -0.154947f,
      0.640631f,   -1.59467f,   -9.8166f,    -0.22889f,   -0.189912f,
      0.227052f,   -0.540787f,  0.0840873f,  -3.04293f,   -0.0209975f,
      -6.10979f,   -5.92801f,   0.288467f,   -0.169476f,  0.0527948f,
      -1.21202f,   -0.280915f,  0.290863f,   -0.601877f,  0.0598784f,
      -0.592136f,  -0.535588f,  -0.0434018f, -0.653223f,  0.00339129f,
      -0.133273f,  0.279463f,   0.483879f,   0.463664f,   -0.14174f,
      -1.56354f,   0.560043f,   -1.44639f,   0.673528f,   -0.108418f,
      -0.707313f,  0.49633f,    -0.0321971f, 0.411475f,   -0.382184f,
      -0.965501f,  -0.0507655f, 0.540415f,   -0.977297f,  0.370382f,
      -0.375683f,  0.0844529f,  -2.0002f,    -0.346289f,  0.621251f,
      -0.489855f,  0.191252f,   -0.576629f,  -0.35773f,   0.023167f,
      0.180793f,   -0.417864f,  0.0587254f,  0.167824f,   0.0612058f,
      -0.712108f,  0.155614f,   0.900036f,   -0.480124f,  0.146117f,
      0.467011f,   0.412525f,   0.312724f,   0.551826f,   -0.179601f,
      0.706261f,   0.00674965f, -0.495221f,  0.140829f,   -0.0619195f,
      -0.0697912f, 0.511967f,   -0.0318237f, -0.285946f,  -0.28608f,
      0.0894142f,  0.234351f,   -0.272328f,  -0.350369f,  -0.392605f,
      0.287318f,   0.310426f,   0.293524f,   0.357681f,   -0.157868f,
      0.149652f,   -0.259363f,  0.192941f,   -0.850096f,  0.456507f,
      0.387857f,   -0.491187f,  -0.0541993f, -0.28118f,   0.193991f,
      -0.0956664f, 0.0679829f,  0.0341118f,  0.141826f,   0.271538f,
      -0.285295f,  -0.68666f,   0.306414f,   0.600678f,   0.494801f,
      -1.11907f,   0.524849f,   0.151169f,   0.474068f,   -0.43441f,
      -0.229138f,  0.0345483f,  0.682888f,   -0.471534f,  -0.0457066f,
      -2.36721f,   0.446407f,   0.20396f,    -1.17868f,   0.815363f,
      -1.13897f,   0.397217f,   -0.593796f,  -6.95512f,   0.650695f,
      0.771657f,   0.15227f,    -0.824519f,  0.617854f,   -0.295353f,
      -0.101207f,  0.600989f,   -0.550653f,  -0.722371f,  0.292006f,
      -0.451891f,  0.54544f,    0.354278f,   0.0136258f,  0.192003f,
      0.258275f,   -0.0443647f, 0.0928186f,  0.667775f,   0.239558f,
      0.0523887f,  0.71586f,    0.292563f,   0.362479f,   0.373453f,
      0.250638f,   -0.423037f,  -0.486574f,  -0.619397f,  0.343888f,
      0.974971f,   0.574218f,   0.273989f,   -0.209956f,  -0.274333f,
      0.0553766f,  0.263918f,   0.733824f,   0.038713f,   -0.0788992f,
      0.292014f,   0.111808f,   -0.197507f,  0.593668f,   -0.0245337f,
      0.0873662f,  0.530997f,   0.620717f,   0.310697f,   -1.54861f,
      1.12915f,    0.0991346f,  -0.59214f,   0.422325f,   -0.0157936f,
      0.380975f,   0.626403f,   0.268064f,   -0.615231f,  -1.43172f,
      0.0928048f,  0.0949026f,  -0.470912f,  -0.0867527f, -0.0381206f,
      0.178393f,   -1.13737f,   0.12798f,    0.258214f,   -0.803364f,
      0.177506f,   0.542718f,   0.660656f,   0.145091f,   0.183056f,
      -0.47338f,   0.469287f,   0.10832f,    0.0994899f,  -0.402719f,
      0.157287f,   0.523071f,   -0.324493f,  0.343599f,   0.664839f,
      -0.0375519f, -0.279238f,  -0.0722333f, 0.395344f,   -0.289316f,
      0.0259298f,  -0.843245f,  -0.160021f,  0.741429f,   -1.38726f,
      -0.2969f,    -0.240443f,  0.247731f,   -1.04088f,   -0.280454f,
      -0.237054f,  -0.759227f,  0.0456369f,  -0.647453f,  -1.02372f,
      -0.200395f,  -0.546839f,  -0.104226f,  -0.152727f,  -0.56685f,
      -0.0559663f, -0.425494f,  -0.610679f,  -0.987096f,  -0.575138f,
      -0.0887979f, 0.463646f,   -1.041f,     -0.49412f,   -0.175298f,
      -0.463296f,  -0.955177f,  0.17852f,    -1.10694f,   0.181991f,
      -0.18998f,   0.227818f,   0.688237f,   -1.10444f,   0.549108f,
      -0.171849f,  -0.245614f,  0.120624f,   1.29571f,    0.607116f,
      0.00809927f, 0.1041f,     -1.22918f,   -0.212948f,  0.430239f,
      -1.57341f,   0.482054f,   0.275905f,   0.939785f,   -1.0209f,
      -0.355534f,  0.397337f,   -0.0593077f, -0.239603f,  0.475483f,
      -0.999101f,  -0.140578f,  1.04787f,    -0.591981f,  -0.306989f,
      -0.879012f,  -0.994715f,  0.0343158f,  0.218509f,   0.34704f,
      0.0672934f,  -0.178941f,  0.20509f,    -0.360031f,  0.161241f,
      -0.324775f,  -0.359531f,  -0.0657085f, -0.864422f,  -0.444865f,
      0.597095f,   -0.948691f,  0.240001f,   -0.783159f,  -0.569422f,
      0.974205f,   -1.04539f,   0.345915f,   -0.681558f,  -0.246047f,
      0.256174f,   0.493667f,   0.681324f,   0.155613f,   0.773309f,
      -0.647027f,  -0.214744f,  -0.474202f,  -0.661092f,  -1.02316f,
      0.0572593f,  -0.437082f,  -0.119874f,  -0.464877f,  -0.58067f,
      -0.218029f,  0.319516f,   -0.378983f,  -0.0698695f, 0.554693f,
      -0.537875f,  0.126429f,   -0.145113f,  -0.594312f,  -0.218021f,
      -0.703569f,  0.0720548f,  0.261054f,   -0.81438f,   0.249921f,
      0.165296f,   -0.079028f,  -0.322647f,  0.134458f,   0.0975046f,
      0.538594f,   -0.250126f,  0.142309f,   0.526486f,   0.0532615f,
      -0.383332f,  -0.38143f,   -0.101611f,  0.519776f,   -0.278364f,
      -0.23287f,   -0.29139f,   0.22353f,    0.472085f,   0.366264f,
      0.741187f,   0.42019f,    0.0676459f,  -0.230008f
    };

static const float av1_intra_mode_cnn_partition_branch_0_dnn_layer_1_bias[] = {
  -0.48603f,  -0.578556f,  0.257639f, 0.459915f, 0.178156f,  -1.16663f,
  0.828891f,  0.620291f,   0.413257f, -1.00508f, -0.574179f, -1.20623f,
  -0.377837f, -0.0360333f, 0.681536f, 0.137189f, -0.458718f, 0.387131f,
  0.0233112f, 0.126045f,   0.361304f, 0.655317f, 0.413134f,  0.769947f
};

static const float av1_intra_mode_cnn_partition_branch_0_logits_kernel[] = {
  0.67244f,   -2.59179f, 0.50425f,  -1.86481f,  1.15891f,   -1.26447f,
  0.761081f,  0.645117f, -1.78594f, -0.872703f, -0.192054f, -1.82359f,
  -0.560935f, 0.838959f, 0.502264f, -1.28958f,  -0.205551f, 0.635671f,
  -1.12619f,  -1.68277f, 0.83361f,  1.57235f,   1.15839f,   0.35345f
};

static const float av1_intra_mode_cnn_partition_branch_0_logits_bias[] = {
  1.14463f
};

static const float
    av1_intra_mode_cnn_partition_branch_1_dnn_layer_0_kernel[] = {
      0.364612f,    0.237868f,    -0.192821f,   0.12364f,      0.522205f,
      -0.205785f,   -0.503288f,   -0.426503f,   -0.083073f,    0.0164429f,
      0.184278f,    -0.426055f,   0.0717997f,   -0.261968f,    0.176412f,
      -0.101226f,   0.0400285f,   -0.332051f,   0.344385f,     0.189565f,
      0.441162f,    0.330462f,    -0.719857f,   -1.14209f,     0.557831f,
      0.104756f,    0.0562001f,   -0.465923f,   -0.344592f,    -0.191554f,
      -0.0656866f,  -0.640162f,   0.419388f,    0.409308f,     -1.68632f,
      -1.10829f,    0.105485f,    -0.14561f,    -0.944738f,    0.104629f,
      -0.146837f,   0.538823f,    -0.153157f,   0.321081f,     -1.77714f,
      -0.0559296f,  0.324136f,    -0.497023f,   -1.15793f,     -0.740144f,
      -0.0888472f,  0.010059f,    -0.18394f,    -0.234405f,    -0.10586f,
      0.130958f,    -0.101944f,   -0.186483f,   -0.447049f,    -0.900026f,
      0.128444f,    0.401696f,    0.128509f,    0.123778f,     0.062168f,
      -0.321755f,   -0.0691584f,  0.254468f,    -0.115212f,    -0.848885f,
      0.817005f,    0.0615853f,   0.153363f,    0.513855f,     0.789225f,
      0.356168f,    0.371613f,    0.269541f,    0.268173f,     0.220481f,
      -0.109063f,   -0.00620798f, -0.0334622f,  0.236267f,     -0.0235294f,
      -0.0800253f,  0.0294184f,   0.047131f,    -0.224047f,    0.0890737f,
      -0.356293f,   0.0989534f,   0.16799f,     0.498266f,     0.612581f,
      -0.372897f,   -0.75125f,    0.77698f,     1.1032f,       -0.0764679f,
      0.0266299f,   0.309532f,    0.461305f,    0.0193521f,    -0.0939161f,
      -0.276156f,   -0.102714f,   -0.0828328f,  0.40003f,      0.122542f,
      0.0867203f,   -0.170738f,   0.0850642f,   -0.130762f,    0.082324f,
      -0.115218f,   -0.0244491f,  0.0434331f,   0.216453f,     0.443733f,
      -0.173679f,   -0.161617f,   0.316209f,    -0.689656f,    -1.52007f,
      -0.421018f,   0.430833f,    -0.00734122f, 0.284499f,     -0.0207885f,
      0.0572024f,   -0.878942f,   0.388264f,    0.0191589f,    -0.123415f,
      -0.0461196f,  -0.0444461f,  -0.00383171f, 0.0945655f,    -0.0597219f,
      -0.374918f,   0.0182124f,   0.523083f,    0.00519547f,   0.80513f,
      -0.221433f,   -1.30591f,    -0.416917f,   -0.718173f,    0.622999f,
      0.941798f,    0.0477536f,   0.0303772f,   0.268078f,     0.414778f,
      0.394325f,    0.299733f,    -0.583208f,   0.309379f,     0.416581f,
      0.0299948f,   -0.409145f,   -0.161557f,   -0.214082f,    -0.0098119f,
      0.221912f,    0.107135f,    0.0692518f,   0.00490957f,   0.107613f,
      -0.368404f,   -0.548006f,   0.208274f,    0.550475f,     0.643678f,
      -1.65859f,    0.095938f,    -0.0434245f,  -0.0792685f,   0.838109f,
      -0.0138653f,  -0.527573f,   -0.123472f,   -0.235618f,    -0.677401f,
      -0.125877f,   -0.175604f,   -0.203196f,   0.113478f,     -0.228323f,
      -0.53539f,    0.134458f,    0.0534899f,   -0.213006f,    -0.138679f,
      -2.15023f,    0.186303f,    0.48566f,     -1.22301f,     -0.240982f,
      -0.486836f,   -0.121181f,   -0.131382f,   -0.0320283f,   0.278828f,
      0.342581f,    -0.182257f,   -0.365193f,   -0.226351f,    0.108928f,
      -0.100159f,   0.448355f,    -0.0768947f,  0.0633719f,    -0.104786f,
      0.0456653f,   0.0965752f,   0.156403f,    -0.157337f,    0.212259f,
      0.317939f,    0.124193f,    -0.329475f,   0.206868f,     -2.15986f,
      -0.108385f,   -0.396769f,   -0.0317231f,  -0.271524f,    -0.184697f,
      0.662615f,    0.412926f,    -0.0217462f,  -0.0285475f,   -0.118826f,
      0.0252706f,   -0.137091f,   0.198973f,    0.329509f,     -0.0831966f,
      -0.621237f,   0.0896179f,   0.805261f,    -0.019675f,    0.962452f,
      0.307433f,    0.892168f,    -0.537587f,   -2.46145f,     0.125606f,
      0.920491f,    0.219462f,    0.292765f,    -0.748238f,    -0.0537239f,
      -0.224326f,   0.505492f,    0.176426f,    0.0343168f,    0.16708f,
      -0.581393f,   0.951726f,    -1.1777f,     -0.561914f,    -1.53288f,
      0.864567f,    -1.19648f,    -1.24141f,    -0.334688f,    -0.622026f,
      0.666876f,    -0.197005f,   -0.600507f,   -0.851924f,    0.492299f,
      0.31078f,     -0.0736115f,  0.030999f,    -6.02463e-05f, -0.0604341f,
      -0.0254238f,  0.139222f,    0.333235f,    0.366534f,     -0.191982f,
      -0.0156092f,  0.44234f,     -0.0193213f,  0.0938745f,    -0.015709f,
      -0.12043f,    0.00895591f,  0.0464401f,   0.0530699f,    -0.623018f,
      -1.23372f,    -0.538647f,   -1.12389f,    0.26742f,      0.548694f,
      0.00540655f,  -0.219703f,   0.314894f,    -0.573463f,    -0.241555f,
      0.441851f,    0.422491f,    0.253785f,    -0.384683f,    0.0370165f,
      0.226669f,    0.245587f,    0.215265f,    -0.122272f,    0.0492235f,
      0.000658591f, -0.312877f,   0.436487f,    -0.229199f,    -0.174373f,
      0.904268f,    -0.855845f,   -0.877293f,   -0.65409f,     0.313795f,
      0.461748f,    -0.737766f,   -0.228523f,   0.182181f,     0.334522f,
      0.0629676f,   -0.151087f,   0.178798f,    -0.325809f,    -0.331672f,
      0.0865837f,   -0.0684225f,  0.0252008f,   -0.0820631f,   0.0481863f,
      0.209473f,    -0.0242151f,  -0.0898919f,  -0.163828f,    -0.164282f,
      0.581888f,    0.816896f,    0.0607674f,   0.364855f,     -0.346512f,
      -0.764174f,   0.595561f,    0.302872f,    0.206361f,     0.106917f,
      -0.972338f,   0.176948f,    0.6415f,      -0.131897f,    -0.155802f,
      0.216337f,    -0.342511f,   0.123743f,    -0.123014f,    0.0205439f,
      0.15173f,     -0.23801f,    -1.00387f,    0.651328f,     0.237439f,
      -0.542952f,   1.066f,       -0.161107f,   -0.593545f,    0.219343f,
      -0.178094f,   0.0789992f,   0.428332f,    0.23827f,      -0.327421f,
      0.416144f,    0.00394653f,  0.052046f,    -0.238289f,    0.405942f,
      0.00141984f,  0.161017f,    0.077111f,    0.0823985f,    0.0981208f,
      0.109949f,    -0.0428502f,  0.343629f,    -0.722978f,    -0.375269f,
      -0.111634f,   -0.271523f,   0.712093f,    0.684904f,     -0.572331f
    };

static const float av1_intra_mode_cnn_partition_branch_1_dnn_layer_0_bias[] = {
  0.583367f,  -0.202004f, -0.207626f, 0.412451f,  -0.258311f, 0.0304954f,
  -0.102458f, 0.450087f,  -0.376851f, -0.338702f, 0.335226f,  0.889072f,
  0.502411f,  0.649282f,  0.15345f,   -0.0109896f
};

static const float
    av1_intra_mode_cnn_partition_branch_1_dnn_layer_1_kernel[] = {
      0.0214882f,    -0.934339f,  -0.173335f,  0.8362f,      -0.764234f,
      0.525163f,     0.409749f,   0.821539f,   -0.784157f,   -0.455593f,
      0.446099f,     0.406756f,   0.479242f,   -0.814038f,   -0.419332f,
      0.328869f,     -0.340707f,  0.133219f,   0.0320347f,   0.25089f,
      -0.324917f,    -0.0684265f, 0.0377777f,  -0.262556f,   0.673458f,
      -0.0291454f,   -0.417957f,  -1.0075f,    -0.481537f,   0.922105f,
      -0.000516239f, -0.40034f,   0.242067f,   -0.43178f,    0.32001f,
      0.143599f,     -0.345172f,  0.126093f,   0.148518f,    -1.12151f,
      -1.03435f,     0.551691f,   -0.310001f,  -0.323194f,   -0.595128f,
      -0.395689f,    0.737268f,   -0.729227f,  0.590804f,    -0.590022f,
      -1.01427f,     -0.521159f,  -0.617579f,  1.07292f,     -0.613047f,
      -0.619093f,    0.335268f,   0.473753f,   -0.795027f,   1.24635f,
      -0.556193f,    0.241046f,   -0.0354181f, -0.354215f,   0.716752f,
      -0.00200745f,  -1.25171f,   -0.440731f,  -0.763918f,   -0.588614f,
      -0.183901f,    -0.396056f,  0.226903f,   0.921471f,    1.10465f,
      0.207053f,     0.57681f,    -0.555699f,  0.235469f,    -0.92149f,
      0.625808f,     0.29653f,    -0.81775f,   -0.307889f,   -1.41384f,
      -0.136205f,    -0.365314f,  -0.516741f,  0.748052f,    0.617947f,
      0.0973239f,    0.839607f,   0.530668f,   -0.227032f,   -0.449044f,
      -1.04725f,     -0.244363f,  -0.396888f,  -0.146161f,   0.359789f,
      0.0436599f,    1.21645f,    -0.336069f,  0.0534646f,   -0.00200328f,
      0.658551f,     -0.156142f,  -1.0728f,    0.0951015f,   0.234837f,
      -0.380525f,    0.041783f,   -0.269273f,  0.0386013f,   -0.455589f,
      -0.174338f,    0.0345251f,  0.17116f,    -0.507642f,   0.210453f,
      0.739987f,     -0.0438776f, 0.570145f,   -0.118811f,   0.0548662f,
      0.153458f,     -0.89887f,   0.493704f,   0.283351f,    0.785441f,
      -0.586002f,    -0.0616167f, -0.714328f,  -0.145941f,   -0.449656f,
      0.850117f,     0.279997f,   0.204143f,   -0.31356f,    0.947057f,
      -0.135787f,    0.747071f,   0.0145968f,  -0.81414f,    0.431009f,
      -0.275824f,    -0.342928f,  -0.0528272f, -0.592183f,   0.433915f,
      -0.251752f,    -0.311815f,  -1.47533f,   -1.43677f,    0.0698436f,
      1.01341f,      0.305063f,   -0.252003f,  -0.428915f,   -0.00104153f,
      -0.368267f,    -0.354523f,  -0.27956f,   -0.771664f,   0.232092f,
      -0.428495f,    0.424952f,   -0.343229f,  0.196899f,    -0.761084f,
      -0.0110293f,   -0.335361f,  0.571637f,   -0.423489f,   -0.52773f,
      0.0108043f,    -0.504715f,  -1.1419f,    -0.402904f,   -0.160747f,
      -0.329184f,    0.375374f,   -1.02604f,   -0.601371f,   0.631652f,
      0.0742486f,    -0.464765f,  0.467445f,   0.240562f,    -0.38211f,
      -0.459004f,    0.704196f,   0.021357f,   0.860785f,    -1.16731f,
      -0.479029f,    -0.139644f,  -0.444087f,  0.322326f,    -0.25455f,
      0.874399f,     0.477696f,   0.0464487f,  1.20658f,     0.0993356f,
      0.00682712f,   -0.10163f,   -0.371765f,  -0.629513f,   -0.679196f,
      -0.193935f,    0.47405f,    -0.18238f,   0.254918f,    -0.35306f,
      -0.375611f,    0.119771f,   -0.257282f,  -0.565124f,   0.162667f,
      -0.356128f,    0.870351f,   0.241847f,   -0.264712f,   -0.384322f,
      0.31807f,      0.211621f,   -0.180767f,  0.764944f,    0.368646f,
      0.186111f,     1.02458f,    -0.494252f,  -0.483375f,   -0.699664f,
      0.00415657f,   -0.189376f,  -0.677103f,  -0.030319f,   0.667087f,
      0.810951f,     -0.488237f,  -0.387355f,  -0.726579f,   -0.304763f,
      1.10392f,      -0.775977f,  -0.247731f,  0.532396f,    1.24089f,
      0.206621f,     -0.670568f,  -1.08142f,   -0.342503f,   0.189854f,
      -0.200846f,    0.784204f,   0.641112f,   -0.509346f,   0.0805264f,
      -1.40006f,     0.322084f,   -0.823739f,  -1.12965f,    -0.215668f,
      0.099673f,     0.425966f,   0.771697f,   0.338834f,    0.345364f,
      -0.297826f,    -0.176746f,  -0.297299f,  -1.80029f,    -0.178348f,
      0.421194f,     -0.19155f,   0.417653f,   0.374441f,    -0.135654f,
      -0.895843f,    0.220647f,   0.368264f,   0.369233f,    0.382707f,
      0.0800511f,    0.542053f,   0.318896f,   -0.385539f,   0.313305f,
      -1.01166f,     -0.222379f,  -1.53708f,   1.32407f,     -0.665444f,
      -0.102348f,    0.0410504f,  -0.616825f,  1.3108f,      0.405902f,
      1.27777f,      0.0630558f,  -0.172696f,  0.16224f,     -1.10111f,
      -3.31326f,     -0.242566f,  0.831422f,   0.917397f,    0.311749f,
      -0.238613f,    0.438007f,   -0.407089f,  -0.0202555f,  -1.82502f,
      -0.907965f,    -0.300031f,  -0.616669f,  -0.767921f,   0.285919f,
      -0.112019f,    0.252677f,   0.350892f,   0.000214244f, 0.315915f,
      0.260344f,     0.327362f,   -0.0211213f, -0.41241f,    0.0418355f,
      0.103328f,     -0.0158439f, -0.230505f,  -0.0215114f,  0.266739f,
      -0.234376f,    -0.352583f,  0.0709437f,  -0.90649f,    -0.535843f,
      1.21322f,      -1.05144f,   -0.983682f,  -0.189956f,   1.14208f,
      -0.0188492f,   -0.254821f,  -0.463214f,  -0.708714f,   0.0447348f,
      -0.220831f,    0.476299f,   0.102544f,   1.1173f,      -0.36981f,
      -0.814102f,    0.103604f,   -0.247871f,  0.0610701f,   -0.356616f,
      -0.144093f,    1.66496f,    0.180206f,   -1.04384f,    -0.65883f,
      0.0290771f,    -0.622728f,  0.761523f,   -0.909091f,   -0.0340348f,
      0.666895f,     -0.0232575f, 0.962643f,   -2.50103f,    -1.69745f,
      -0.0482305f,   0.771811f,   -1.32233f,   -0.778722f,   -0.203309f,
      0.395875f,     -0.171812f,  0.253794f,   0.432799f
    };

static const float av1_intra_mode_cnn_partition_branch_1_dnn_layer_1_bias[] = {
  -0.152159f, 0.552347f,   -0.806068f, 0.227901f,  0.335896f,  0.180785f,
  0.75277f,   0.982208f,   0.409823f,  -0.17755f,  -0.125365f, 0.738114f,
  0.202331f,  0.751737f,   -0.360511f, 0.149254f,  0.085073f,  -0.214542f,
  0.529727f,  -0.0348777f, -2.13162f,  -0.893332f, -0.136952f, -0.71258f
};

static const float av1_intra_mode_cnn_partition_branch_1_logits_kernel[] = {
  -0.632145f, 0.738727f, -0.750737f, -0.931571f, -1.79763f,  -2.31153f,
  0.912733f,  0.879995f, -1.00602f,  -1.02467f,  0.0536835f, 1.76011f,
  -0.898546f, 1.06959f,  1.60471f,   -1.7312f,   -0.877168f, -0.681185f,
  -1.57286f,  -1.16038f, -4.11303f,  -3.06351f,  -3.02536f,  -2.92186f
};

static const float av1_intra_mode_cnn_partition_branch_1_logits_bias[] = {
  1.33207f
};

static const float
    av1_intra_mode_cnn_partition_branch_2_dnn_layer_0_kernel[] = {
      0.0419551f,  0.0924078f,   -0.153084f,   0.191642f,    0.069586f,
      -0.530661f,  0.431968f,    0.000453838f, 0.793047f,    0.0161817f,
      -0.476075f,  -0.156638f,   -0.219066f,   0.372716f,    -0.0642299f,
      0.156813f,   -0.105819f,   -0.0519422f,  0.149935f,    0.295544f,
      0.192037f,   -0.0450383f,  0.828794f,    -0.0510661f,  -1.22549f,
      -0.100293f,  -0.178274f,   0.0304427f,   -0.0664097f,  -0.0438936f,
      0.948248f,   0.425486f,    -0.238206f,   1.3744f,      0.336897f,
      0.0760769f,  -0.583508f,   0.0735519f,   -0.117024f,   0.0501598f,
      0.332212f,   0.199531f,    0.424764f,    0.206712f,    0.342868f,
      0.592673f,   -0.0961148f,  -0.190113f,   -0.155027f,   0.00789871f,
      -0.0514839f, -0.416154f,   -0.290309f,   0.407541f,    0.48534f,
      0.126564f,   0.0709566f,   -0.0469664f,  0.735403f,    -0.365963f,
      0.150295f,   -0.50147f,    0.021383f,    0.76514f,     0.0085721f,
      -0.416384f,  1.22268f,     0.0832438f,   0.367813f,    -0.12012f,
      0.823183f,   -0.0525972f,  -0.325526f,   -0.0983032f,  0.370128f,
      0.368778f,   0.138971f,    -0.0397997f,  0.411058f,    -0.0400404f,
      0.588437f,   -0.29963f,    -0.107992f,   -1.75238f,    -0.274387f,
      0.430418f,   0.495152f,    0.283172f,    -0.441166f,   0.195339f,
      -0.436182f,  -0.252613f,   0.176204f,    -0.126541f,   -0.474833f,
      -0.0721603f, -0.496599f,   -0.0608464f,  0.0333451f,   -0.0621485f,
      0.0843859f,  0.0637854f,   -0.145291f,   0.14876f,     0.181665f,
      -0.675805f,  0.294903f,    0.301118f,    -0.225957f,   0.0105897f,
      -0.136427f,  -0.555925f,   -0.158853f,   -0.216779f,   0.0612481f,
      -0.107158f,  0.352451f,    0.140536f,    -0.0148237f,  0.189371f,
      -0.091046f,  -0.0476226f,  0.366054f,    -0.0723413f,  0.389883f,
      -0.0213411f, 0.0279539f,   0.194827f,    -0.271502f,   -0.166474f,
      0.0690549f,  0.0584665f,   0.0198415f,   -0.442348f,   0.1571f,
      -0.113463f,  -0.16822f,    -0.0580659f,  -0.13441f,    -0.0022386f,
      0.251521f,   -0.160494f,   -0.0753547f,  0.0897289f,   0.137917f,
      0.129836f,   0.0816833f,   -0.626288f,   0.0643293f,   -1.20001f,
      0.085631f,   -0.195602f,   0.251244f,    0.0321744f,   0.0493178f,
      -0.220616f,  0.724075f,    -0.00831514f, 2.00319f,     0.407932f,
      0.0710799f,  -0.166128f,   0.0126611f,   -0.229644f,   -0.0984299f,
      0.632041f,   -0.0946141f,  0.295315f,    0.100934f,    0.184883f,
      -0.236173f,  0.158081f,    0.195775f,    0.413542f,    0.789801f,
      0.767741f,   0.166275f,    -0.348271f,   -0.384074f,   -0.291648f,
      -0.119899f,  0.0368354f,   0.0751987f,   1.04217f,     -0.159002f,
      -2.71592f,   -0.788502f,   -1.06268f,    0.536057f,    0.0575876f,
      1.06811f,    0.12033f,     0.198578f,    -0.0419196f,  0.0631388f,
      0.623138f,   -0.142226f,   1.33129f,     0.0868059f,   -0.0287825f,
      0.139378f,   -0.143037f,   0.307452f,    0.0363987f,   -0.0976368f,
      0.040544f,   0.0269327f,   -0.0845524f,  0.0674699f,   0.104501f,
      -0.0351155f, 0.167071f,    0.00986971f,  0.10284f,     0.0300016f,
      0.192601f,   0.0397177f,   0.0251346f,   -0.00912908f, -0.0452825f,
      0.0164356f,  -0.0275149f,  0.194846f,    0.0943608f,   1.61674f,
      0.0124345f,  0.523787f,    0.0397258f,   -0.17208f,    -0.147808f,
      -1.23583f,   0.676385f,    0.551994f,    0.0233041f,   0.0116391f,
      -0.466706f,  0.154725f,    -0.207371f,   0.606662f,    0.247286f,
      0.31216f,    0.173765f,    -0.268033f,   0.224422f,    0.314649f,
      0.481922f,   -0.190604f,   -0.0129162f,  0.270552f,    0.135195f,
      0.0927735f,  -0.226099f,   0.53897f,     0.103309f,    -0.0257271f,
      -0.0246776f, 0.442013f,    -0.179246f,   -1.02581f,    0.206176f,
      -0.326365f,  0.391623f,    -0.103549f,   0.115645f,    0.0269328f,
      -0.584517f,  -0.237502f,   0.157996f,    0.0447407f,   -0.161f,
      -0.126072f,  -0.148967f,   -0.416347f,   0.0236496f,   -1.12612f,
      0.0120709f,  -0.00979376f, 0.0507126f,   -0.172262f,   0.0697059f,
      -0.212334f,  0.335731f,    -0.0301362f,  -0.839583f,   -0.238539f,
      0.0636752f,  -0.0467217f,  -0.0372118f,  -0.144615f,   -0.161773f,
      -0.648242f,  0.158197f,    -0.051471f,   -0.0615805f,  -0.0426936f,
      -0.0745554f, 0.358975f,    0.358297f,    0.0568553f,   -1.14383f,
      -0.103955f,  0.728194f,    -0.224945f,   -0.31659f,    -0.204458f,
      0.171763f,   -0.465666f,   0.899234f,    -0.37042f,    -0.0894774f,
      0.11478f,    -0.334957f,   0.0896514f,   0.413251f,    0.359471f,
      1.41597f,    0.558082f,    0.153486f,    0.0270558f,   -0.0178797f,
      0.124983f,   -0.12273f,    -1.04516f,    -0.125375f,   0.370336f,
      -0.209423f,  -0.36816f,    -0.66077f,    -0.0180773f,  -0.628921f,
      -0.178542f,  0.0346841f,   0.0319309f,   -0.470138f,   0.172763f,
      0.0798846f,  -0.259737f,   -0.652461f,   -0.386283f,   -0.474447f,
      -0.924054f,  -0.0154613f,  -0.613712f,   -0.138068f,   -0.337842f,
      0.217921f,   -0.0711405f,  0.000404091f, -0.703766f,   0.0364683f,
      0.150173f,   0.0126249f,   0.170594f,    0.0371879f,   -0.0862515f,
      -0.23454f,   -0.0144143f,  0.164947f,    0.45591f,     0.115703f,
      0.069752f,   -0.011993f,   0.0402097f,   0.00697581f,  0.0811613f,
      0.384752f,   0.341977f,    0.06087f,     0.0590107f,   0.00812679f,
      0.121211f,   -0.0612108f,  0.167851f,    0.195781f,    -1.62162f,
      0.336292f,   -0.0772523f,  -0.310786f,   0.188257f,    -0.0325804f,
      -0.240098f,  0.158748f,    -0.265264f,   3.19593f,     -0.449251f,
      -1.33102f,   -0.482856f,   -0.435731f,   0.300808f,    0.346503f,
      2.67378f,    -0.152379f,   0.219322f,    -0.146119f,   -0.0584806f,
      -0.0276895f, -0.21955f,    -0.479179f,   -0.689545f,   0.152799f
    };

static const float av1_intra_mode_cnn_partition_branch_2_dnn_layer_0_bias[] = {
  -0.296575f, 0.101072f,  -0.208429f, 0.111585f, 0.699552f,   -0.379484f,
  0.313244f,  -0.746369f, 0.867757f,  0.457318f, -0.0190943f, -0.290745f,
  0.45592f,   -0.160465f, -0.634243f, 0.0829737f
};

static const float
    av1_intra_mode_cnn_partition_branch_2_dnn_layer_1_kernel[] = {
      0.27511f,    -2.14172f,   1.25755f,    -0.554772f,  0.589508f,
      0.228307f,   0.0754914f,  1.07061f,    0.293323f,   0.65162f,
      -0.272016f,  -1.33519f,   -0.606759f,  -0.57827f,   0.368807f,
      -1.48668f,   0.162439f,   0.0821667f,  0.225535f,   -0.795996f,
      0.0328293f,  0.975476f,   -0.187514f,  2.47069f,    -1.5638f,
      -0.461524f,  0.00310062f, 1.1556f,     -0.286206f,  0.00426021f,
      0.585836f,   0.900007f,   0.384055f,   0.189435f,   -0.157291f,
      -0.0710573f, -0.0663986f, -0.710772f,  -0.669136f,  -0.379493f,
      -1.2634f,    -0.377524f,  0.824094f,   0.312308f,   0.125368f,
      -0.382737f,  0.637109f,   0.61907f,    -0.741184f,  0.00257198f,
      -0.0151343f, -0.669826f,  -0.439855f,  0.564852f,   -0.0588036f,
      -1.38123f,   -1.1126f,    0.701831f,   0.198686f,   0.266866f,
      0.270172f,   -0.692401f,  0.272533f,   -1.70914f,   0.66064f,
      0.0886659f,  -0.132233f,  0.270531f,   -0.479581f,  0.704338f,
      -0.307039f,  -0.111792f,  -2.05753f,   -0.231749f,  0.300528f,
      0.383266f,   -0.130857f,  -0.373944f,  1.21025f,    0.704655f,
      -0.589422f,  0.267185f,   -0.109065f,  -0.195991f,  0.20209f,
      -0.0676526f, -0.183926f,  0.164894f,   0.0877923f,  0.565943f,
      -0.0610466f, -0.86354f,   -0.80853f,   -0.176111f,  -1.45016f,
      -2.29078f,   -0.124524f,  -0.139305f,  -0.187858f,  -0.0250151f,
      -0.572544f,  0.185336f,   -0.69275f,   -0.430354f,  -0.30861f,
      -0.754258f,  -0.468221f,  -0.160487f,  -0.766692f,  -0.636418f,
      -0.71016f,   0.576125f,   -0.240476f,  -0.954556f,  -0.104693f,
      0.155557f,   -0.840224f,  -0.685457f,  -0.0346927f, -0.644882f,
      -1.92475f,   -0.314544f,  0.463569f,   0.323569f,   -0.990124f,
      -0.213658f,  0.407183f,   1.19797f,    -4.77004f,   -0.0613379f,
      -2.40345f,   -0.0591791f, -0.477622f,  -0.303556f,  0.104077f,
      -0.974128f,  -0.035172f,  1.47064f,    0.233727f,   -0.0754056f,
      0.158553f,   0.0614361f,  -1.38865f,   0.690729f,   0.568455f,
      0.205866f,   -0.0236852f, -0.0921077f, -0.538954f,  0.336613f,
      -0.427115f,  0.791754f,   -1.819f,     -0.404432f,  0.670242f,
      -0.0343869f, -0.37191f,   0.0271262f,  0.988161f,   -0.547343f,
      0.925304f,   0.548079f,   -0.430343f,  -0.214109f,  0.242013f,
      1.39027f,    0.37648f,    -1.63524f,   -0.158864f,  -0.572779f,
      -0.766801f,  -2.62032f,   0.47799f,    -1.12025f,   -0.115283f,
      1.22349f,    -0.262132f,  -0.151274f,  0.390483f,   -0.496482f,
      1.06166f,    -0.183052f,  0.54647f,    0.847486f,   0.0229506f,
      0.653309f,   -0.020736f,  -1.27453f,   0.48386f,    -0.366625f,
      -0.515725f,  -1.31196f,   0.140701f,   -0.183636f,  0.000413912f,
      0.300993f,   -0.849529f,  -0.59764f,   -0.212992f,  -0.933365f,
      -1.4054f,    -0.091982f,  0.41695f,    0.264004f,   -0.26379f,
      -0.0738219f, 0.434052f,   1.16617f,    -0.639624f,  -0.146465f,
      0.0409936f,  -0.900182f,  0.73517f,    0.805746f,   -0.208088f,
      1.74459f,    -0.0592751f, 0.624865f,   -0.62325f,   -0.446315f,
      0.150526f,   0.0526697f,  0.374254f,   -0.658043f,  1.02623f,
      -0.941758f,  0.381217f,   -0.359448f,  0.160051f,   0.556455f,
      0.239382f,   0.75851f,    0.437583f,   -0.122221f,  0.746136f,
      0.218286f,   -0.426729f,  0.0353903f,  -0.830513f,  -0.877586f,
      0.488077f,   -0.132354f,  -0.180756f,  0.736163f,   -0.202934f,
      -0.882534f,  0.166305f,   0.183122f,   0.0599858f,  0.442687f,
      0.0522908f,  -1.17755f,   -1.03733f,   0.392363f,   0.672718f,
      -1.44704f,   0.360623f,   0.390298f,   -0.213968f,  0.169783f,
      -0.717536f,  -0.830984f,  -0.445049f,  0.196772f,   -0.730634f,
      -1.09497f,   0.344012f,   -0.292802f,  -0.67966f,   0.138515f,
      -0.361803f,  0.936778f,   -0.189802f,  0.197777f,   -0.367507f,
      -0.293653f,  0.447759f,   -0.409245f,  -0.687568f,  -0.431301f,
      -0.271234f,  -0.585413f,  -0.936414f,  -0.396049f,  -0.29388f,
      -0.0930843f, 0.0179339f,  0.262463f,   -0.166598f,  0.0171466f,
      -0.329641f,  0.39343f,    0.657445f,   -0.579052f,  -0.312444f,
      -0.0915881f, -0.432622f,  -0.247645f,  0.485749f,   -0.602508f,
      -0.347936f,  0.287353f,   0.288705f,   0.168397f,   0.568228f,
      -0.493586f,  1.04155f,    -0.097956f,  0.658928f,   -0.561007f,
      0.0457783f,  2.12744f,    0.182683f,   -0.690282f,  0.183302f,
      0.0309499f,  -0.722251f,  0.0660448f,  -0.333277f,  0.198929f,
      -0.724102f,  -0.405597f,  0.614868f,   -0.292862f,  0.886513f,
      0.142353f,   -1.48934f,   -0.97273f,   0.199683f,   0.522121f,
      0.0877478f,  -0.172593f,  -1.58858f,   0.113191f,   -0.436178f,
      0.640895f,   -0.504676f,  0.0658654f,  -0.361301f,  0.604323f,
      0.315196f,   -0.423021f,  -0.323484f,  -0.563163f,  0.118989f,
      -0.404508f,  -0.0550995f, -0.0359236f, -0.126574f,  -0.357288f,
      -0.0494502f, 1.04959f,    -0.31646f,   -0.0376684f, -0.300744f,
      -0.135016f,  0.102696f,   -0.392333f,  -1.17502f,   0.505227f,
      0.337608f,   -0.348831f,  -0.420815f,  0.202791f,   -0.154264f,
      -0.563686f,  0.0942187f,  0.353862f,   0.0303509f,  -0.132794f,
      0.420746f,   0.143529f,   0.455822f,   -1.28348f,   -1.35662f,
      -0.850688f,  -1.76361f,   -0.717546f,  0.443111f,   0.227155f,
      -0.863307f,  -0.452033f,  -0.278151f,  1.86233f
    };

static const float av1_intra_mode_cnn_partition_branch_2_dnn_layer_1_bias[] = {
  -0.103218f, -0.359587f, 0.619666f,  -0.473497f,  -0.649803f, 0.86992f,
  -0.115561f, 0.335114f,  -0.285044f, -0.59295f,   0.24497f,   0.611583f,
  0.38568f,   0.137913f,  -0.281191f, -0.0107777f, 0.487236f,  -0.262363f,
  0.696962f,  0.121565f,  0.312511f,  0.430916f,   0.694134f,  0.393632f
};

static const float av1_intra_mode_cnn_partition_branch_2_logits_kernel[] = {
  -2.42496f,  -1.239f,   0.832673f, 1.56923f,   -2.6175f,  -1.42492f,
  -0.311387f, -1.94237f, 0.54071f,  -2.50391f,  0.352205f, -0.96572f,
  1.47144f,   -2.04702f, -1.12372f, -0.709186f, 0.812238f, 0.310389f,
  0.789163f,  -0.65236f, 1.77018f,  0.273867f,  1.19506f,  1.07022f
};

static const float av1_intra_mode_cnn_partition_branch_2_logits_bias[] = {
  0.953424f
};

static const float
    av1_intra_mode_cnn_partition_branch_3_dnn_layer_0_kernel[] = {
      0.0485154f,    0.0496279f,    0.0268229f,    -0.0584843f,   -0.166928f,
      0.0316731f,    -0.0895094f,   -0.0433243f,   -0.00893639f,  -0.0886265f,
      -0.0345622f,   -0.235395f,    -0.213754f,    -0.00212398f,  0.0218857f,
      -0.0054983f,   -0.0248236f,   0.081822f,     -0.0355708f,   -0.0795593f,
      -0.106995f,    -0.0596378f,   0.0350686f,    -0.133863f,    -0.00582928f,
      0.114963f,     0.193906f,     -0.00419085f,  0.0430529f,    -0.128318f,
      0.0614715f,    -0.000952935f, -0.0345722f,   -0.109459f,    0.074204f,
      -0.0865131f,   0.0649158f,    -0.0942417f,   -0.10122f,     -0.047551f,
      -1.27825f,     -0.0125456f,   -0.019722f,    -0.152058f,    0.280306f,
      -0.121231f,    -0.0565484f,   0.0959188f,    0.0603919f,    0.0457468f,
      0.967589f,     0.105892f,     -0.118326f,    0.198933f,     0.163437f,
      -0.056824f,    -0.0302956f,   -0.07366f,     -0.681407f,    -0.0781575f,
      0.255732f,     -0.0712105f,   0.177882f,     0.709206f,     -0.232457f,
      1.33809f,      -0.0328557f,   0.0572231f,    -1.01361f,     0.130676f,
      -0.205159f,    0.975398f,     0.356293f,     0.0766364f,    -0.297397f,
      -0.0261066f,   -0.0933549f,   0.0568851f,    -0.0123034f,   -0.0433538f,
      0.131003f,     0.890705f,     0.0084565f,    0.00547395f,   0.00157634f,
      0.0047937f,    -0.0511092f,   0.0300034f,    -0.00604993f,  -0.0133502f,
      -0.000274302f, 0.129728f,     -0.00532916f,  0.0855351f,    0.136885f,
      0.0175562f,    -0.0123633f,   -0.000512229f, -0.019924f,    -0.0316328f,
      0.422972f,     0.0460336f,    0.0170841f,    -0.00086795f,  -0.0655137f,
      0.0287308f,    -0.0375644f,   -0.0329215f,   -0.0273072f,   0.0241426f,
      -0.0429052f,   0.0221593f,    -0.063881f,    -0.0347391f,   -6.44339e-07f,
      0.0476934f,    -0.0150068f,   0.0146403f,    -0.0653099f,   0.0107635f,
      0.012407f,     0.0048935f,    1.50975f,      0.322256f,     0.17881f,
      0.0943775f,    -0.100583f,    -0.367022f,    -0.156525f,    -0.0397161f,
      0.0752784f,    -0.00219022f,  -0.887456f,    0.0153415f,    -0.0148185f,
      -0.56435f,     0.163996f,     -0.0221024f,   -0.0115872f,   -0.0529284f,
      0.156838f,     -1.13813f,     -0.207863f,    -0.00484959f,  0.135719f,
      0.131004f,     0.0417939f,    0.31453f,      0.121719f,     -0.101515f,
      0.267951f,     0.219727f,     0.0398821f,    0.0713504f,    3.65918e-06f,
      -0.00659998f,  0.477343f,     -0.128426f,    0.0648877f,    0.111884f,
      0.224552f,     0.0617426f,    0.117742f,     0.031377f,     0.0586865f,
      -0.459293f,    0.100211f,     -0.14127f,     0.624412f,     0.014659f,
      -1.41807f,     -0.382452f,    -0.695931f,    -0.103153f,    0.145808f,
      0.333526f,     -0.256367f,    0.096842f,     0.102458f,     -0.181224f,
      0.729272f,     0.151177f,     1.46729f,      0.111044f,     -4.28813f,
      0.0178379f,    0.47641f,      -6.57533f,     0.0633335f,    0.496934f,
      -0.154657f,    -9.07298e-05f, 0.848937f,     -5.40143f,     0.375685f,
      0.23586f,      -0.166591f,    -0.0191648f,   -0.039862f,    -3.25093f,
      0.168472f,     -0.260317f,    -5.51548f,     0.0575334f,    0.328979f,
      0.112644f,     0.231339f,     -0.122641f,    0.0567331f,    1.19541f,
      -0.038735f,    0.0630576f,    0.176668f,     0.0757184f,    -0.833104f,
      0.133669f,     0.982669f,     0.0311783f,    0.0908558f,    -0.10065f,
      -0.0386599f,   -0.231587f,    -0.83876f,     -0.347148f,    0.225529f,
      -1.29625f,     0.0806834f,    0.369648f,     -1.63367f,     0.118057f,
      -0.311948f,    0.95022f,      -0.354807f,    -0.648657f,    -1.72048f,
      0.260397f,     0.915555f,     0.057737f,     -0.162019f,    -0.453543f,
      -1.70388f,     -0.311632f,    -0.731593f,    -0.678089f,    0.10438f,
      -0.293911f,    0.144864f,     0.039212f,     0.0289241f,    -0.0685266f,
      0.634592f,     -0.0798614f,   -0.119197f,    -0.00517433f,  -0.04653f,
      -0.127568f,    -0.0582645f,   0.0735302f,    -0.0946823f,   0.00865585f,
      0.0115748f,    0.0194847f,    0.0455664f,    0.181006f,     -0.0824601f,
      0.0869093f,    0.264767f,     -0.0750432f,   0.135136f,     0.316511f,
      0.399015f,     0.0994808f,    -0.166944f,    -0.102126f,    0.457858f,
      0.300488f,     0.467582f,     0.830244f,     -0.0511439f,   -0.522892f,
      -0.183049f,    0.2626f,       0.118382f,     0.241674f,     0.250399f,
      -0.0963507f,   -0.83231f,     -0.227699f,    -0.133314f,    0.231718f,
      -0.0700274f,   0.891311f,     0.224742f,     -0.572836f,    0.402798f,
      -0.191576f,    0.740922f,     -0.00374073f,  0.658178f,     -0.209364f,
      -0.416259f,    0.166297f,     0.0095577f,    -0.0876076f,   0.424954f,
      0.265226f,     -0.129343f,    -0.203146f,    -0.194637f,    -0.818142f,
      -0.164152f,    -0.368962f,    0.273373f,     0.599927f,     -0.19859f,
      0.0939651f,    -0.12458f,     -0.751816f,    -0.302997f,    -0.139176f,
      -0.372737f,    0.332704f,     -0.206045f,    -0.00593763f,  -0.452363f,
      -0.2704f,      -0.198846f,    0.0976308f,    -0.216124f,    0.110122f,
      -0.220342f,    0.00763426f,   -0.0272775f,   -0.190395f,    -0.0359411f,
      -0.0395759f,   0.000941162f,  -1.49959f,     0.0914233f,    0.448346f,
      -0.420435f,    -0.0102102f,   -0.0757978f,   -0.0177687f,   -0.0231492f,
      -0.142125f,    1.31774f,      0.0269368f,    0.134566f,     0.152079f,
      -0.139933f,    0.139226f,     -0.214467f,    -0.194446f,    -0.555893f,
      0.271197f,     -0.111047f,    0.0888069f,    -0.198121f,    0.0871713f,
      0.100612f,     0.429782f,     -0.3787f,      0.123147f,     -0.12538f,
      0.235678f,     0.139237f,     0.223326f,     0.85806f,      -0.00554756f,
      0.285095f,     0.0954683f,    0.0464989f,    0.100806f,     -0.0211297f,
      0.121672f,     0.242473f,     0.0810475f,    -0.834356f,    0.119629f,
      0.111338f,     -0.227126f,    0.159296f,     -0.0584685f,   -0.108265f,
      -0.0909221f,   -0.21749f,     0.0929309f,    -0.176815f,    0.178067f,
      -0.0025905f,   0.317883f,     0.313045f,     0.26774f,      -0.589329f,
      -1.19882f,     -0.285513f,    -0.109478f,    0.309441f,     -0.0604479f,
      0.947461f,     -0.142342f,    -0.9086f,      -0.814788f,    0.184588f,
      -0.0736317f,   0.276237f,     0.13132f,      -0.3931f,      -0.381744f,
      -0.0122719f,   0.0246101f,    -0.0920412f,   0.11331f,      -0.110355f,
      0.00848064f,   0.0931248f,    -0.0638655f,   -4.30869e-05f, -0.300367f,
      0.0489508f,    0.464441f,     -0.0466243f,   -0.0137732f,   0.0099241f,
      -0.223972f,    0.188966f,     -0.653173f,    -0.354322f,    0.189237f,
      -0.624276f,    -1.46218f,     -0.075161f,    -0.516172f,    0.40993f,
      0.291178f,     -1.95088f,     -0.0352157f,   0.196354f,     -0.335897f,
      0.0857039f,    0.605319f,     -1.12923f,     -0.638387f,    1.41868f,
      0.0955757f,    -0.00913477f,  0.315935f,     -0.671223f,    -0.851436f,
      -0.157464f,    -0.296763f,    0.182277f,     -0.139309f,    0.232789f,
      0.869562f,     0.248894f,     0.242709f,     0.195479f,     0.106153f,
      0.358881f,     0.167443f,     0.982987f,     0.104767f,     -0.033925f,
      -0.0263185f,   0.0045304f,    0.0722479f,    -0.111307f,    0.00128896f,
      0.406128f,     -0.00944947f,  0.121592f,     0.546284f,     -0.00175696f,
      0.776588f,     0.238846f,     0.064469f,     0.27082f,      0.269187f,
      0.0294455f,    0.62364f,      -0.27872f,     -0.0488013f,   0.229024f,
      0.154457f,     0.0445898f,    0.349943f,     0.0710998f,    0.0820674f,
      0.0279449f,    0.172826f,     -0.122156f,    -0.164688f,    0.0292124f,
      0.0496112f,    -0.741762f,    0.0673926f,    0.108159f,     -0.0942327f,
      -0.0562883f,   0.558231f,     0.0552399f,    0.211393f,     0.0376817f,
      -0.275788f,    0.0548436f,    0.212732f,     0.163603f,     0.0663363f,
      -0.0252315f,   0.164533f,     0.0826088f,    0.0301389f,    0.345705f,
      -0.0378046f,   -0.139581f,    1.30162f,      1.23551f,      -0.446693f,
      0.682534f,     -0.0831157f,   -0.0121595f,   1.50505f,      0.0839017f,
      -0.953413f,    0.0820985f,    -0.125556f,    0.699796f,     -0.140453f,
      0.168438f,     -0.110966f,    0.173806f,     0.114683f,     0.132502f,
      -0.0453539f,   -0.133096f,    0.511947f,     -0.180657f,    -0.0298605f,
      0.291437f,     -0.0275017f,   -0.229703f,    -0.0504205f,   0.559622f,
      0.384601f,     0.111024f,     -0.0773559f,   -0.0591752f,   -0.0866182f,
      -0.189437f,    -0.262345f,    -0.0372182f,   0.149925f,     0.154644f,
      -0.188298f,    0.236949f,     -0.199328f,    -0.378909f,    -0.680128f,
      0.277184f,     -0.172784f,    0.184717f,     -0.23899f,     0.0712069f,
      0.0235425f,    0.4225f,       -0.441487f,    0.177434f,     -0.298303f,
      0.295696f,     0.17346f,      0.220542f,     -0.680116f,    0.00266223f,
      -0.0408459f,   -0.15486f,     0.24335f,      0.237258f,     -0.0283245f,
      0.19703f,      -0.100027f,    0.0554843f,    -1.03081f,     0.151745f,
      0.538582f,     0.370368f,     0.196683f,     0.0222123f,    -0.0831401f,
      -0.0832803f,   -0.286743f,    -0.686003f,    0.0995004f,    0.148901f,
      -0.0436037f,   -0.316508f,    0.00391835f,   -0.228452f,    0.940058f,
      0.520047f,     -0.334211f,    0.652142f,     -0.0755971f,   0.0965123f,
      -0.98191f,     0.394096f,     -0.420466f,    0.327284f,     -0.134651f,
      0.849297f,     -0.523372f,    0.010327f,     0.133636f,     0.298119f,
      -0.257389f,    0.0376153f,    -0.198298f,    0.0736235f,    0.608809f,
      0.0291836f,    -0.290005f,    -0.141316f,    0.0184599f,    0.0554437f,
      0.0621519f,    0.485276f,     0.617062f,     -0.0924811f,   -0.0120834f,
      0.0817611f,    0.100421f,     -0.0153553f,   -0.135958f,    -0.0185322f,
      -0.395803f,    -0.204862f,    0.547916f,     -0.438117f,    0.0229788f,
      0.406981f,     0.795584f,     -2.02756f,     -0.8355f,      -0.386789f,
      0.00968368f,   1.2147f,       -0.740869f,    -1.18415f,     -0.954918f,
      -0.541142f,    0.0596003f,    0.107189f,     -0.411708f,    -0.964593f,
      0.511906f
    };

static const float av1_intra_mode_cnn_partition_branch_3_dnn_layer_0_bias[] = {
  -0.485545f, 0.131552f,   0.796833f,   -0.157582f, -0.0948124f, 0.00818613f,
  -0.485562f, 0.3826f,     -0.0839326f, 0.170998f,  0.279545f,   -0.287143f,
  0.184986f,  -0.0719864f, 0.19748f,    0.404145f
};

static const float
    av1_intra_mode_cnn_partition_branch_3_dnn_layer_1_kernel[] = {
      1.30172f,     0.720189f,   0.261675f,   -0.466201f,   1.21773f,
      0.495525f,    0.62398f,    0.44567f,    -0.330993f,   -0.269798f,
      0.835161f,    -0.294874f,  0.186981f,   0.0162467f,   0.367654f,
      0.658468f,    1.08325f,    1.01558f,    0.12783f,     -0.280581f,
      2.2204f,      0.0337286f,  -0.403649f,  -0.230908f,   -0.35188f,
      0.437712f,    -0.103634f,  -0.645929f,  1.17407f,     0.157385f,
      0.212438f,    1.41874f,    0.284242f,   -0.493105f,   1.0703f,
      0.00632116f,  1.18222f,    -0.26003f,   0.276795f,    -0.823156f,
      0.29577f,     -0.157467f,  -0.18092f,   0.0237336f,   0.205715f,
      -0.295679f,   0.165443f,   -0.628279f,  1.00804f,     0.361232f,
      0.646155f,    -0.028651f,  1.64317f,    0.334251f,    -1.50713f,
      -1.51685f,    -0.488522f,  0.169694f,   -0.593176f,   -0.372682f,
      -1.50223f,    0.35076f,    -0.24641f,   -0.237189f,   0.190502f,
      -0.948191f,   -0.303346f,  0.45108f,    -0.794368f,   -2.3116f,
      0.404008f,    -2.67269f,   -0.941992f,  -0.45336f,    0.0655987f,
      -0.288432f,   0.106068f,   0.286978f,   0.121403f,    0.462739f,
      0.0130292f,   0.240597f,   -2.30983f,   -0.453309f,   -0.149335f,
      0.856424f,    -0.186576f,  0.769961f,   -0.0657097f,  -0.976188f,
      0.972971f,    -0.532728f,  -0.699334f,  -0.168803f,   0.361945f,
      0.950769f,    1.5368f,     -0.223899f,  1.17547f,     -0.281483f,
      0.533619f,    0.315344f,   0.0854543f,  0.464701f,    0.346828f,
      0.271794f,    -0.0185388f, 0.109517f,   0.371662f,    -0.10852f,
      0.244092f,    0.491959f,   -0.750281f,  1.41865f,     -3.51221f,
      0.298194f,    -0.0790832f, -0.134158f,  -0.424084f,   0.189593f,
      -0.238361f,   -0.407872f,  -0.366222f,  -0.606813f,   -0.230498f,
      0.387248f,    -0.102734f,  -0.190544f,  -1.43649f,    0.141338f,
      -0.0438917f,  0.204628f,   1.57033f,    0.0366937f,   -0.14733f,
      0.048198f,    -0.122631f,  0.183354f,   0.0658753f,   -0.243381f,
      0.0246889f,   -0.768798f,  -0.0644054f, 0.775073f,    1.63419f,
      0.491624f,    0.21898f,    -0.358944f,  3.31304f,     0.0195916f,
      0.236174f,    0.530704f,   0.140124f,   0.0736778f,   -0.27361f,
      -0.598836f,   -1.01659f,   0.361765f,   0.00455986f,  -0.345222f,
      1.68731f,     0.764082f,   0.193555f,   0.322782f,    1.19801f,
      0.538935f,    -0.0393231f, -0.0248292f, -0.151168f,   0.479879f,
      -0.208582f,   0.22798f,    0.335473f,   -0.00295455f, 0.139539f,
      0.400814f,    0.478307f,   -0.189376f,  0.540084f,    0.466072f,
      0.920231f,    0.398774f,   -0.472403f,  -0.0431972f,  -0.581665f,
      -0.990058f,   0.258995f,   -0.0148889f, 0.27105f,     0.340334f,
      0.223576f,    -0.0405193f, -1.23888f,   -1.45229f,    -1.44543f,
      -0.376146f,   0.132601f,   -0.4064f,    -0.583611f,   -0.374588f,
      0.0659428f,   0.325652f,   -0.338456f,  0.253767f,    -0.0181164f,
      0.681732f,    0.222041f,   0.837496f,   1.09735f,     0.156328f,
      0.177236f,    -0.702702f,  0.473689f,   0.322118f,    0.43343f,
      0.315441f,    -0.40798f,   0.0811291f,  0.631431f,    0.361929f,
      0.0723276f,   0.0164498f,  0.0293847f,  0.156406f,    -1.10453f,
      0.837977f,    -1.03449f,   -0.348408f,  1.71953f,     -0.401765f,
      0.64272f,     -0.182438f,  -0.233954f,  0.364597f,    0.269177f,
      -0.578512f,   0.397216f,   0.0425122f,  -0.258728f,   1.41621f,
      -0.688768f,   0.0944726f,  0.253163f,   -0.989037f,   1.72726f,
      1.15976f,     -0.0460612f, 0.534186f,   -0.136814f,   0.49327f,
      0.115744f,    -0.633052f,  -0.433855f,  -1.01874f,    -0.324035f,
      0.489487f,    1.08696f,    0.836376f,   -0.423477f,   -0.421309f,
      1.07348f,     0.323266f,   0.717604f,   0.366422f,    0.32983f,
      0.336583f,    0.749292f,   -0.210666f,  0.387101f,    -0.583376f,
      0.0391101f,   -1.07537f,   0.914591f,   -0.51303f,    1.15023f,
      -0.0378782f,  0.262889f,   -0.841128f,  0.41619f,     -0.669704f,
      -0.109995f,   1.01825f,    -0.194853f,  0.120739f,    0.627889f,
      -0.00269221f, 0.751152f,   -0.529865f,  -1.50238f,    0.184521f,
      0.795464f,    0.106099f,   1.83117f,    0.0883305f,   0.306844f,
      -0.0671504f,  -0.169306f,  -0.214575f,  -0.121606f,   -0.234965f,
      0.109752f,    -0.35831f,   -0.07894f,   0.497203f,    -2.63013f,
      0.815608f,    -0.193593f,  -0.62292f,   0.338941f,    0.0970922f,
      -0.531178f,   0.723346f,   0.35063f,    0.182647f,    -0.257013f,
      0.784924f,    -0.217915f,  -0.0797363f, -0.399706f,   -0.485602f,
      1.23155f,     0.345998f,   0.322949f,   -0.168196f,   -0.173313f,
      0.282205f,    0.45117f,    0.918706f,   -0.046172f,   -0.0873883f,
      0.56103f,     -0.485768f,  0.546199f,   0.254997f,    0.394296f,
      0.607178f,    0.667532f,   -0.343883f,  0.374402f,    -0.531439f,
      2.27782f,     -1.13255f,   0.505867f,   -0.514742f,   0.998571f,
      -1.60984f,    -0.172873f,  -0.0604094f, 0.719791f,    -0.733982f,
      0.348905f,    1.39008f,    -0.895343f,  -0.677064f,   -1.84221f,
      0.0434018f,   -0.534794f,  0.0434753f,  -0.266576f,   0.268099f,
      -0.242935f,   0.00166289f, 0.0263789f,  -0.224794f,   -0.113493f,
      -0.236397f,   0.0879936f,  0.510895f,   -0.511789f,   -1.48962f,
      -2.78268f,    -0.0495784f, -0.0343907f, 0.440459f,    -0.364209f,
      0.833223f,    -0.0589337f, 0.00181418f, 0.455499f,    0.101762f,
      -1.16424f,    0.270405f,   0.219033f,   -4.91105f
    };

static const float av1_intra_mode_cnn_partition_branch_3_dnn_layer_1_bias[] = {
  -0.40114f,  -0.372342f, -0.216186f, -0.240014f,  -0.341773f, -0.344489f,
  -0.113037f, 0.198479f,  0.482958f,  -0.630072f,  -0.728704f, -0.171963f,
  0.519883f,  0.253003f,  -0.121618f, -0.0569875f, -0.485568f, -0.147577f,
  0.533305f,  -0.587251f, -0.120837f, -0.483953f,  0.445641f,  -0.125136f
};

static const float av1_intra_mode_cnn_partition_branch_3_logits_kernel[] = {
  -1.57431f,  -1.09069f,  1.67996f,   -0.669702f, 0.499807f, -3.03145f,
  -0.878135f, 0.637818f,  -1.58419f,  -3.79756f,  0.62755f,  -0.446646f,
  0.653269f,  -0.667854f, -2.19774f,  -3.53349f,  2.6107f,   -0.685892f,
  -1.2603f,   -0.89707f,  -0.715551f, 0.382202f,  2.09574f,  0.469386f
};

static const float av1_intra_mode_cnn_partition_branch_3_logits_bias[] = {
  -0.022787f
};

static const NN_CONFIG av1_intra_mode_cnn_partition_branch_0_dnn_config = {
  BRANCH_0_NUM_DNN_FEATURES,
  BRANCH_0_NUM_LOGITS,
  BRANCH_0_NUM_DNN_LAYERS,
  {
      BRANCH_0_NUM_DNN_LAYER_0_UNITS,
      BRANCH_0_NUM_DNN_LAYER_1_UNITS,
  },
  {
      av1_intra_mode_cnn_partition_branch_0_dnn_layer_0_kernel,
      av1_intra_mode_cnn_partition_branch_0_dnn_layer_1_kernel,
      av1_intra_mode_cnn_partition_branch_0_logits_kernel,
  },
  {
      av1_intra_mode_cnn_partition_branch_0_dnn_layer_0_bias,
      av1_intra_mode_cnn_partition_branch_0_dnn_layer_1_bias,
      av1_intra_mode_cnn_partition_branch_0_logits_bias,
  },
};
static const NN_CONFIG av1_intra_mode_cnn_partition_branch_1_dnn_config = {
  BRANCH_1_NUM_DNN_FEATURES,
  BRANCH_1_NUM_LOGITS,
  BRANCH_1_NUM_DNN_LAYERS,
  {
      BRANCH_1_NUM_DNN_LAYER_0_UNITS,
      BRANCH_1_NUM_DNN_LAYER_1_UNITS,
  },
  {
      av1_intra_mode_cnn_partition_branch_1_dnn_layer_0_kernel,
      av1_intra_mode_cnn_partition_branch_1_dnn_layer_1_kernel,
      av1_intra_mode_cnn_partition_branch_1_logits_kernel,
  },
  {
      av1_intra_mode_cnn_partition_branch_1_dnn_layer_0_bias,
      av1_intra_mode_cnn_partition_branch_1_dnn_layer_1_bias,
      av1_intra_mode_cnn_partition_branch_1_logits_bias,
  },
};
static const NN_CONFIG av1_intra_mode_cnn_partition_branch_2_dnn_config = {
  BRANCH_2_NUM_DNN_FEATURES,
  BRANCH_2_NUM_LOGITS,
  BRANCH_2_NUM_DNN_LAYERS,
  {
      BRANCH_2_NUM_DNN_LAYER_0_UNITS,
      BRANCH_2_NUM_DNN_LAYER_1_UNITS,
  },
  {
      av1_intra_mode_cnn_partition_branch_2_dnn_layer_0_kernel,
      av1_intra_mode_cnn_partition_branch_2_dnn_layer_1_kernel,
      av1_intra_mode_cnn_partition_branch_2_logits_kernel,
  },
  {
      av1_intra_mode_cnn_partition_branch_2_dnn_layer_0_bias,
      av1_intra_mode_cnn_partition_branch_2_dnn_layer_1_bias,
      av1_intra_mode_cnn_partition_branch_2_logits_bias,
  },
};
static const NN_CONFIG av1_intra_mode_cnn_partition_branch_3_dnn_config = {
  BRANCH_3_NUM_DNN_FEATURES,
  BRANCH_3_NUM_LOGITS,
  BRANCH_3_NUM_DNN_LAYERS,
  {
      BRANCH_3_NUM_DNN_LAYER_0_UNITS,
      BRANCH_3_NUM_DNN_LAYER_1_UNITS,
  },
  {
      av1_intra_mode_cnn_partition_branch_3_dnn_layer_0_kernel,
      av1_intra_mode_cnn_partition_branch_3_dnn_layer_1_kernel,
      av1_intra_mode_cnn_partition_branch_3_logits_kernel,
  },
  {
      av1_intra_mode_cnn_partition_branch_3_dnn_layer_0_bias,
      av1_intra_mode_cnn_partition_branch_3_dnn_layer_1_bias,
      av1_intra_mode_cnn_partition_branch_3_logits_bias,
  },
};

#undef NUM_DNN_BRANCHES
#undef NUM_CNN_LAYERS
#undef BRANCH_0_NUM_DNN_LAYERS
#undef BRANCH_1_NUM_DNN_LAYERS
#undef BRANCH_2_NUM_DNN_LAYERS
#undef BRANCH_3_NUM_DNN_LAYERS
#undef CNN_LAYER_0_HEIGHT
#undef CNN_LAYER_0_WIDTH
#undef CNN_LAYER_0_IN_CH
#undef CNN_LAYER_0_OUT_CH
#undef CNN_LAYER_0_HORZ_STRIDE
#undef CNN_LAYER_0_VERT_STRIDE
#undef CNN_LAYER_1_HEIGHT
#undef CNN_LAYER_1_WIDTH
#undef CNN_LAYER_1_IN_CH
#undef CNN_LAYER_1_OUT_CH
#undef CNN_LAYER_1_HORZ_STRIDE
#undef CNN_LAYER_1_VERT_STRIDE
#undef CNN_LAYER_2_HEIGHT
#undef CNN_LAYER_2_WIDTH
#undef CNN_LAYER_2_IN_CH
#undef CNN_LAYER_2_OUT_CH
#undef CNN_LAYER_2_HORZ_STRIDE
#undef CNN_LAYER_2_VERT_STRIDE
#undef CNN_LAYER_3_HEIGHT
#undef CNN_LAYER_3_WIDTH
#undef CNN_LAYER_3_IN_CH
#undef CNN_LAYER_3_OUT_CH
#undef CNN_LAYER_3_HORZ_STRIDE
#undef CNN_LAYER_3_VERT_STRIDE
#undef CNN_LAYER_4_HEIGHT
#undef CNN_LAYER_4_WIDTH
#undef CNN_LAYER_4_IN_CH
#undef CNN_LAYER_4_OUT_CH
#undef CNN_LAYER_4_HORZ_STRIDE
#undef CNN_LAYER_4_VERT_STRIDE
#undef BRANCH_0_NUM_DNN_FEATURES
#undef BRANCH_0_NUM_DNN_LAYER_0_UNITS
#undef BRANCH_0_NUM_DNN_LAYER_1_UNITS
#undef BRANCH_0_NUM_LOGITS
#undef BRANCH_1_NUM_DNN_FEATURES
#undef BRANCH_1_NUM_DNN_LAYER_0_UNITS
#undef BRANCH_1_NUM_DNN_LAYER_1_UNITS
#undef BRANCH_1_NUM_LOGITS
#undef BRANCH_2_NUM_DNN_FEATURES
#undef BRANCH_2_NUM_DNN_LAYER_0_UNITS
#undef BRANCH_2_NUM_DNN_LAYER_1_UNITS
#undef BRANCH_2_NUM_LOGITS
#undef BRANCH_3_NUM_DNN_FEATURES
#undef BRANCH_3_NUM_DNN_LAYER_0_UNITS
#undef BRANCH_3_NUM_DNN_LAYER_1_UNITS
#undef BRANCH_3_NUM_LOGITS

static const float av1_intra_mode_cnn_partition_split_thresh_hdres[5] = {
  100.000000f, 4.750139f, 1.655964f, 3.711212f, 0.963839f,
};

static const float av1_intra_mode_cnn_partition_no_split_thresh_hdres[5] = {
  -100.000000f, -2.404842f, -3.858223f, -2.041206f, -1.573735f,
};

static const float av1_intra_mode_cnn_partition_split_thresh_midres[5] = {
  100.000000f, 3.218737f, 2.657764f, 0.868458f, 2.454447f,
};

static const float av1_intra_mode_cnn_partition_no_split_thresh_midres[5] = {
  -100.000000f, -3.842426f, -4.005076f, -3.642994f, -2.467197f,
};

static const float av1_intra_mode_cnn_partition_split_thresh_lowres[5] = {
  100.000000f, 1.890757f, 2.658417f, 1.450626f, 1.833180f,
};

static const float av1_intra_mode_cnn_partition_no_split_thresh_lowres[5] = {
  -100.000000f, -4.100921f, -4.564202f, -5.695176f, -1.483546f,
};

static const float av1_intra_mode_cnn_partition_mean[1] = {
  1.191922f,
};

static const float av1_intra_mode_cnn_partition_std[1] = {
  1.730044f,
};

static const int quad_to_linear_0[1] = { 0 };
static const int quad_to_linear_1[4] = { 0, 1, 2, 3 };
static const int quad_to_linear_2[16] = { 0, 1, 4,  5,  2,  3,  6,  7,
                                          8, 9, 12, 13, 10, 11, 14, 15 };
static const int quad_to_linear_3[64] = {
  0,  1,  8,  9,  2,  3,  10, 11, 16, 17, 24, 25, 18, 19, 26, 27,
  4,  5,  12, 13, 6,  7,  14, 15, 20, 21, 28, 29, 22, 23, 30, 31,
  32, 33, 40, 41, 34, 35, 42, 43, 48, 49, 56, 57, 50, 51, 58, 59,
  36, 37, 44, 45, 38, 39, 46, 47, 52, 53, 60, 61, 54, 55, 62, 63
};

#ifdef __cplusplus
}  // extern "C"
#endif

#endif  // AOM_AV1_ENCODER_PARTITION_CNN_WEIGHTS_H_
