/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import jdplus.toolkit.base.core.ssf.likelihood.MarginalLikelihood;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class MarginalLikelihoodStatistics {
    private final double logLikelihood;
    private final double transformationAdjustment;
    private final int observationsCount;
    private final int estimatedParametersCount;
    private final int diffuseCount;
    private final double ssqErr;
    private final double logDeterminant;
    private final double diffuseCorrection;
    private final double marginalCorrection;

    public double getAdjustedLogLikelihood() {
        return this.logLikelihood + this.transformationAdjustment;
    }

    public int getEffectiveObservationsCount() {
        return this.observationsCount - this.diffuseCount;
    }

    public double aic() {
        return (double)(2 * this.estimatedParametersCount) - 2.0 * this.getAdjustedLogLikelihood();
    }

    public double aicc() {
        double neff = this.getEffectiveObservationsCount();
        double nhp = this.estimatedParametersCount;
        return -2.0 * (this.getAdjustedLogLikelihood() - nhp * neff / (neff - nhp - 1.0));
    }

    public double bic() {
        double neff = this.getEffectiveObservationsCount();
        double nhp = this.estimatedParametersCount;
        return -2.0 * this.getAdjustedLogLikelihood() + nhp * Math.log(neff);
    }

    public double hannanQuinn() {
        double neff = this.getEffectiveObservationsCount();
        double nhp = this.estimatedParametersCount;
        return -2.0 * (this.getAdjustedLogLikelihood() - nhp * Math.log(Math.log(neff)));
    }

    public static MarginalLikelihoodStatistics stats(MarginalLikelihood ml, double llcorrection, int nparams) {
        return MarginalLikelihoodStatistics.builder().logLikelihood(ml.logLikelihood()).transformationAdjustment(llcorrection).logDeterminant(ml.logDeterminant()).diffuseCorrection(ml.getDiffuseCorrection()).marginalCorrection(ml.getMarginalCorrection()).observationsCount(ml.dim()).diffuseCount(ml.getD()).estimatedParametersCount(nparams).ssqErr(ml.ssq()).build();
    }

    @Generated
    MarginalLikelihoodStatistics(double logLikelihood, double transformationAdjustment, int observationsCount, int estimatedParametersCount, int diffuseCount, double ssqErr, double logDeterminant, double diffuseCorrection, double marginalCorrection) {
        this.logLikelihood = logLikelihood;
        this.transformationAdjustment = transformationAdjustment;
        this.observationsCount = observationsCount;
        this.estimatedParametersCount = estimatedParametersCount;
        this.diffuseCount = diffuseCount;
        this.ssqErr = ssqErr;
        this.logDeterminant = logDeterminant;
        this.diffuseCorrection = diffuseCorrection;
        this.marginalCorrection = marginalCorrection;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public double getLogLikelihood() {
        return this.logLikelihood;
    }

    @Generated
    public double getTransformationAdjustment() {
        return this.transformationAdjustment;
    }

    @Generated
    public int getObservationsCount() {
        return this.observationsCount;
    }

    @Generated
    public int getEstimatedParametersCount() {
        return this.estimatedParametersCount;
    }

    @Generated
    public int getDiffuseCount() {
        return this.diffuseCount;
    }

    @Generated
    public double getSsqErr() {
        return this.ssqErr;
    }

    @Generated
    public double getLogDeterminant() {
        return this.logDeterminant;
    }

    @Generated
    public double getDiffuseCorrection() {
        return this.diffuseCorrection;
    }

    @Generated
    public double getMarginalCorrection() {
        return this.marginalCorrection;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarginalLikelihoodStatistics)) {
            return false;
        }
        MarginalLikelihoodStatistics other = (MarginalLikelihoodStatistics)o;
        if (Double.compare(this.getLogLikelihood(), other.getLogLikelihood()) != 0) {
            return false;
        }
        if (Double.compare(this.getTransformationAdjustment(), other.getTransformationAdjustment()) != 0) {
            return false;
        }
        if (this.getObservationsCount() != other.getObservationsCount()) {
            return false;
        }
        if (this.getEstimatedParametersCount() != other.getEstimatedParametersCount()) {
            return false;
        }
        if (this.getDiffuseCount() != other.getDiffuseCount()) {
            return false;
        }
        if (Double.compare(this.getSsqErr(), other.getSsqErr()) != 0) {
            return false;
        }
        if (Double.compare(this.getLogDeterminant(), other.getLogDeterminant()) != 0) {
            return false;
        }
        if (Double.compare(this.getDiffuseCorrection(), other.getDiffuseCorrection()) != 0) {
            return false;
        }
        return Double.compare(this.getMarginalCorrection(), other.getMarginalCorrection()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $logLikelihood = Double.doubleToLongBits(this.getLogLikelihood());
        result = result * 59 + (int)($logLikelihood >>> 32 ^ $logLikelihood);
        long $transformationAdjustment = Double.doubleToLongBits(this.getTransformationAdjustment());
        result = result * 59 + (int)($transformationAdjustment >>> 32 ^ $transformationAdjustment);
        result = result * 59 + this.getObservationsCount();
        result = result * 59 + this.getEstimatedParametersCount();
        result = result * 59 + this.getDiffuseCount();
        long $ssqErr = Double.doubleToLongBits(this.getSsqErr());
        result = result * 59 + (int)($ssqErr >>> 32 ^ $ssqErr);
        long $logDeterminant = Double.doubleToLongBits(this.getLogDeterminant());
        result = result * 59 + (int)($logDeterminant >>> 32 ^ $logDeterminant);
        long $diffuseCorrection = Double.doubleToLongBits(this.getDiffuseCorrection());
        result = result * 59 + (int)($diffuseCorrection >>> 32 ^ $diffuseCorrection);
        long $marginalCorrection = Double.doubleToLongBits(this.getMarginalCorrection());
        result = result * 59 + (int)($marginalCorrection >>> 32 ^ $marginalCorrection);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "MarginalLikelihoodStatistics(logLikelihood=" + this.getLogLikelihood() + ", transformationAdjustment=" + this.getTransformationAdjustment() + ", observationsCount=" + this.getObservationsCount() + ", estimatedParametersCount=" + this.getEstimatedParametersCount() + ", diffuseCount=" + this.getDiffuseCount() + ", ssqErr=" + this.getSsqErr() + ", logDeterminant=" + this.getLogDeterminant() + ", diffuseCorrection=" + this.getDiffuseCorrection() + ", marginalCorrection=" + this.getMarginalCorrection() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private double logLikelihood;
        @Generated
        private double transformationAdjustment;
        @Generated
        private int observationsCount;
        @Generated
        private int estimatedParametersCount;
        @Generated
        private int diffuseCount;
        @Generated
        private double ssqErr;
        @Generated
        private double logDeterminant;
        @Generated
        private double diffuseCorrection;
        @Generated
        private double marginalCorrection;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder logLikelihood(double logLikelihood) {
            this.logLikelihood = logLikelihood;
            return this;
        }

        @Generated
        public @NonNull Builder transformationAdjustment(double transformationAdjustment) {
            this.transformationAdjustment = transformationAdjustment;
            return this;
        }

        @Generated
        public @NonNull Builder observationsCount(int observationsCount) {
            this.observationsCount = observationsCount;
            return this;
        }

        @Generated
        public @NonNull Builder estimatedParametersCount(int estimatedParametersCount) {
            this.estimatedParametersCount = estimatedParametersCount;
            return this;
        }

        @Generated
        public @NonNull Builder diffuseCount(int diffuseCount) {
            this.diffuseCount = diffuseCount;
            return this;
        }

        @Generated
        public @NonNull Builder ssqErr(double ssqErr) {
            this.ssqErr = ssqErr;
            return this;
        }

        @Generated
        public @NonNull Builder logDeterminant(double logDeterminant) {
            this.logDeterminant = logDeterminant;
            return this;
        }

        @Generated
        public @NonNull Builder diffuseCorrection(double diffuseCorrection) {
            this.diffuseCorrection = diffuseCorrection;
            return this;
        }

        @Generated
        public @NonNull Builder marginalCorrection(double marginalCorrection) {
            this.marginalCorrection = marginalCorrection;
            return this;
        }

        @Generated
        public @NonNull MarginalLikelihoodStatistics build() {
            return new MarginalLikelihoodStatistics(this.logLikelihood, this.transformationAdjustment, this.observationsCount, this.estimatedParametersCount, this.diffuseCount, this.ssqErr, this.logDeterminant, this.diffuseCorrection, this.marginalCorrection);
        }

        @Generated
        public @NonNull String toString() {
            return "MarginalLikelihoodStatistics.Builder(logLikelihood=" + this.logLikelihood + ", transformationAdjustment=" + this.transformationAdjustment + ", observationsCount=" + this.observationsCount + ", estimatedParametersCount=" + this.estimatedParametersCount + ", diffuseCount=" + this.diffuseCount + ", ssqErr=" + this.ssqErr + ", logDeterminant=" + this.logDeterminant + ", diffuseCorrection=" + this.diffuseCorrection + ", marginalCorrection=" + this.marginalCorrection + ")";
        }
    }
}

