/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.internal.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;
import standalone_spreadsheet.nbbrd.io.function.IOSupplier;

public final class InternalResource {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static byte[] readAllBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        InternalResource.transferTo(stream, result);
        return result.toByteArray();
    }

    public static void transferTo(InputStream input, OutputStream output) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = input.read(buffer, 0, 8192)) >= 0) {
            output.write(buffer, 0, read);
        }
    }

    public static InputStream openInputStream(IOSupplier<? extends InputStream> source) throws IOException {
        return InternalResource.checkResource(source.getWithIO(), "Missing InputStream");
    }

    public static OutputStream openOutputStream(IOSupplier<? extends OutputStream> source) throws IOException {
        return InternalResource.checkResource(source.getWithIO(), "Missing OutputStream");
    }

    public static <T extends Closeable> T checkResource(T resource, String message) throws IOException {
        if (resource == null) {
            throw new IOException(message);
        }
        return resource;
    }

    @Generated
    private InternalResource() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

