/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp.stream;

import java.io.IOException;
import java.util.Objects;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.stream.DataSetTs;
import jdplus.toolkit.base.tsp.stream.HasTsStream;
import jdplus.toolkit.base.tsp.util.DataSourcePreconditions;
import lombok.Generated;
import lombok.NonNull;

public final class NoOpTsStream
implements HasTsStream {
    @NonNull
    private final String providerName;

    @Override
    @NonNull
    public Stream<DataSetTs> getData(@NonNull DataSource dataSource, @NonNull TsInformationType type) throws IllegalArgumentException, IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider(this.providerName, dataSource);
        Objects.requireNonNull(type);
        return Stream.empty();
    }

    @Override
    @NonNull
    public Stream<DataSetTs> getData(@NonNull DataSet dataSet, @NonNull TsInformationType type) throws IllegalArgumentException, IOException {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider(this.providerName, dataSet);
        Objects.requireNonNull(type);
        return Stream.empty();
    }

    @Generated
    public NoOpTsStream(@NonNull String providerName) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        this.providerName = providerName;
    }
}

