README
================

<!-- README.md is generated from README.Rmd. Please edit that file -->

# plotor <a href="https://craig-parylo.github.io/plotor/"><img src="man/figures/logo.png" alt="plotor website" align="right" height="138"/></a>

<!-- badges: start -->

[![CRAN
status](https://www.r-pkg.org/badges/version/plotor)](https://CRAN.R-project.org/package=plotor)
[![](https://cranlogs.r-pkg.org/badges/plotor)](https://cran.r-project.org/package=plotor)
[![License:
MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

<!-- badges: end -->

**plotor** makes it easy to generate clear, publication-ready
**odds-ratio plots** and **tables** from logistic regression models.

If you work with binary outcomes, plotor helps you go from model →
interpretation in seconds.

## What plotor does

- Produces clean, ggplot2-based **odds ratio plots**
- Generates **tidy odds ratio tables** (with optional mini-plots)
- Provides **automated assumption checks** for logistic regression
- Works seamlessly with the tidyverse

## Example outputs

### Odds ratio plot

A single function call gives you a polished OR plot:

<!-- <br> -->

<div style="
  box-shadow: 0 4px 12px rgba(0,0,0,0.15); 
  display: inline-block; 
  padding: 12px;
  max-width: 100%;
">

<img 
    src="man/figures/readme_plot_or.png" 
    alt="Odds ratio plot showing likelihood of survival of the Titanic disaster by class, sex and age" style="max-width: 100%; height: auto;" />

</div>

<br>

[See full plot options
→](https://craig-parylo.github.io/plotor/reference/plot_or.html)

### Odds ratio table with mini-plot

Perfect for reports and publications:

<div style="
  box-shadow: 0 4px 12px rgba(0,0,0,0.15); 
  display: inline-block; 
  padding: 12px;
  max-width: 100%;
">

<img 
    src="man/figures/readme_table_or.png" 
    alt="Odds ratio table showing likelihood of survival of the Titanic disaster by class, sex and age" style="max-width: 100%; height: auto;" />

</div>

<br>

[See full table output options
→](https://craig-parylo.github.io/plotor/reference/table_or.html)

### Automated assumption checks

**plotor** includes built-in checks to help validate your logistic
regression model:

<div style="
  box-shadow: 0 4px 12px rgba(0,0,0,0.15); 
  display: inline-block; 
  padding: 12px;
  max-width: 100%;
">

<img 
    src="man/figures/readme_check_or.png" 
    alt="Console output showing the results of logistic regression assumption checks" style="max-width: 100%; height: auto;" />

</div>

<br>

[See full assumption check output
→](https://craig-parylo.github.io/plotor/reference/check_or.html)

## Installation

Stable release (CRAN):

``` r
install.packages("plotor")
```

Using {pak}:

``` r
# install.packages("pak")
pak::pak("plotor")
```

Development version:

``` r
# install.packages("pak")
pak::pak("craig-parylo/plotor")
```

## Minimal example

``` r
library(plotor)

# load the titanic dataset from the package
df_titanic <- get_df_titanic()

# make a logistic regression model using this data
model <- stats::glm(
  data = df_titanic,
  formula = Survived ~ Class + Sex + Age,
  family = "binomial"
)

# plot the odds ratios
plot_or(model)
```

## Learn more

- Plotting odds ratios: `?plot_or`
- Tabulating odds ratios: `?table_or`
- Assumption checks: `?check_or`

Full documentation: <https://craig-parylo.github.io/plotor/>
