/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.BiConsumer;
import lombok.NonNull;

@FunctionalInterface
public interface IOBiConsumer<T, U> {
    public void acceptWithIO(T var1, U var2) throws IOException;

    @NonNull
    default public IOBiConsumer<T, U> andThen(@NonNull IOBiConsumer<? super T, ? super U> after) {
        if (after == null) {
            throw new NullPointerException("after is marked non-null but is null");
        }
        return (l, r) -> {
            this.acceptWithIO(l, r);
            after.acceptWithIO(l, r);
        };
    }

    @NonNull
    default public BiConsumer<T, U> asUnchecked() {
        return (t, u) -> {
            try {
                this.acceptWithIO(t, u);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    @NonNull
    public static <T, U> BiConsumer<T, U> unchecked(@NonNull IOBiConsumer<T, U> o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return o.asUnchecked();
    }

    @NonNull
    public static <T, U> IOBiConsumer<T, U> checked(@NonNull BiConsumer<T, U> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return (t, u) -> {
            try {
                consumer.accept(t, u);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        };
    }

    @NonNull
    public static <T, U> IOBiConsumer<T, U> noOp() {
        return (t, u) -> {};
    }
}

