/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.calendars;

import java.time.DayOfWeek;
import java.time.LocalDate;
import jdplus.toolkit.base.api.timeseries.ValidityPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.EasterRelatedDay;
import jdplus.toolkit.base.api.timeseries.calendars.FixedDay;
import jdplus.toolkit.base.api.timeseries.calendars.FixedWeekDay;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import jdplus.toolkit.base.api.timeseries.calendars.PrespecifiedHoliday;
import jdplus.toolkit.base.api.timeseries.calendars.SingleDate;
import jdplus.toolkit.base.core.timeseries.calendars.EasterDayInfo;
import jdplus.toolkit.base.core.timeseries.calendars.FixedDayInfo;
import jdplus.toolkit.base.core.timeseries.calendars.FixedWeekDayInfo;
import jdplus.toolkit.base.core.timeseries.calendars.SingleDateInfo;

public interface HolidayInfo {
    public LocalDate getDay();

    default public DayOfWeek getDayOfWeek() {
        return this.getDay().getDayOfWeek();
    }

    public static LocalDate getPreviousWorkingDate(LocalDate date, int[] nonworking) {
        int dw = date.getDayOfWeek().getValue();
        for (int i = 0; i < nonworking.length; ++i) {
            int del;
            if (dw != nonworking[i]) continue;
            for (del = 1; del < nonworking.length; ++del) {
                int j;
                int pdw = dw - del;
                if (pdw <= 0) {
                    pdw += 7;
                }
                boolean wd = true;
                for (j = i - 1; j >= 0; --j) {
                    if (nonworking[j] != pdw) continue;
                    wd = false;
                    break;
                }
                if (wd) {
                    for (j = nonworking.length - 1; j > i; --j) {
                        if (nonworking[j] != pdw) continue;
                        wd = false;
                        break;
                    }
                }
                if (wd) break;
            }
            return date.minusDays(del);
        }
        return date;
    }

    public static LocalDate getNextWorkingDate(LocalDate date, int[] nonworking) {
        int dw = date.getDayOfWeek().getValue();
        for (int i = 0; i < nonworking.length; ++i) {
            int del;
            if (dw != nonworking[i]) continue;
            for (del = 1; del < nonworking.length; ++del) {
                int j;
                int pdw = dw + del;
                if (pdw > 7) {
                    pdw -= 7;
                }
                boolean wd = true;
                for (j = i + 1; j < nonworking.length; ++j) {
                    if (nonworking[j] != pdw) continue;
                    wd = false;
                    break;
                }
                if (wd) {
                    for (j = 0; j < i; ++j) {
                        if (nonworking[j] != pdw) continue;
                        wd = false;
                        break;
                    }
                }
                if (wd) break;
            }
            return date.plusDays(del);
        }
        return date;
    }

    public static FixedDayInfo of(FixedDay fday, int year) {
        return new FixedDayInfo(year, fday);
    }

    public static EasterDayInfo of(EasterRelatedDay fday, int year) {
        return new EasterDayInfo(year, fday.getOffset(), fday.isJulian());
    }

    public static FixedWeekDayInfo of(FixedWeekDay fday, int year) {
        return new FixedWeekDayInfo(year, fday);
    }

    public static HolidayInfo of(Holiday holiday, int year) {
        if (holiday instanceof FixedDay) {
            return new FixedDayInfo(year, (FixedDay)holiday);
        }
        if (holiday instanceof EasterRelatedDay) {
            return HolidayInfo.of((EasterRelatedDay)holiday, year);
        }
        if (holiday instanceof FixedWeekDay) {
            return HolidayInfo.of((FixedWeekDay)holiday, year);
        }
        if (holiday instanceof PrespecifiedHoliday) {
            PrespecifiedHoliday ph = (PrespecifiedHoliday)holiday;
            return HolidayInfo.of(ph.rawHoliday(), year);
        }
        throw new IllegalArgumentException();
    }

    public static Iterable<HolidayInfo> iterable(Holiday holiday, LocalDate fstart, LocalDate fend) {
        if (holiday instanceof FixedDay) {
            return new FixedDayInfo.FixedDayIterable((FixedDay)holiday, fstart, fend);
        }
        if (holiday instanceof EasterRelatedDay) {
            EasterRelatedDay eday = (EasterRelatedDay)holiday;
            ValidityPeriod vp = eday.getValidityPeriod();
            if (vp.getStart().isAfter(fstart)) {
                fstart = vp.getStart();
            }
            if (vp.getEnd().isBefore(fend)) {
                fend = vp.getEnd();
            }
            return new EasterDayInfo.EasterDayList(eday.getOffset(), eday.isJulian(), fstart, fend);
        }
        if (holiday instanceof FixedWeekDay) {
            FixedWeekDay fwd = (FixedWeekDay)holiday;
            return new FixedWeekDayInfo.FixedWeekDayIterable(fwd, fstart, fend);
        }
        if (holiday instanceof PrespecifiedHoliday) {
            PrespecifiedHoliday ph = (PrespecifiedHoliday)holiday;
            return HolidayInfo.iterable(ph.rawHoliday(), fstart, fend);
        }
        if (holiday instanceof SingleDate) {
            SingleDate fd = (SingleDate)holiday;
            return new SingleDateInfo.SingleDateIterable(fd, fstart, fend);
        }
        throw new IllegalArgumentException();
    }
}

