# spacemodR

[![Documentation](https://img.shields.io/badge/documentation-online-blue.svg)](https://qonfluens.github.io/spacemodR/)

**Spacemod Habitat, Trophic, Dispersal, Exposure and Risk Mapping**

`spacemodR` is an R package designed for spatial ecological risk modeling.
It integrates habitats, trophic webs, dispersal, and contaminant exposure 
to build complex "spacemodels" linking geographic data (rasters, vectors) 
with biological interactions.

## 📦 Installation

The package is automatically built via GitHub Actions. You can install it by 
retrieving the archive generated by the continuous integration system.

### Via GitHub Action Artifact

The `.github/workflows/build_and_release.yaml` workflow is configured to build 
the package and check its integrity on every push to the `main` branch.
To install the latest version:

1. Go to the **Actions** tab of the GitHub repository.
2. Click on the latest run of the **"Build and Archive"** workflow.
3. At the bottom of the page, in the **Artifacts** section, download the `spacemodR-archive` file.
4. Unzip the file to obtain the `.tar.gz` source file.
5. Install the package in R using the following command:

```r
# Replace the path with the location of your downloaded file
install.packages("path/to/spacemodR_0.1.0.tar.gz", repos = NULL, type = "source")
```

Note: Ensure that system dependencies (GDAL, PROJ, GEOS) are installed, 
as the package depends on `sf` and `terra`.

# Using the docker file

```
docker build -t spacemodr .
```

```
docker run --rm -ti \
  -p 8787:8787 \
  -e PASSWORD=mdp \
  -v /home/virgile/Downloads:/home/rstudio/data \
  spacemodr
```

Go to `http://localhost:8787`, where user is `rstudio` and password: `mdp`.
