## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  eval = FALSE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
#  library(mrap)

## -----------------------------------------------------------------------------
#  "package::function(Petal.Length ~ Species), data = iris"
#  "package::function(iris$Petal.Length ~ iris$Species), data = iris"

## -----------------------------------------------------------------------------
#  "package::function(cbind(Petal.Length, Petal.Width) ~ Species), data = iris"

## -----------------------------------------------------------------------------
#  "package::function(setosa$Petal.Length, virginica$Petal.Length)"

## -----------------------------------------------------------------------------
#  "package::function(one_vector, another_vector)"

## -----------------------------------------------------------------------------
#  "lme4::lmer(Reaction ~ Days + (Days | Subject), data = sleepstudy)"
#  "lme4::lmer(Reaction ~ Days + (Days || Subject), data = sleepstudy)"

## -----------------------------------------------------------------------------
#  "lme4::lmer(math ~ homework + (homework | schid) + (class_size | schid))"

## -----------------------------------------------------------------------------
#  "lme4::lmer(math ~ homework + (1 | schid) + (1 | classid))"

## -----------------------------------------------------------------------------
#  is.character("ABC")

## -----------------------------------------------------------------------------
#  is.data.frame(iris)

## -----------------------------------------------------------------------------
#  species_list <- list("setosa" = setosa, "virginica" = virginica)
#  # check it is a list
#  is.list(species_list)
#  # check that the list is named
#  names(species_list)

## -----------------------------------------------------------------------------
#  is.data.frame(iris)

## -----------------------------------------------------------------------------
#  # assume you have a few data frames in a list
#  iris_new <- iris[, -1]
#  my_results <- list(iris, iris_new)
#  # check each of them in a loop
#  for (element in my_results) {
#    print(is.data.frame(element))
#  }

## -----------------------------------------------------------------------------
#  inst_gc <-
#    mrap::group_comparison(
#      "stats::t.test(setosa, virginica, var.equal = FALSE)",
#      list("setosa" = setosa, "virginica" = virginica),
#      df_results
#    )

## -----------------------------------------------------------------------------
#  inst_gc$targets <- "Petal.Length"

## -----------------------------------------------------------------------------
#  inst_da <- mrap::data_analysis(inst_gc)

## -----------------------------------------------------------------------------
#  inst_da_all <- mrap::data_analysis(list(inst_preprocessing, inst_regression))

## -----------------------------------------------------------------------------
#  json <- mrap::to_jsonld(inst_da)
#  write(json, "data-analysis-1.json")

## -----------------------------------------------------------------------------
#  data(iris)
#  library(dplyr)
#  setosa <- iris |>
#    dplyr::filter(Species == "setosa") |>
#    dplyr::select(Petal.Length)
#  virginica <- iris |>
#    dplyr::filter(Species == "virginica") |>
#    dplyr::select(Petal.Length)
#  tt <- stats::t.test(setosa, virginica, var.equal = FALSE)

## -----------------------------------------------------------------------------
#  df_results <- data.frame(
#    t.statistic = tt$statistic,
#    df = tt$parameter,
#    p.value = tt$p.value
#  )
#  rownames(df_results) <- "value"

## -----------------------------------------------------------------------------
#  inst_gc <-
#    mrap::group_comparison(
#      "stats::t.test(setosa, virginica, var.equal = FALSE)",
#      list("setosa" = setosa, "virginica" = virginica),
#      df_results
#    )
#  
#  inst_gc$targets <- "Petal.Length"
#  inst_da <- mrap::data_analysis(inst_gc)
#  json <- mrap::to_jsonld(inst_da)
#  write(json, "data-analysis-1.json")

## -----------------------------------------------------------------------------
#  eval_results <- list(F1 = 0.46, recall = 0.51)

## -----------------------------------------------------------------------------
#  inst_ae <- algorithm_evaluation("N/A", "data_url", eval_results)

## -----------------------------------------------------------------------------
#  inst_ae$evaluates <- "my_algorithm_name"
#  inst_ae$evaluates_for <- "Classification"

## -----------------------------------------------------------------------------
#  data(iris)
#  anova_stats_results <- stats::aov(Petal.Length ~ Species, data = iris)

## -----------------------------------------------------------------------------
#  aov <- mrap::stats_aov(Petal.Length ~ Species, data = iris)

## -----------------------------------------------------------------------------
#  anova_mrap_results <- aov$anova

## -----------------------------------------------------------------------------
#  inst_gc_anova <- aov$dtreg_object

## -----------------------------------------------------------------------------
#  inst_gc_anova$label <- "my_fancy_results"

