% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boolean.R
\name{is_null_or_true}
\alias{is_null_or_true}
\title{Is an Object \code{\link[base:TRUE]{TRUE}} or \code{\link[base:NULL]{NULL}}?}
\usage{
is_null_or_true(x)
}
\arguments{
\item{x}{The object to be tested.}
}
\value{
\code{\link[base:TRUE]{TRUE}} if the object is set to
\code{\link[base:TRUE]{TRUE}} or \code{\link[base:NULL]{NULL}},
\code{\link[base:FALSE]{FALSE}}
otherwise.
}
\description{
Is an object \code{\link[base:TRUE]{TRUE}} or \code{\link[base:NULL]{NULL}}?
}
\examples{
is_null_or_true("true") # FALSE
is_null_or_true(TRUE) # TRUE
is_null_or_true(NULL) # TRUE
suppressWarnings(rm("not_defined"))
try(is_null_or_true(not_defined)) # error
}
\seealso{
Other logical helpers: 
\code{\link{get_run_r_tests}()},
\code{\link{is_batch}()},
\code{\link{is_cran}()},
\code{\link{is_false}()},
\code{\link{is_force}()},
\code{\link{is_installed}()},
\code{\link{is_not_false}()},
\code{\link{is_of_length_zero}()},
\code{\link{is_r_cmd_check}()},
\code{\link{is_r_package_installed}()},
\code{\link{is_running_on_fvafrcu_machines}()},
\code{\link{is_running_on_gitlab_com}()},
\code{\link{is_success}()},
\code{\link{is_version_sufficient}()},
\code{\link{is_windows}()}
}
\concept{logical helpers}
