/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp;

import internal.toolkit.base.tsp.UriBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import jdplus.toolkit.base.tsp.fixme.SortedMaps;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class DataSource {
    @NonNull
    private final String providerName;
    @NonNull
    private final String version;
    @NonNull
    private final SortedMap<String, String> parameters;
    private static final String SCHEME = "demetra";
    private static final String HOST = "tsprovider";

    public @Nullable String getParameter(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (String)this.getParameters().get(key);
    }

    public String toString() {
        return DataSource.formatAsUri(this).buildString();
    }

    @NonNull
    public URI toURI() {
        return DataSource.formatAsUri(this).build();
    }

    @NonNull
    public static DataSource parse(@NonNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return DataSource.parseAsUri(URI.create(input.toString()));
    }

    @NonNull
    public static DataSource parseURI(@NonNull URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        return DataSource.parseAsUri(uri);
    }

    @NonNull
    public static DataSource of(@NonNull String providerName, @NonNull String version) {
        Objects.requireNonNull(providerName, "providerName");
        Objects.requireNonNull(version, "version");
        return new DataSource(providerName, version, Collections.emptySortedMap());
    }

    @NonNull
    public static DataSource of(@NonNull String providerName, @NonNull String version, @NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Objects.requireNonNull(providerName, "providerName");
        Objects.requireNonNull(version, "version");
        return new DataSource(providerName, version, SortedMaps.immutableOf(key, value));
    }

    @NonNull
    public static DataSource deepCopyOf(@NonNull String providerName, @NonNull String version, @NonNull Map<String, String> params) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        Objects.requireNonNull(providerName, "providerName");
        Objects.requireNonNull(version, "version");
        return new DataSource(providerName, version, SortedMaps.immutableCopyOf(params));
    }

    @NonNull
    public static Builder builder(@NonNull String providerName, @NonNull String version) {
        Objects.requireNonNull(providerName, "providerName");
        Objects.requireNonNull(version, "version");
        return new Builder().providerName(providerName).version(version);
    }

    private static DataSource parseAsUri(URI uri) throws IllegalArgumentException {
        if (!SCHEME.equals(uri.getScheme())) {
            throw new IllegalArgumentException("Invalid scheme: " + uri.getScheme());
        }
        if (!HOST.equals(uri.getHost())) {
            throw new IllegalArgumentException("Invalid host: " + uri.getHost());
        }
        String[] path = UriBuilder.getPathArray(uri, 2);
        if (path == null) {
            throw new IllegalArgumentException("Invalid path: " + uri.getRawPath());
        }
        Map<String, String> query = UriBuilder.getQueryMap(uri);
        if (query == null) {
            throw new IllegalArgumentException("Invalid query: " + uri.getRawQuery());
        }
        return new DataSource(path[0], path[1], SortedMaps.immutableCopyOf(query));
    }

    private static UriBuilder formatAsUri(DataSource value) {
        return new UriBuilder(SCHEME, HOST).path(value.getProviderName(), value.getVersion()).query(value.getParameters());
    }

    @Generated
    DataSource(@NonNull String providerName, @NonNull String version, @NonNull SortedMap<String, String> parameters) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.providerName = providerName;
        this.version = version;
        this.parameters = parameters;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().providerName(this.providerName).version(this.version);
        if (this.parameters != null) {
            builder.parameters(this.parameters);
        }
        return builder;
    }

    @NonNull
    @Generated
    public String getProviderName() {
        return this.providerName;
    }

    @NonNull
    @Generated
    public String getVersion() {
        return this.version;
    }

    @NonNull
    @Generated
    public SortedMap<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)o;
        String this$providerName = this.getProviderName();
        String other$providerName = other.getProviderName();
        if (this$providerName == null ? other$providerName != null : !this$providerName.equals(other$providerName)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        SortedMap<String, String> this$parameters = this.getParameters();
        SortedMap<String, String> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $providerName = this.getProviderName();
        result = result * 59 + ($providerName == null ? 43 : $providerName.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        SortedMap<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private String providerName;
        @Generated
        private String version;
        @Generated
        private ArrayList<String> parameters$key;
        @Generated
        private ArrayList<String> parameters$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder providerName(@NonNull String providerName) {
            if (providerName == null) {
                throw new NullPointerException("providerName is marked non-null but is null");
            }
            this.providerName = providerName;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder version(@NonNull String version) {
            if (version == null) {
                throw new NullPointerException("version is marked non-null but is null");
            }
            this.version = version;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder parameter(String parameterKey, String parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder parameters(@org.jspecify.annotations.NonNull Map<? extends String, ? extends String> parameters) {
            if (parameters == null) {
                throw new NullPointerException("parameters cannot be null");
            }
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearParameters() {
            if (this.parameters$key != null) {
                this.parameters$key.clear();
                this.parameters$value.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull DataSource build() {
            TreeMap<String, String> parameters = new TreeMap();
            if (this.parameters$key != null) {
                for (int $i = 0; $i < (this.parameters$key == null ? 0 : this.parameters$key.size()); ++$i) {
                    parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                }
            }
            parameters = Collections.unmodifiableSortedMap(parameters);
            return new DataSource(this.providerName, this.version, parameters);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "DataSource.Builder(providerName=" + this.providerName + ", version=" + this.version + ", parameters$key=" + String.valueOf(this.parameters$key) + ", parameters$value=" + String.valueOf(this.parameters$value) + ")";
        }
    }

    public static interface Converter<P> {
        @NonNull
        public P getDefaultValue();

        @NonNull
        public P get(@NonNull DataSource var1);

        public void set(@NonNull Builder var1, @Nullable P var2);
    }
}

