/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.util;

import java.time.LocalDate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdplus.toolkit.base.api.timeseries.TsException;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.text.Parser;

public final class StrangeParsers {
    private static final Pattern REGEX = Pattern.compile("(\\d+)-?([QMYST])(\\d+)");
    private static final int YEAR = 1;
    private static final int FREQ = 2;
    private static final int POS = 3;

    @NonNull
    public static Parser<LocalDate> yearFreqPosParser() {
        return StrangeParsers::parseYearFreqPos;
    }

    private static LocalDate parseYearFreqPos(CharSequence input) {
        Matcher m = REGEX.matcher(input);
        if (m.matches()) {
            try {
                return StrangeParsers.toDate(Integer.parseInt(m.group(1)), m.group(2).charAt(0), Integer.parseInt(m.group(3)));
            }
            catch (NumberFormatException | TsException ex) {
                return null;
            }
        }
        return null;
    }

    private static LocalDate toDate(int year, char freq, int pos) {
        switch (freq) {
            case 'Q': {
                return LocalDate.of(year, (pos - 1) * 3 + 1, 1);
            }
            case 'M': {
                return LocalDate.of(year, pos, 1);
            }
            case 'Y': {
                return LocalDate.of(year, 1, 1);
            }
            case 'S': {
                return LocalDate.of(year, (pos - 1) * 6 + 1, 1);
            }
            case 'T': {
                return LocalDate.of(year, (pos - 1) * 4 + 1, 1);
            }
        }
        throw new RuntimeException();
    }

    @Generated
    private StrangeParsers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

