/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.text;

import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import standalone_spreadsheet.nbbrd.io.text.BaseProperty;
import standalone_spreadsheet.nbbrd.io.text.Formatter;
import standalone_spreadsheet.nbbrd.io.text.Parser;

public final class IntProperty
extends BaseProperty {
    @NonNull
    private final String key;
    private final int defaultValue;

    public int get(@NonNull Function<? super String, ? extends CharSequence> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        CharSequence value = properties.apply(this.key);
        if (value == null) {
            return this.defaultValue;
        }
        Integer result = Parser.onInteger().parse(value);
        return result != null ? result : this.defaultValue;
    }

    public int get(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::getProperty);
    }

    public int get(@NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::get);
    }

    public void set(@NonNull BiConsumer<? super String, ? super String> properties, int value) {
        String valueAsString;
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (value != this.defaultValue && (valueAsString = Formatter.onInteger().formatAsString(value)) != null) {
            properties.accept(this.key, valueAsString);
        }
    }

    public void set(@NonNull Properties properties, int value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::setProperty, value);
    }

    public void set(@NonNull Map<String, String> properties, int value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::put, value);
    }

    @Generated
    private IntProperty(@NonNull String key, int defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull IntProperty of(@NonNull String key, int defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new IntProperty(key, defaultValue);
    }

    @Override
    @NonNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public int getDefaultValue() {
        return this.defaultValue;
    }
}

