/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.math.matrices;

import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.BaseTable;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.LightMatrix;
import jdplus.toolkit.base.api.math.matrices.LightMutableMatrix;
import jdplus.toolkit.base.api.math.matrices.LightMutableSubMatrix;
import jdplus.toolkit.base.api.math.matrices.LightSubMatrix;
import lombok.NonNull;

public interface Matrix
extends BaseTable {
    public static Matrix empty() {
        return LightMatrix.empty();
    }

    public static Matrix of(@NonNull double[] data, int nrows, int ncolumns) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (data.length < nrows * ncolumns) {
            throw new IllegalArgumentException();
        }
        return new LightMatrix(data, nrows, ncolumns);
    }

    public static Matrix copyOf(@NonNull Matrix matrix) {
        if (matrix == null) {
            throw new NullPointerException("matrix is marked non-null but is null");
        }
        return new LightMatrix(matrix.toArray(), matrix.getRowsCount(), matrix.getColumnsCount());
    }

    public double get(int var1, int var2);

    public DoubleSeq row(@NonNull int var1);

    public DoubleSeq diagonal();

    public DoubleSeq subDiagonal(int var1);

    public DoubleSeq column(@NonNull int var1);

    default public Matrix extract(int rstart, int nr, int cstart, int nc) {
        return new LightSubMatrix(this, rstart, nr, cstart, nc);
    }

    default public void copyTo(@NonNull double[] buffer, int offset) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        int pos = offset;
        int nr = this.getRowsCount();
        int nc = this.getColumnsCount();
        for (int c = 0; c < nc; ++c) {
            this.column(c).copyTo(buffer, pos);
            pos += nr;
        }
    }

    @NonNull
    default public double[] toArray() {
        double[] all = new double[this.size()];
        int pos = 0;
        int nr = this.getRowsCount();
        int nc = this.getColumnsCount();
        for (int c = 0; c < nc; ++c) {
            this.column(c).copyTo(all, pos);
            pos += nr;
        }
        return all;
    }

    public static String toString(Matrix matrix, String fmt) {
        StringBuilder builder = new StringBuilder();
        if (!matrix.isEmpty()) {
            DoubleSeq row = matrix.row(0);
            builder.append(DoubleSeq.format(row, fmt));
            for (int i = 1; i < matrix.getRowsCount(); ++i) {
                builder.append(System.lineSeparator());
                row = matrix.row(i);
                builder.append(DoubleSeq.format(row, fmt));
            }
        }
        return builder.toString();
    }

    public static String format(Matrix m, String fmt) {
        StringBuilder builder = new StringBuilder();
        int nrows = m.getRowsCount();
        if (nrows > 0) {
            builder.append(DoubleSeq.format(m.row(0), fmt));
            for (int r = 1; r < nrows; ++r) {
                builder.append(System.lineSeparator());
                builder.append(DoubleSeq.format(m.row(r), fmt));
            }
        }
        return builder.toString();
    }

    public static String format(Matrix m) {
        StringBuilder builder = new StringBuilder();
        int nrows = m.getRowsCount();
        if (nrows > 0) {
            builder.append(DoubleSeq.format(m.row(0)));
            for (int r = 1; r < nrows; ++r) {
                builder.append(System.lineSeparator());
                builder.append(DoubleSeq.format(m.row(r)));
            }
        }
        return builder.toString();
    }

    @FunctionalInterface
    public static interface MatrixFunction {
        public double apply(int var1, int var2);
    }

    public static interface Mutable
    extends Matrix {
        @Override
        public DoubleSeq.Mutable row(@NonNull int var1);

        @Override
        public DoubleSeq.Mutable diagonal();

        @Override
        public DoubleSeq.Mutable subDiagonal(int var1);

        @Override
        public DoubleSeq.Mutable column(@NonNull int var1);

        @Override
        default public Mutable extract(int rstart, int nr, int cstart, int nc) {
            return new LightMutableSubMatrix(this, rstart, nr, cstart, nc);
        }

        public void set(int var1, int var2, double var3) throws IndexOutOfBoundsException;

        public void apply(int var1, int var2, DoubleUnaryOperator var3);

        default public Matrix unmodifiable() {
            return Matrix.of(this.toArray(), this.getRowsCount(), this.getColumnsCount());
        }

        public static Mutable ofInternal(@NonNull double[] data, int nrows, int ncolumns) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            if (data.length < nrows * ncolumns) {
                throw new IllegalArgumentException();
            }
            return new LightMutableMatrix(data, nrows, ncolumns);
        }

        public static Mutable make(int nrows, int ncolumns) {
            return new LightMutableMatrix(new double[nrows * ncolumns], nrows, ncolumns);
        }

        public static Mutable copyOf(@NonNull Matrix matrix) {
            if (matrix == null) {
                throw new NullPointerException("matrix is marked non-null but is null");
            }
            return new LightMutableMatrix(matrix.toArray(), matrix.getRowsCount(), matrix.getColumnsCount());
        }
    }
}

