/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.api;

import java.util.Comparator;
import java.util.List;
import jdplus.toolkit.base.api.design.ExtensionPoint;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.DiagnosticsConfiguration;
import jdplus.toolkit.base.api.processing.DiagnosticsFactory;
import jdplus.toolkit.base.api.processing.ProcDiagnostic;

@ExtensionPoint
public interface SaDiagnosticsFactory<C extends DiagnosticsConfiguration, R>
extends DiagnosticsFactory<C, R> {
    public Scope getScope();

    public int getOrder();

    default public SaDiagnosticsFactory<C, R> activate(boolean active) {
        if (this.isActive() == active) {
            return this;
        }
        return this.with(this.getConfiguration().activate(active));
    }

    public SaDiagnosticsFactory<C, R> with(C var1);

    default public void fill(List<ProcDiagnostic> tests, List<String> warnings, R sa, String category) {
        if (sa == null) {
            return;
        }
        Diagnostics diags = this.of(sa);
        if (diags == null) {
            return;
        }
        for (String test : diags.getTests()) {
            ProcDiagnostic item = ProcDiagnostic.builder().diagnostic(test).category(category).quality(diags.getDiagnostic(test)).value(diags.getValue(test)).build();
            tests.add(item);
        }
        if (warnings != null) {
            warnings.addAll(diags.getWarnings());
        }
    }

    public static class Ordering
    implements Comparator<SaDiagnosticsFactory> {
        @Override
        public int compare(SaDiagnosticsFactory diag1, SaDiagnosticsFactory diag2) {
            int o2;
            int s1 = diag1.getScope().value;
            int s2 = diag2.getScope().value;
            if (s1 < s2) {
                return -1;
            }
            if (s1 > s2) {
                return 1;
            }
            int o1 = diag1.getOrder();
            if (o1 < (o2 = diag2.getOrder())) {
                return -1;
            }
            if (o1 > o2) {
                return 1;
            }
            return 0;
        }
    }

    public static enum Scope {
        General(0),
        Preliminary(1),
        Modelling(2),
        Decomposition(3),
        Final(4);

        private final int value;

        private Scope(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }
    }
}

