/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.api;

import java.util.ArrayList;
import java.util.List;
import jdplus.sa.base.api.SaDefinition;
import jdplus.sa.base.api.SaEstimation;
import jdplus.sa.base.api.SaOutputFactory;
import jdplus.sa.base.api.SaOutputFactoryLoader;
import jdplus.sa.base.api.SaProcessingFactory;
import jdplus.sa.base.api.SaProcessingFactoryLoader;
import jdplus.sa.base.api.SaProcessor;
import jdplus.sa.base.api.SaSpecification;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.processing.AlgorithmDescriptor;
import jdplus.toolkit.base.api.processing.DefaultProcessingLog;
import jdplus.toolkit.base.api.processing.ProcDiagnostic;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import lombok.Generated;

public final class SaManager {
    public static List<SaProcessingFactory> processors() {
        return SaProcessingFactoryLoader.get();
    }

    public static List<SaOutputFactory> outputFactories() {
        return SaOutputFactoryLoader.get();
    }

    public static void reload() {
        SaProcessingFactoryLoader.reload();
        SaOutputFactoryLoader.reload();
    }

    public static Explorable process(TsData series, SaSpecification spec, ModellingContext context, ProcessingLog log) {
        List<SaProcessingFactory> all = SaManager.processors();
        for (SaProcessingFactory fac : all) {
            Object dspec = fac.decode(spec);
            if (dspec == null) continue;
            return fac.processor(dspec).process(series, context, log);
        }
        return null;
    }

    public static SaEstimation process(SaDefinition def, ModellingContext context, boolean verbose) {
        List<SaProcessingFactory> all = SaManager.processors();
        SaSpecification spec = def.activeSpecification();
        for (SaProcessingFactory fac : all) {
            Object dspec = fac.decode(spec);
            if (dspec == null) continue;
            ProcessingLog log = verbose ? new DefaultProcessingLog() : ProcessingLog.dummy();
            SaProcessor processor = fac.processor(dspec);
            GenericExplorable rslt = processor.process(def.getTs().getData(), context, log);
            if (rslt.isValid()) {
                ArrayList<String> warnings = new ArrayList<String>();
                ArrayList<ProcDiagnostic> tests = new ArrayList<ProcDiagnostic>();
                fac.fillDiagnostics(tests, warnings, rslt);
                SaSpecification pspec = fac.generateSpec(spec, rslt);
                ProcQuality quality = ProcDiagnostic.summary(tests);
                return SaEstimation.builder().results(rslt).diagnostics(tests).quality(quality).warnings(warnings).pointSpec(pspec).build();
            }
            return SaEstimation.builder().results(rslt).quality(ProcQuality.Undefined).build();
        }
        return null;
    }

    public static SaEstimation resetQuality(SaEstimation estimation) {
        GenericExplorable rslt = estimation.getResults();
        if (rslt == null) {
            return estimation.withQuality(ProcQuality.Undefined);
        }
        List<SaProcessingFactory> all = SaManager.processors();
        SaSpecification spec = estimation.getPointSpec();
        for (SaProcessingFactory fac : all) {
            Object dspec = fac.decode(spec);
            if (dspec == null) continue;
            ArrayList<String> warnings = new ArrayList<String>();
            ArrayList<ProcDiagnostic> tests = new ArrayList<ProcDiagnostic>();
            fac.fillDiagnostics(tests, warnings, rslt);
            return estimation.toBuilder().quality(ProcDiagnostic.summary(tests)).warnings(warnings).build();
        }
        return estimation.withQuality(ProcQuality.Undefined);
    }

    public static <I extends SaSpecification> SaProcessingFactory factoryFor(SaSpecification spec) {
        List<SaProcessingFactory> all = SaManager.processors();
        return all.stream().filter(p -> p.canHandle(spec)).findFirst().orElseThrow();
    }

    public static <I extends SaSpecification> SaProcessingFactory factoryFor(AlgorithmDescriptor desc) {
        List<SaProcessingFactory> all = SaManager.processors();
        return all.stream().filter(p -> p.descriptor().isCompatible(desc)).findFirst().orElseThrow();
    }

    @Generated
    private SaManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

