/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.modelling;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.core.data.analysis.WindowFunction;
import jdplus.toolkit.base.core.modelling.regular.tests.CanovaHansenForTradingDays;
import jdplus.toolkit.base.core.modelling.regular.tests.TimeVaryingEstimator;
import jdplus.toolkit.base.core.modelling.regular.tests.TradingDaysTest;
import jdplus.toolkit.base.core.regsarima.ami.SarimaTradingDaysTest;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import lombok.Generated;

public final class TradingDaysTests {
    public static double[] canovaHansen(TsData s, int[] diff, String kernel, int truncation) {
        if (truncation < 0) {
            truncation = (int)Math.floor(0.75 * Math.sqrt(s.length()));
        }
        CanovaHansenForTradingDays ch = CanovaHansenForTradingDays.test((TsData)s).differencingLags(diff).windowFunction(WindowFunction.valueOf((String)kernel)).truncationLag(truncation).build();
        double[] test = new double[10];
        for (int i = 0; i < 6; ++i) {
            test[i] = ch.test(i);
        }
        test[6] = ch.testDerived();
        test[7] = ch.testAll();
        StatisticalTest tdTest = ch.tdTest();
        test[8] = tdTest.getValue();
        test[9] = tdTest.getPvalue();
        return test;
    }

    public static StatisticalTest fTest(TsData s, String model, int ny) {
        s = s.cleanExtremities();
        int freq = s.getAnnualFrequency();
        TsData slast = s;
        if (ny != 0) {
            slast = s.drop(Math.max(0, s.length() - freq * ny), 0);
        }
        if (model.equalsIgnoreCase("D1")) {
            return TradingDaysTest.olsTest((TsData)slast, (int[])new int[]{1});
        }
        if (model.equalsIgnoreCase("DY")) {
            return TradingDaysTest.olsTest((TsData)slast, (int[])new int[]{freq});
        }
        if (model.equalsIgnoreCase("DYD1")) {
            return TradingDaysTest.olsTest((TsData)slast, (int[])new int[]{freq, 1});
        }
        if (model.equalsIgnoreCase("WN")) {
            return TradingDaysTest.olsTest((TsData)slast, null);
        }
        if (model.equalsIgnoreCase("AIRLINE")) {
            SarimaOrders orders = SarimaOrders.airline((int)freq);
            SarimaModel arima = SarimaModel.builder((SarimaOrders)orders).setDefault().build();
            return SarimaTradingDaysTest.sarimaTest((TsData)slast, (SarimaModel)arima, (boolean)false);
        }
        if (model.equalsIgnoreCase("R011")) {
            SarimaOrders orders = SarimaOrders.m011((int)freq);
            SarimaModel arima = SarimaModel.builder((SarimaOrders)orders).setDefault().build();
            return SarimaTradingDaysTest.sarimaTest((TsData)slast, (SarimaModel)arima, (boolean)false);
        }
        if (model.equalsIgnoreCase("R100")) {
            SarimaOrders orders = new SarimaOrders(freq);
            orders.setP(1);
            SarimaModel arima = SarimaModel.builder((SarimaOrders)orders).setDefault().build();
            return SarimaTradingDaysTest.sarimaTest((TsData)slast, (SarimaModel)arima, (boolean)true);
        }
        return null;
    }

    public static StatisticalTest timeVaryingTradingDaysTest(TsData s, int[] td, boolean onContrasts) {
        DayClustering dc = DayClustering.of((int[])td);
        TimeVaryingEstimator estimator = new TimeVaryingEstimator();
        return estimator.process(s, dc, onContrasts);
    }

    @Generated
    private TradingDaysTests() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

