/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.FilterUtility;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.PolynomialException;
import jdplus.toolkit.base.core.math.polynomials.RootsSolver;
import jdplus.toolkit.base.core.math.polynomials.UnitRootsSolver;

public final class ForeFilter
implements IFiniteFilter {
    public static final ForeFilter ZERO = new ForeFilter(Polynomial.ZERO);
    public static final ForeFilter ONE = new ForeFilter(Polynomial.ONE);
    private final Polynomial polynomial;

    public static ForeFilter add(double d, ForeFilter l) {
        Polynomial p = l.polynomial.plus(d);
        return new ForeFilter(p);
    }

    public static ForeFilter multiply(double d, ForeFilter l) {
        Polynomial p = l.polynomial.times(d);
        return new ForeFilter(p);
    }

    public static ForeFilter ofInternal(double[] coefficients) {
        if (coefficients.length == 1) {
            if (coefficients[0] == 1.0) {
                return ONE;
            }
            if (coefficients[0] == 0.0) {
                return ZERO;
            }
        }
        return new ForeFilter(Polynomial.ofInternal(coefficients));
    }

    public ForeFilter(Polynomial p) {
        this.polynomial = p;
    }

    public DoubleSeq coefficients() {
        return this.polynomial.coefficients();
    }

    public ForeFilter divide(ForeFilter r) {
        Polynomial.Division div = Polynomial.divide(this.polynomial, r.polynomial);
        if (!div.getRemainder().isZero()) {
            throw new PolynomialException("p_err_div");
        }
        return new ForeFilter(div.getQuotient());
    }

    public double get(int idx) {
        return this.polynomial.get(idx);
    }

    public Polynomial getPolynomial() {
        return this.polynomial;
    }

    public int getDegree() {
        return this.polynomial.degree();
    }

    @Override
    public int length() {
        return this.polynomial.degree() + 1;
    }

    @Override
    public int getLowerBound() {
        return 0;
    }

    @Override
    public int getUpperBound() {
        return this.polynomial.degree();
    }

    @Override
    public Complex frequencyResponse(double freq) {
        return FilterUtility.frequencyResponse(i -> this.polynomial.get(i), 0, this.polynomial.degree(), freq);
    }

    @Override
    public IntToDoubleFunction weights() {
        return i -> this.polynomial.get(i);
    }

    public Polynomial asPolynomial() {
        return this.polynomial;
    }

    public boolean isIdentity() {
        return this.polynomial.isIdentity();
    }

    public boolean isNull() {
        return this.polynomial.isZero();
    }

    public ForeFilter minus(double d) {
        Polynomial p = this.polynomial.minus(d);
        return new ForeFilter(p);
    }

    public ForeFilter minus(ForeFilter r) {
        Polynomial p = this.polynomial.minus(r.polynomial);
        return new ForeFilter(p);
    }

    @Override
    public BackFilter mirror() {
        return new BackFilter(this.polynomial);
    }

    public ForeFilter negate() {
        Polynomial p = this.polynomial.negate();
        return new ForeFilter(p);
    }

    public ForeFilter normalize() {
        double r = this.polynomial.get(0);
        if (r == 0.0 || r == 1.0) {
            return this;
        }
        return new ForeFilter(this.polynomial.times(1.0 / r));
    }

    public ForeFilter plus(double d) {
        Polynomial p = this.polynomial.plus(d);
        return new ForeFilter(p);
    }

    public ForeFilter plus(ForeFilter r) {
        Polynomial p = this.polynomial.plus(r.polynomial);
        return new ForeFilter(p);
    }

    public Complex[] roots() {
        return this.polynomial.roots();
    }

    public Complex[] roots(RootsSolver searcher) {
        return this.polynomial.roots(searcher);
    }

    public ForeFilter times(double d) {
        Polynomial p = this.polynomial.times(d);
        return new ForeFilter(p);
    }

    public ForeFilter times(ForeFilter r) {
        Polynomial p = this.polynomial.times(r.polynomial);
        return new ForeFilter(p);
    }

    public String toString() {
        return this.polynomial.toString('F', true);
    }

    public static class StationaryTransformation {
        public ForeFilter unitRoots;
        public ForeFilter stationaryFilter;
        private final int freq;

        public StationaryTransformation() {
            this.freq = 0;
        }

        public StationaryTransformation(int freq) {
            this.freq = freq;
        }

        public boolean transform(ForeFilter f) {
            UnitRootsSolver urs = this.freq == 0 ? new UnitRootsSolver() : new UnitRootsSolver(this.freq);
            urs.factorize(f.polynomial);
            this.unitRoots = new ForeFilter(urs.getUnitRoots().asPolynomial());
            if (this.unitRoots.getDegree() == 0) {
                this.stationaryFilter = f;
                return false;
            }
            this.stationaryFilter = new ForeFilter(urs.remainder());
            return true;
        }
    }
}

