/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.composite;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataWindow;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.SsfException;

public class CompositeDynamics
implements ISsfDynamics {
    private final ISsfDynamics[] dyn;
    private final int[] dim;

    public CompositeDynamics(int[] dim, ISsfDynamics ... dyn) {
        if (dim.length != dyn.length) {
            throw new SsfException("Invalid model definition");
        }
        this.dim = dim;
        this.dyn = dyn;
    }

    public int getComponentsCount() {
        return this.dyn.length;
    }

    public ISsfDynamics getComponent(int pos) {
        return this.dyn[pos];
    }

    @Override
    public boolean isTimeInvariant() {
        for (int i = 0; i < this.dyn.length; ++i) {
            if (this.dyn[i].isTimeInvariant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areInnovationsTimeInvariant() {
        for (int i = 0; i < this.dyn.length; ++i) {
            if (this.dyn[i].areInnovationsTimeInvariant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getInnovationsDim() {
        int ni = 0;
        for (int i = 0; i < this.dyn.length; ++i) {
            ni += this.dyn[i].getInnovationsDim();
        }
        return ni;
    }

    @Override
    public void V(int pos, FastMatrix qm) {
        MatrixWindow cur = qm.topLeft(0, 0);
        for (int i = 0; i < this.dyn.length; ++i) {
            this.dyn[i].V(pos, cur.next(this.dim[i], this.dim[i]));
        }
    }

    @Override
    public boolean hasInnovations(int pos) {
        for (int i = 0; i < this.dyn.length; ++i) {
            if (!this.dyn[i].hasInnovations(pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void S(int pos, FastMatrix sm) {
        MatrixWindow cur = sm.topLeft(0, 0);
        for (int i = 0; i < this.dyn.length; ++i) {
            int rcount = this.dim[i];
            int rdim = this.dyn[i].getInnovationsDim();
            FastMatrix next = cur.next(rcount, rdim);
            if (rdim <= 0) continue;
            this.dyn[i].S(pos, next);
        }
    }

    @Override
    public void addSU(int pos, DataBlock x, DataBlock u) {
        DataWindow xwnd = x.left();
        DataWindow uwnd = u.left();
        for (int i = 0; i < this.dyn.length; ++i) {
            int rcount = this.dim[i];
            int rdim = this.dyn[i].getInnovationsDim();
            DataBlock xcur = xwnd.next(rcount);
            if (rdim <= 0) continue;
            this.dyn[i].addSU(pos, xcur, uwnd.next(rdim));
        }
    }

    @Override
    public void XS(int pos, DataBlock x, DataBlock xs) {
        DataWindow xwnd = x.left();
        DataWindow ywnd = xs.left();
        for (int i = 0; i < this.dyn.length; ++i) {
            int rcount = this.dim[i];
            int rdim = this.dyn[i].getInnovationsDim();
            DataBlock xcur = xwnd.next(rcount);
            if (rdim <= 0) continue;
            this.dyn[i].XS(pos, xcur, ywnd.next(rdim));
        }
    }

    @Override
    public void T(int pos, FastMatrix tr) {
        MatrixWindow cur = tr.topLeft(0, 0);
        for (int i = 0; i < this.dyn.length; ++i) {
            this.dyn[i].T(pos, cur.next(this.dim[i], this.dim[i]));
        }
    }

    @Override
    public void TX(int pos, DataBlock x) {
        DataWindow cur = x.window(0, this.dim[0]);
        this.dyn[0].TX(pos, cur.get());
        for (int i = 1; i < this.dyn.length; ++i) {
            this.dyn[i].TX(pos, cur.next(this.dim[i]));
        }
    }

    @Override
    public void TM(int pos, FastMatrix x) {
        MatrixWindow cur = x.top(0);
        for (int i = 0; i < this.dyn.length; ++i) {
            this.dyn[i].TM(pos, cur.vnext(this.dim[i]));
        }
    }

    @Override
    public void XT(int pos, DataBlock x) {
        DataWindow cur = x.left();
        for (int i = 0; i < this.dyn.length; ++i) {
            this.dyn[i].XT(pos, cur.next(this.dim[i]));
        }
    }

    @Override
    public void TVT(int pos, FastMatrix v) {
        MatrixWindow D = v.topLeft(0, 0);
        for (int i = 0; i < this.dyn.length; ++i) {
            int ni = this.dim[i];
            FastMatrix nD = D.next(ni, ni);
            this.dyn[i].TVT(pos, nD);
            MatrixWindow C = MatrixWindow.of(nD);
            MatrixWindow R = MatrixWindow.of(nD);
            for (int j = i + 1; j < this.dyn.length; ++j) {
                int nj = this.dim[j];
                FastMatrix nC = C.vnext(nj);
                FastMatrix nR = R.hnext(nj);
                this.dyn[j].TM(pos, nC);
                this.dyn[i].MTt(pos, nC);
                nR.copyTranspose(nC);
            }
        }
    }

    @Override
    public void addV(int pos, FastMatrix p) {
        MatrixWindow cur = p.topLeft(0, 0);
        for (int i = 0; i < this.dyn.length; ++i) {
            this.dyn[i].addV(pos, cur.next(this.dim[i], this.dim[i]));
        }
    }
}

