## -----------------------------------------------------------------------------
library(orderly)

## ----include = FALSE----------------------------------------------------------
source("common.R")
path <- orderly::orderly_example("simple")
orderly::orderly_run("data", root = path)
gert::git_init(path)
gert::git_add(".", repo = path)
user <- "author <author@example.com>"
gert::git_commit("initial", author = user, committer = user, repo = path)

## ----error = TRUE, orderly_root = path----------------------------------------
try({
orderly_run("data")
})

## -----------------------------------------------------------------------------
options(orderly.git_error_is_warning = TRUE)

## ----orderly_root = path------------------------------------------------------
orderly_run("data")

## ----orderly_root = path------------------------------------------------------
orderly_run("data")

## ----include = FALSE----------------------------------------------------------
options(orderly.git_error_is_warning = FALSE)

