/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.regarima;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;
import jdplus.toolkit.base.api.util.Validatable;
import jdplus.x13.base.api.regarima.RegressionTestSpec;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TradingDaysSpec
implements Validatable<TradingDaysSpec> {
    public static final double DEF_AUTO_PVALUE1 = 0.01;
    public static final double DEF_AUTO_PVALUE2 = 0.1;
    public static final boolean DEF_ADJUST = true;
    private final String holidays;
    private final String[] userVariables;
    private final TradingDaysType tradingDaysType;
    private final LengthOfPeriodType lengthOfPeriodType;
    private final RegressionTestSpec regressionTestType;
    private final boolean autoAdjust;
    private final int stockTradingDays;
    private final AutoMethod automaticMethod;
    private final double autoPvalue1;
    private final double autoPvalue2;
    private final Parameter[] tdCoefficients;
    private final Parameter lpCoefficient;
    private static final TradingDaysSpec NONE = new TradingDaysSpec(null, null, TradingDaysType.NONE, LengthOfPeriodType.None, RegressionTestSpec.None, false, 0, AutoMethod.UNUSED, 0.0, 0.0, null, null);

    public static TradingDaysSpec stockTradingDays(int w, RegressionTestSpec test) {
        return new TradingDaysSpec(null, null, TradingDaysType.NONE, LengthOfPeriodType.None, test, false, w, AutoMethod.UNUSED, 0.0, 0.0, null, null);
    }

    public static TradingDaysSpec stockTradingDays(int w, Parameter[] tdc) {
        return new TradingDaysSpec(null, null, TradingDaysType.NONE, LengthOfPeriodType.None, RegressionTestSpec.None, false, w, AutoMethod.UNUSED, 0.0, 0.0, tdc, null);
    }

    public static TradingDaysSpec none() {
        return NONE;
    }

    public static TradingDaysSpec userDefined(@NonNull String[] vars, RegressionTestSpec test) {
        if (vars == null) {
            throw new NullPointerException("vars is marked non-null but is null");
        }
        return new TradingDaysSpec(null, vars, TradingDaysType.NONE, LengthOfPeriodType.None, test, false, 0, AutoMethod.UNUSED, 0.0, 0.0, null, null);
    }

    public static TradingDaysSpec userDefined(@NonNull String[] vars, Parameter[] tdcoeff) {
        if (vars == null) {
            throw new NullPointerException("vars is marked non-null but is null");
        }
        return new TradingDaysSpec(null, vars, TradingDaysType.NONE, LengthOfPeriodType.None, RegressionTestSpec.None, false, 0, AutoMethod.UNUSED, 0.0, 0.0, tdcoeff, null);
    }

    public static TradingDaysSpec holidays(String holidays, TradingDaysType type, LengthOfPeriodType lp, RegressionTestSpec test, boolean autoAdjust) {
        if (type == TradingDaysType.NONE) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(holidays, null, type, lp, test, autoAdjust, 0, AutoMethod.UNUSED, 0.0, 0.0, null, null);
    }

    public static TradingDaysSpec holidays(String holidays, TradingDaysType type, LengthOfPeriodType lp, Parameter[] tdcoeff, Parameter lpcoeff) {
        if (type == TradingDaysType.NONE) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(holidays, null, type, lp, RegressionTestSpec.None, false, 0, AutoMethod.UNUSED, 0.0, 0.0, tdcoeff, lpcoeff);
    }

    public static TradingDaysSpec td(TradingDaysType type, LengthOfPeriodType lp, RegressionTestSpec test, boolean autoAdjust) {
        if (type == TradingDaysType.NONE && lp == LengthOfPeriodType.None) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(null, null, type, lp, test, autoAdjust, 0, AutoMethod.UNUSED, 0.0, 0.0, null, null);
    }

    public static TradingDaysSpec td(TradingDaysType type, LengthOfPeriodType lp, Parameter[] tdcoeff, Parameter lpcoeff) {
        if (type == TradingDaysType.NONE && lp == LengthOfPeriodType.None) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(null, null, type, lp, RegressionTestSpec.None, false, 0, AutoMethod.UNUSED, 0.0, 0.0, tdcoeff, lpcoeff);
    }

    public static TradingDaysSpec automaticHolidays(String holidays, LengthOfPeriodType lp, AutoMethod automaticMethod, double pval1, double pval2, boolean autoadjust) {
        if (automaticMethod == AutoMethod.UNUSED) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(holidays, null, TradingDaysType.TD7, lp, RegressionTestSpec.None, autoadjust, 0, automaticMethod, pval1, pval2, null, null);
    }

    public static TradingDaysSpec automatic(LengthOfPeriodType lp, AutoMethod automaticMethod, double pval1, double pval2, boolean autoadjust) {
        if (automaticMethod == AutoMethod.UNUSED) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(null, null, TradingDaysType.TD7, lp, RegressionTestSpec.None, autoadjust, 0, automaticMethod, pval1, pval2, null, null);
    }

    public TradingDaysSpec withCoefficients(Parameter[] tdc, Parameter lpc) {
        return new TradingDaysSpec(this.holidays, this.userVariables, this.tradingDaysType, this.lengthOfPeriodType, RegressionTestSpec.None, false, this.stockTradingDays, this.automaticMethod, this.autoPvalue1, this.autoPvalue2, tdc, lpc);
    }

    public boolean isUsed() {
        return this.tradingDaysType != TradingDaysType.NONE || this.userVariables != null || this.stockTradingDays != 0;
    }

    public boolean isDefined() {
        return this.isUsed() && this.regressionTestType == RegressionTestSpec.None && this.automaticMethod == AutoMethod.UNUSED;
    }

    public boolean isAutomatic() {
        return this.automaticMethod != AutoMethod.UNUSED;
    }

    public boolean isStockTradingDays() {
        return this.stockTradingDays != 0;
    }

    public boolean isUserDefined() {
        return this.userVariables != null;
    }

    public boolean isDefaultTradingDays() {
        return this.userVariables == null && this.holidays == null && this.stockTradingDays == 0 && this.tradingDaysType != TradingDaysType.NONE;
    }

    public boolean isHolidays() {
        return this.holidays != null;
    }

    public boolean isValid() {
        if (this.isStockTradingDays()) {
            return true;
        }
        if (this.regressionTestType != RegressionTestSpec.None) {
            return this.tradingDaysType != TradingDaysType.NONE && this.lengthOfPeriodType != LengthOfPeriodType.None;
        }
        return true;
    }

    public boolean isDefault() {
        return this.equals(NONE);
    }

    public TradingDaysSpec validate() throws IllegalArgumentException {
        return this;
    }

    public boolean hasFixedCoefficients() {
        return this.lpCoefficient != null && this.lpCoefficient.isFixed() || Parameter.hasFixedParameters((Parameter[])this.tdCoefficients);
    }

    @Generated
    public String getHolidays() {
        return this.holidays;
    }

    @Generated
    public String[] getUserVariables() {
        return this.userVariables;
    }

    @Generated
    public TradingDaysType getTradingDaysType() {
        return this.tradingDaysType;
    }

    @Generated
    public LengthOfPeriodType getLengthOfPeriodType() {
        return this.lengthOfPeriodType;
    }

    @Generated
    public RegressionTestSpec getRegressionTestType() {
        return this.regressionTestType;
    }

    @Generated
    public boolean isAutoAdjust() {
        return this.autoAdjust;
    }

    @Generated
    public int getStockTradingDays() {
        return this.stockTradingDays;
    }

    @Generated
    public AutoMethod getAutomaticMethod() {
        return this.automaticMethod;
    }

    @Generated
    public double getAutoPvalue1() {
        return this.autoPvalue1;
    }

    @Generated
    public double getAutoPvalue2() {
        return this.autoPvalue2;
    }

    @Generated
    public Parameter[] getTdCoefficients() {
        return this.tdCoefficients;
    }

    @Generated
    public Parameter getLpCoefficient() {
        return this.lpCoefficient;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TradingDaysSpec)) {
            return false;
        }
        TradingDaysSpec other = (TradingDaysSpec)o;
        if (this.isAutoAdjust() != other.isAutoAdjust()) {
            return false;
        }
        if (this.getStockTradingDays() != other.getStockTradingDays()) {
            return false;
        }
        if (Double.compare(this.getAutoPvalue1(), other.getAutoPvalue1()) != 0) {
            return false;
        }
        if (Double.compare(this.getAutoPvalue2(), other.getAutoPvalue2()) != 0) {
            return false;
        }
        String this$holidays = this.getHolidays();
        String other$holidays = other.getHolidays();
        if (this$holidays == null ? other$holidays != null : !this$holidays.equals(other$holidays)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUserVariables(), other.getUserVariables())) {
            return false;
        }
        TradingDaysType this$tradingDaysType = this.getTradingDaysType();
        TradingDaysType other$tradingDaysType = other.getTradingDaysType();
        if (this$tradingDaysType == null ? other$tradingDaysType != null : !this$tradingDaysType.equals(other$tradingDaysType)) {
            return false;
        }
        LengthOfPeriodType this$lengthOfPeriodType = this.getLengthOfPeriodType();
        LengthOfPeriodType other$lengthOfPeriodType = other.getLengthOfPeriodType();
        if (this$lengthOfPeriodType == null ? other$lengthOfPeriodType != null : !this$lengthOfPeriodType.equals(other$lengthOfPeriodType)) {
            return false;
        }
        RegressionTestSpec this$regressionTestType = this.getRegressionTestType();
        RegressionTestSpec other$regressionTestType = other.getRegressionTestType();
        if (this$regressionTestType == null ? other$regressionTestType != null : !((Object)((Object)this$regressionTestType)).equals((Object)other$regressionTestType)) {
            return false;
        }
        AutoMethod this$automaticMethod = this.getAutomaticMethod();
        AutoMethod other$automaticMethod = other.getAutomaticMethod();
        if (this$automaticMethod == null ? other$automaticMethod != null : !((Object)((Object)this$automaticMethod)).equals((Object)other$automaticMethod)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTdCoefficients(), other.getTdCoefficients())) {
            return false;
        }
        Parameter this$lpCoefficient = this.getLpCoefficient();
        Parameter other$lpCoefficient = other.getLpCoefficient();
        return !(this$lpCoefficient == null ? other$lpCoefficient != null : !this$lpCoefficient.equals(other$lpCoefficient));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoAdjust() ? 79 : 97);
        result = result * 59 + this.getStockTradingDays();
        long $autoPvalue1 = Double.doubleToLongBits(this.getAutoPvalue1());
        result = result * 59 + (int)($autoPvalue1 >>> 32 ^ $autoPvalue1);
        long $autoPvalue2 = Double.doubleToLongBits(this.getAutoPvalue2());
        result = result * 59 + (int)($autoPvalue2 >>> 32 ^ $autoPvalue2);
        String $holidays = this.getHolidays();
        result = result * 59 + ($holidays == null ? 43 : $holidays.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getUserVariables());
        TradingDaysType $tradingDaysType = this.getTradingDaysType();
        result = result * 59 + ($tradingDaysType == null ? 43 : $tradingDaysType.hashCode());
        LengthOfPeriodType $lengthOfPeriodType = this.getLengthOfPeriodType();
        result = result * 59 + ($lengthOfPeriodType == null ? 43 : $lengthOfPeriodType.hashCode());
        RegressionTestSpec $regressionTestType = this.getRegressionTestType();
        result = result * 59 + ($regressionTestType == null ? 43 : ((Object)((Object)$regressionTestType)).hashCode());
        AutoMethod $automaticMethod = this.getAutomaticMethod();
        result = result * 59 + ($automaticMethod == null ? 43 : ((Object)((Object)$automaticMethod)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTdCoefficients());
        Parameter $lpCoefficient = this.getLpCoefficient();
        result = result * 59 + ($lpCoefficient == null ? 43 : $lpCoefficient.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "TradingDaysSpec(holidays=" + this.getHolidays() + ", userVariables=" + Arrays.deepToString(this.getUserVariables()) + ", tradingDaysType=" + String.valueOf(this.getTradingDaysType()) + ", lengthOfPeriodType=" + String.valueOf(this.getLengthOfPeriodType()) + ", regressionTestType=" + String.valueOf((Object)this.getRegressionTestType()) + ", autoAdjust=" + this.isAutoAdjust() + ", stockTradingDays=" + this.getStockTradingDays() + ", automaticMethod=" + String.valueOf((Object)this.getAutomaticMethod()) + ", autoPvalue1=" + this.getAutoPvalue1() + ", autoPvalue2=" + this.getAutoPvalue2() + ", tdCoefficients=" + Arrays.deepToString(this.getTdCoefficients()) + ", lpCoefficient=" + String.valueOf(this.getLpCoefficient()) + ")";
    }

    @Generated
    private TradingDaysSpec(String holidays, String[] userVariables, TradingDaysType tradingDaysType, LengthOfPeriodType lengthOfPeriodType, RegressionTestSpec regressionTestType, boolean autoAdjust, int stockTradingDays, AutoMethod automaticMethod, double autoPvalue1, double autoPvalue2, Parameter[] tdCoefficients, Parameter lpCoefficient) {
        this.holidays = holidays;
        this.userVariables = userVariables;
        this.tradingDaysType = tradingDaysType;
        this.lengthOfPeriodType = lengthOfPeriodType;
        this.regressionTestType = regressionTestType;
        this.autoAdjust = autoAdjust;
        this.stockTradingDays = stockTradingDays;
        this.automaticMethod = automaticMethod;
        this.autoPvalue1 = autoPvalue1;
        this.autoPvalue2 = autoPvalue2;
        this.tdCoefficients = tdCoefficients;
        this.lpCoefficient = lpCoefficient;
    }

    public static enum AutoMethod {
        UNUSED,
        WALD,
        BIC,
        AIC;

    }
}

